/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.datasource.composite;

import com.elixirtech.data2.DataException;
import com.elixirtech.data2.DataSourceManager;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.data2.datasource.DataSourceDefinition;
import com.elixirtech.data2.datasource.composite.InputDataSource;
import com.elixirtech.data2.datasource.composite.OutputDataSource;
import com.elixirtech.jdom.Element;
import java.util.Iterator;

public class OutputDefinition
extends DataSourceDefinition {
    @Override
    public IDataSource getDataSource(DataSourceManager dataSourceManager, Element element) throws DataException {
        if (!"datasource".equals(element.getName()) || element.getNamespace() != NS_DATASOURCE) {
            throw new IllegalArgumentException("Element " + element.getName() + " is not a ds:datasource");
        }
        String string = element.getAttributeValue("name");
        Element element2 = element.getChild("output", NS_DATASOURCE);
        if (element2 == null) {
            throw new DataException("Can't load output element");
        }
        String string2 = element2.getAttributeValue("input");
        InputDataSource inputDataSource = (InputDataSource)dataSourceManager.getDataSource(dataSourceManager, string2);
        OutputDataSource outputDataSource = new OutputDataSource(string, inputDataSource);
        for (Element element3 : element2.getChildren("parent", NS_DATASOURCE)) {
            String string3 = element3.getAttributeValue("name");
            IDataSource iDataSource = dataSourceManager.getDataSource(dataSourceManager, string3);
            outputDataSource.addParent(iDataSource);
        }
        return outputDataSource;
    }

    @Override
    public Element setDataSource(IDataSource iDataSource) throws DataException {
        if (!(iDataSource instanceof OutputDataSource)) {
            throw new IllegalArgumentException("Not an OutputDataSource");
        }
        OutputDataSource outputDataSource = (OutputDataSource)iDataSource;
        Element element = this.defineDataSource(outputDataSource);
        Element element2 = new Element("output", NS_DATASOURCE);
        element2.setAttribute("input", outputDataSource.getInput().getName());
        Iterator<IDataSource> iterator = outputDataSource.getParents();
        while (iterator.hasNext()) {
            IDataSource iDataSource2 = iterator.next();
            Element element3 = new Element("parent", NS_DATASOURCE);
            element3.setAttribute("name", iDataSource2.getName());
            element2.addContent(element3);
        }
        element.addContent(element2);
        return element;
    }
}

