/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.datasource.derivative;

import com.elixirtech.data2.DataRecord;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DataTable;
import com.elixirtech.data2.PushContext;
import com.elixirtech.data2.datasource.derivative.CrossJoinDerivative;
import com.elixirtech.data2.datasource.derivative.DerivativeContext;

class CrossJoinDerivativeContext
implements DerivativeContext {
    private final CrossJoinDerivative m_Derivative;
    protected DataTable m_Table;
    protected int[] m_OutOffsets;
    protected int[] m_SecondaryOffsets;

    public CrossJoinDerivativeContext(CrossJoinDerivative crossJoinDerivative) {
        this.m_Derivative = crossJoinDerivative;
    }

    @Override
    public void startData(PushContext pushContext, DataSchema dataSchema, DataSchema dataSchema2) {
        this.m_Table = DataTable.build(pushContext, this.m_Derivative.m_SecondarySource);
        DataSchema dataSchema3 = this.m_Derivative.m_SecondarySchema;
        int n = this.m_Derivative.m_Prefix.length();
        this.m_SecondaryOffsets = new int[this.m_Derivative.getColumnCount()];
        this.m_OutOffsets = new int[this.m_Derivative.getColumnCount()];
        for (int i = 0; i < this.m_OutOffsets.length; ++i) {
            String string = this.m_Derivative.getColumnName(i);
            String string2 = string.substring(n);
            this.m_SecondaryOffsets[i] = dataSchema3.getColumnIndex(string2);
            this.m_OutOffsets[i] = dataSchema2.getColumnIndex(string);
        }
    }

    @Override
    public void setData(DataRecord dataRecord) {
    }

    @Override
    public int getRowCount() {
        return this.m_Table.getRecordCount();
    }

    @Override
    public void getData(int n, Object[] objectArray) {
        DataRecord dataRecord = this.m_Table.getRecord(n);
        Object[] objectArray2 = dataRecord.getData();
        for (int i = 0; i < this.m_OutOffsets.length; ++i) {
            objectArray[this.m_OutOffsets[i]] = objectArray2[this.m_SecondaryOffsets[i]];
        }
    }

    @Override
    public void endData() {
        this.m_Table = null;
    }
}

