/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.datasource.derivative;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.data2.DataRecord;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.PushContext;
import com.elixirtech.data2.datasource.derivative.DateParserDerivative;
import com.elixirtech.data2.datasource.derivative.DerivativeContext;
import java.text.SimpleDateFormat;
import java.util.Date;

class DateParserDerivativeContext
implements DerivativeContext {
    private final DateParserDerivative m_Derivative;
    private final SimpleDateFormat m_InDateFormat;
    private Date m_InDate;
    private int m_InIdx;
    private int m_OutIdx;
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(DateParserDerivativeContext.class);

    public DateParserDerivativeContext(DateParserDerivative dateParserDerivative) {
        this.m_Derivative = dateParserDerivative;
        this.m_InDateFormat = new SimpleDateFormat(this.m_Derivative.m_ParseDateFormat);
    }

    @Override
    public void startData(PushContext pushContext, DataSchema dataSchema, DataSchema dataSchema2) {
        this.m_InIdx = dataSchema.getColumnIndex(this.m_Derivative.m_ColumnName);
        this.m_OutIdx = dataSchema2.getColumnIndex(this.m_Derivative.m_ColumnName);
    }

    @Override
    public void setData(DataRecord dataRecord) {
        try {
            this.m_InDate = this.m_InDateFormat.parse((String)dataRecord.getData(this.m_InIdx));
        }
        catch (Exception exception) {
            m_Log.error((Object)"Error in parsing date from parent column.", (Throwable)exception);
        }
    }

    @Override
    public int getRowCount() {
        return 1;
    }

    @Override
    public void getData(int n, Object[] objectArray) {
        objectArray[this.m_OutIdx] = this.m_InDate;
    }

    @Override
    public void endData() {
    }
}

