/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.datasource.derivative;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.arch.StringUtil;
import com.elixirtech.data2.DataRecord;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DataType;
import com.elixirtech.data2.PushContext;
import com.elixirtech.data2.RecordScope;
import com.elixirtech.data2.datasource.derivative.DerivativeContext;
import com.elixirtech.data2.datasource.derivative.JavaScriptDerivative;
import com.elixirtech.js.CompiledScript;
import com.elixirtech.js.JavaScriptEngine;
import com.elixirtech.js.ScriptException;
import java.util.ArrayList;
import java.util.List;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;

class JavaScriptDerivativeContext
implements DerivativeContext {
    private final JavaScriptDerivative m_Derivative;
    private final List<ColumnContext> m_ColumnContexts = new ArrayList<ColumnContext>();
    private CompiledScript m_PreProcessor;
    private DataSchema m_Schema;
    private String[] m_Names;
    private DataType[] m_Types;
    private RecordScope m_Scope;
    static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(JavaScriptDerivativeContext.class);
    static final ElxLoggerJ m_JSLog = ElxLoggerJ.getLogger((String)"JavaScript");

    public JavaScriptDerivativeContext(JavaScriptDerivative javaScriptDerivative) {
        this.m_Derivative = javaScriptDerivative;
        int n = this.m_Derivative.m_Columns.size();
        for (int i = 0; i < n; ++i) {
            this.m_ColumnContexts.add(new ColumnContext());
        }
    }

    @Override
    public void startData(PushContext pushContext, DataSchema dataSchema, DataSchema dataSchema2) {
        this.m_Schema = dataSchema2;
        this.m_Names = new String[dataSchema2.getColumnCount()];
        this.m_Types = new DataType[dataSchema2.getColumnCount()];
        for (int i = 0; i < this.m_Names.length; ++i) {
            this.m_Names[i] = dataSchema2.getColumnName(i);
            this.m_Types[i] = dataSchema2.getColumnType(i);
        }
        JavaScriptEngine javaScriptEngine = JavaScriptEngine.getInstance();
        this.m_Scope = new RecordScope(dataSchema);
        this.m_Scope.setContext(pushContext);
        if (StringUtil.notEmpty(this.m_Derivative.m_PreProcessing)) {
            this.m_PreProcessor = javaScriptEngine.compile("Derivative", pushContext.substitute(this.m_Derivative.m_PreProcessing));
        }
        int n = this.m_ColumnContexts.size();
        for (int i = 0; i < n; ++i) {
            JavaScriptDerivative.Column column = this.m_Derivative.m_Columns.get(i);
            ColumnContext columnContext = this.m_ColumnContexts.get(i);
            columnContext.index = dataSchema2.getColumnIndex(this.m_Derivative.getColumnName(i));
            columnContext.originalScript = pushContext.substitute(column.script);
            columnContext.compiledScript = javaScriptEngine.compile("Derivative", columnContext.originalScript);
        }
    }

    @Override
    public void getData(int n, Object[] objectArray) {
        int n2 = this.m_ColumnContexts.size();
        for (int i = 0; i < n2; ++i) {
            ColumnContext columnContext = this.m_ColumnContexts.get(i);
            objectArray[columnContext.index] = this.m_Schema.narrow(this.m_Types[columnContext.index], columnContext.result);
        }
    }

    @Override
    public int getRowCount() {
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setData(DataRecord dataRecord) {
        Object[] objectArray = dataRecord.getData();
        this.m_Scope.setData(objectArray);
        JavaScriptEngine javaScriptEngine = JavaScriptEngine.getInstance();
        javaScriptEngine.pushScope((Scriptable)this.m_Scope);
        try {
            if (this.m_PreProcessor != null) {
                try {
                    this.m_PreProcessor.eval((Scriptable)this.m_Scope);
                }
                catch (ScriptException scriptException) {
                    m_JSLog.warn((Object)("Script post-process error executing " + this.m_Derivative.m_PreProcessing + " : " + scriptException));
                }
            }
            int n = this.m_ColumnContexts.size();
            Object object = Context.getUndefinedValue();
            for (int i = 0; i < n; ++i) {
                JavaScriptDerivative.Column column = this.m_Derivative.m_Columns.get(i);
                ColumnContext columnContext = this.m_ColumnContexts.get(i);
                try {
                    columnContext.result = columnContext.compiledScript.eval((Scriptable)this.m_Scope);
                    if (m_Log.isDebugEnabled()) {
                        m_Log.debug((Object)("column " + i + " \"" + columnContext.originalScript + "\" returns " + columnContext.result));
                    }
                    if (columnContext.result == object) {
                        columnContext.result = null;
                    }
                    try {
                        columnContext.result = this.m_Schema.narrow(column.type, columnContext.result);
                    }
                    catch (Exception exception) {
                        m_Log.warn((Object)("Can't parse " + columnContext.result + " as a " + column.type.getTypeName()));
                    }
                    continue;
                }
                catch (ScriptException scriptException) {
                    m_JSLog.warn((Object)("Script error executing " + column.script + " : " + scriptException));
                    columnContext.result = null;
                }
            }
        }
        finally {
            javaScriptEngine.popScope();
        }
    }

    @Override
    public void endData() {
        this.m_Schema = null;
        this.m_Names = null;
        this.m_Types = null;
        for (ColumnContext columnContext : this.m_ColumnContexts) {
            columnContext.compiledScript = null;
        }
        this.m_PreProcessor = null;
    }

    private static class ColumnContext {
        public String originalScript;
        public CompiledScript compiledScript;
        public Object result;
        public int index;

        private ColumnContext() {
        }

        public String toString() {
            return this.originalScript + " returns " + this.result;
        }
    }
}

