/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.datasource.derivative;

import com.elixirtech.data2.ArgumentMap;
import com.elixirtech.data2.DataException;
import com.elixirtech.data2.DataListener;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DataType;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.data2.Parameter;
import com.elixirtech.data2.PushContext;
import com.elixirtech.data2.SchemaBuilder;
import com.elixirtech.data2.datasource.derivative.Derivative;
import com.elixirtech.data2.datasource.derivative.DerivativeContext;
import com.elixirtech.data2.datasource.derivative.JoinDerivativeContext;
import com.elixirtech.data2.datasource.derivative.Prefix;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public final class JoinDerivative
implements Derivative {
    public static final String KEEP = "Keep".intern();
    static final String REPEAT = "Repeat".intern();
    public static final String DISCARD = "Discard".intern();
    protected final IDataSource m_SecondarySource;
    protected final List<JoinInfo> m_Keys = new ArrayList<JoinInfo>();
    protected DataSchema m_OutputSchema;
    protected Prefix m_Prefix = Prefix.EMPTY;
    protected String m_ZeroAction = KEEP;
    protected String m_MultipleAction = REPEAT;
    protected Set<String> m_DiscardSet = Collections.emptySet();
    protected static final NullKey NULL_KEY = new NullKey();

    public JoinDerivative(IDataSource iDataSource, String string, String string2) {
        this(iDataSource);
        this.addJoin(string, string2);
    }

    public JoinDerivative(IDataSource iDataSource) {
        this.m_SecondarySource = iDataSource;
        this.m_OutputSchema = this.m_SecondarySource.getSchema();
    }

    @Override
    public DerivativeContext init(PushContext pushContext) {
        return new JoinDerivativeContext(this, pushContext);
    }

    @Override
    public void getParameters(ArgumentMap argumentMap) {
        List<Parameter> list = this.m_SecondarySource.getParameters();
        argumentMap.addParameters(list);
    }

    public void setDiscardSet(Set<String> set) {
        this.m_DiscardSet = set;
        SchemaBuilder schemaBuilder = new SchemaBuilder(this.m_SecondarySource.getSchema());
        schemaBuilder.discard(this.m_DiscardSet);
        this.m_OutputSchema = schemaBuilder.getSchema();
    }

    public Set<String> getDiscardSet() {
        return this.m_DiscardSet;
    }

    public String getSecondaryName() {
        return this.m_SecondarySource.getName();
    }

    public DataSchema getSecondarySchema() {
        return this.m_SecondarySource.getSchema();
    }

    public void pushSecondaryTo(PushContext pushContext, DataListener dataListener) throws DataException {
        this.m_SecondarySource.pushTo(pushContext, dataListener);
    }

    public void setZeroAction(String string) {
        this.m_ZeroAction = string.intern();
    }

    public String getZeroAction() {
        return this.m_ZeroAction;
    }

    public void setMultipleAction(String string) {
        this.m_MultipleAction = string.intern();
    }

    public String getMultipleAction() {
        return this.m_MultipleAction;
    }

    public void addJoin(String string, String string2) {
        this.m_Keys.add(new JoinInfo(string, string2));
    }

    public void setPrefix(Prefix prefix) {
        this.m_Prefix = prefix;
    }

    public Prefix getPrefix() {
        return this.m_Prefix;
    }

    public List<JoinInfo> getJoins() {
        return Collections.unmodifiableList(this.m_Keys);
    }

    @Override
    public int getColumnCount() {
        return this.m_OutputSchema.getColumnCount();
    }

    @Override
    public String getColumnName(int n) {
        String string = this.m_OutputSchema.getColumnName(n);
        return this.m_Prefix.apply(string);
    }

    @Override
    public DataType getColumnType(int n) {
        return this.m_OutputSchema.getColumnType(n);
    }

    public List<JoinInfo> getKeys() {
        return this.m_Keys;
    }

    protected static boolean safeEquals(Object object, Object object2) {
        if (object == null) {
            return object2 == null;
        }
        return object.equals(object2);
    }

    public static final class JoinInfo {
        public final String primary;
        public final String secondary;

        public JoinInfo(String string, String string2) {
            this.primary = string;
            this.secondary = string2;
        }
    }

    public static final class NullKey {
        public boolean equals(Object object) {
            return object instanceof NullKey;
        }
    }

    public static final class MultiKey {
        private final Object[] m_Data;
        private int m_HashCode;

        public MultiKey(Object[] objectArray) {
            this.m_Data = objectArray;
            this.buildHashCode();
        }

        public Object[] getData() {
            return this.m_Data;
        }

        public boolean equals(Object object) {
            if (!(object instanceof MultiKey)) {
                return false;
            }
            MultiKey multiKey = (MultiKey)object;
            if (this.m_Data.length == multiKey.m_Data.length) {
                for (int i = 0; i < this.m_Data.length; ++i) {
                    if (JoinDerivative.safeEquals(this.m_Data[i], multiKey.m_Data[i])) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        public int hashCode() {
            return this.m_HashCode;
        }

        private void buildHashCode() {
            this.m_HashCode = 0x55555555;
            for (int i = 0; i < this.m_Data.length; ++i) {
                if (this.m_Data[i] == null) continue;
                this.m_HashCode ^= this.m_Data[i].hashCode();
            }
        }
    }
}

