/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.datasource.derivative;

import com.elixirtech.data2.DataListener;
import com.elixirtech.data2.DataRecord;
import com.elixirtech.data2.PushContext;
import com.elixirtech.data2.datasource.derivative.AbstractTransformer;
import com.elixirtech.data2.datasource.derivative.DerivativeContext;
import com.elixirtech.data2.datasource.derivative.DerivedDataSource;

final class SingleTransformer
extends AbstractTransformer {
    public SingleTransformer(DerivedDataSource derivedDataSource, PushContext pushContext, DataListener dataListener) {
        super(derivedDataSource, pushContext, dataListener);
        assert (derivedDataSource.getDerivativeCount() == 1);
    }

    @Override
    public boolean processRecord(DataRecord dataRecord) {
        int n;
        assert (this.m_Derivatives.size() == 1);
        DerivativeContext derivativeContext = (DerivativeContext)this.m_Derivatives.get(0);
        derivativeContext.setData(dataRecord);
        Object[] objectArray = new Object[this.m_ColumnCount];
        Object[] objectArray2 = dataRecord.getData();
        if (this.m_InOrderLookup) {
            System.arraycopy(objectArray2, 0, objectArray, 0, this.m_ParentLookup.length);
        } else {
            for (n = 0; n < this.m_ParentLookup.length; ++n) {
                objectArray[n] = objectArray2[this.m_ParentLookup[n]];
            }
        }
        n = derivativeContext.getRowCount();
        if (n == 1) {
            derivativeContext.getData(0, objectArray);
            boolean bl = this.m_DataListener.processRecord(new DataRecord(this.m_Schema, objectArray));
            if (!bl) {
                return false;
            }
        } else {
            for (int i = 0; i < n; ++i) {
                Object[] objectArray3 = (Object[])objectArray.clone();
                derivativeContext.getData(i, objectArray3);
                boolean bl = this.m_DataListener.processRecord(new DataRecord(this.m_Schema, objectArray3));
                if (bl) continue;
                return false;
            }
        }
        return true;
    }
}

