/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.datasource.excel;

import com.elixirtech.arch.StringUtil;
import com.elixirtech.data2.DataException;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DataSourceManager;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.data2.datasource.DataSourceDefinition;
import com.elixirtech.data2.datasource.excel.ExcelDataSource;
import com.elixirtech.jdom.Element;

public class ExcelDefinition
extends DataSourceDefinition {
    public static final String URL = "url";
    public static final String RANGE = "range";
    public static final String FIRST_ROW_HEADER = "first-row-header";
    public static final String HEADER_ROW = "header-row";
    public static final String XLSX = "xlsx";

    @Override
    public IDataSource getDataSource(DataSourceManager dataSourceManager, Element element) throws DataException {
        if (!"datasource".equals(element.getName()) || element.getNamespace() != NS_DATASOURCE) {
            throw new IllegalArgumentException("Element " + element.getName() + " is not a ds:datasource");
        }
        String string = element.getAttributeValue("name");
        Element element2 = element.getChild("schema", NS_DATASOURCE);
        if (element2 == null) {
            throw new DataException("Can't load schema");
        }
        DataSchema dataSchema = ExcelDefinition.loadSchema(element2);
        Element element3 = element.getChild("excel", NS_DATASOURCE);
        if (element3 == null) {
            throw new DataException("Can't load excel element");
        }
        String string2 = element3.getAttributeValue(URL);
        String string3 = element3.getAttributeValue(RANGE);
        int n = 0;
        String string4 = element3.getAttributeValue(HEADER_ROW);
        if (StringUtil.notEmpty(string4)) {
            try {
                n = Integer.parseInt(string4);
            }
            catch (NumberFormatException numberFormatException) {}
        } else if ("Yes".equals(element3.getAttributeValue(FIRST_ROW_HEADER))) {
            n = 1;
        }
        String string5 = element3.getAttributeValue(XLSX);
        ExcelDataSource excelDataSource = new ExcelDataSource(string, dataSchema);
        excelDataSource.setURL(string2);
        excelDataSource.setRange(string3);
        excelDataSource.setDescription(element.getAttributeValue("description"));
        excelDataSource.setHeaderRow(n);
        excelDataSource.setXLSX("Yes".equals(string5));
        excelDataSource.setSecurity(this.loadSecurity(element));
        return excelDataSource;
    }

    @Override
    public Element setDataSource(IDataSource iDataSource) throws DataException {
        if (!(iDataSource instanceof ExcelDataSource)) {
            throw new IllegalArgumentException("Not a ExcelDataSource");
        }
        ExcelDataSource excelDataSource = (ExcelDataSource)iDataSource;
        Element element = this.defineDataSource(excelDataSource);
        ExcelDefinition.saveSchema(excelDataSource.getSchema(), element);
        this.saveSecurity(excelDataSource.getSecurity(), element);
        Element element2 = new Element("excel", NS_DATASOURCE);
        ExcelDefinition.setAttribute(element2, URL, excelDataSource.getURL());
        ExcelDefinition.setAttribute(element2, RANGE, excelDataSource.getRange());
        ExcelDefinition.setAttribute(element2, HEADER_ROW, excelDataSource.getHeaderRow());
        ExcelDefinition.setAttribute(element2, XLSX, excelDataSource.isXLSX() ? "Yes" : "No");
        element.addContent(element2);
        return element;
    }
}

