/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.datasource.excel;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.arch.util.URLLoader;
import com.elixirtech.data2.DataException;
import com.elixirtech.data2.DataGroup;
import com.elixirtech.data2.DataListener;
import com.elixirtech.data2.DataRecord;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DataType;
import com.elixirtech.data2.PushContext;
import com.elixirtech.data2.datasource.excel.ExcelDataSource;
import com.elixirtech.data2.datasource.excel.IExcelProcessor;
import com.elixirtech.data2.datasource.excel.Range;
import com.elixirtech.data2.datasource.excel.XInferSchema;
import com.elixirtech.data2.datasource.excel.XRangeBuilder;
import com.elixirtech.data2.xlsx.Cell;
import com.elixirtech.data2.xlsx.Sheet;
import com.elixirtech.data2.xlsx.Workbook;
import com.elixirtech.data2.xlsx.XLSXReader;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class XProcessor
implements IExcelProcessor {
    private final ExcelDataSource m_DataSource;
    private final DataSchema m_Schema;
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(XProcessor.class);

    public XProcessor(ExcelDataSource excelDataSource) {
        this.m_DataSource = excelDataSource;
        this.m_Schema = excelDataSource.getSchema();
    }

    @Override
    public DataSchema inferSchema(PushContext pushContext) {
        return XInferSchema.inferSchema(pushContext, this.m_DataSource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pushTo(PushContext pushContext, DataListener dataListener) {
        String string = this.m_DataSource.getURL();
        String string2 = this.m_DataSource.getRange();
        try {
            String string3 = pushContext.substitute(string);
            BufferedInputStream bufferedInputStream = null;
            Workbook workbook = null;
            try {
                bufferedInputStream = new BufferedInputStream(URLLoader.getInputStream(string3));
                workbook = XLSXReader.read(bufferedInputStream);
            }
            catch (Exception exception) {
                if (bufferedInputStream != null) {
                    ((InputStream)bufferedInputStream).close();
                }
                throw new RuntimeException("Error reading Workbook " + string3 + " : " + exception, exception);
            }
            Range range = XRangeBuilder.getRange(workbook, pushContext.substitute(string2));
            dataListener.startData(this.m_DataSource);
            try {
                this.processRange(dataListener, workbook, range);
            }
            catch (Exception exception) {
                m_Log.warn((Object)("Exception:" + exception), (Throwable)exception);
            }
            finally {
                dataListener.endData(this.m_DataSource);
            }
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException("URL error: " + pushContext.substitute(string), malformedURLException);
        }
        catch (IOException iOException) {
            throw new RuntimeException("IO error: " + pushContext.substitute(string), iOException);
        }
    }

    private void processRange(DataListener dataListener, Workbook workbook, Range range) throws DataException {
        if (Range.isValid(range)) {
            int n;
            m_Log.info((Object)("Processing range: " + range));
            int n2 = range.lastSheet - range.firstSheet + 1;
            range.top += this.m_DataSource.getHeaderRow();
            int n3 = range.right - range.left + 1;
            if (n3 > this.m_Schema.getColumnCount()) {
                n3 = this.m_Schema.getColumnCount();
            }
            DataType[] dataTypeArray = new DataType[n3];
            for (n = 0; n < n3; ++n) {
                dataTypeArray[n] = this.m_Schema.getColumnType(n);
            }
            for (n = range.firstSheet; n <= range.lastSheet; ++n) {
                Sheet sheet = workbook.getSheet(n);
                DataGroup dataGroup = null;
                if (n2 > 1) {
                    dataGroup = new DataGroup(1, "Group " + (n + 1));
                    dataListener.startGroup(dataGroup);
                }
                boolean bl = this.processRows(dataListener, range, n3, dataTypeArray, sheet);
                if (n2 > 1) {
                    dataListener.endGroup(dataGroup);
                }
                if (!bl) break;
            }
        }
    }

    private boolean processRows(DataListener dataListener, Range range, int n, DataType[] dataTypeArray, Sheet sheet) throws DataException {
        m_Log.info((Object)("processRows: " + range.top + "->" + range.bottom));
        for (int i = range.top; i <= range.bottom; ++i) {
            try {
                Cell[] cellArray = sheet.getRow(i);
                Object[] objectArray = this.buildData(range, n, dataTypeArray, cellArray);
                if (i == range.top) {
                    StringBuilder stringBuilder = new StringBuilder();
                    for (Object object : objectArray) {
                        stringBuilder.append(object).append(" ");
                    }
                    m_Log.info((Object)stringBuilder.toString());
                }
                if (this.isEmpty(objectArray) || dataListener.processRecord(new DataRecord(this.m_Schema, objectArray))) continue;
                return false;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                break;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                break;
            }
        }
        return true;
    }

    private boolean isEmpty(Object[] objectArray) {
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] == null) continue;
            return false;
        }
        return true;
    }

    private Object[] buildData(Range range, int n, DataType[] dataTypeArray, Cell[] cellArray) {
        Object[] objectArray = new Object[this.m_Schema.getColumnCount()];
        for (int i = 0; i < n; ++i) {
            try {
                Cell cell = cellArray[range.left + i];
                objectArray[i] = this.getDataValue(range, cell, dataTypeArray[i]);
                continue;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                objectArray[i] = null;
                continue;
            }
            catch (DataException dataException) {
                m_Log.warn((Object)("Load error: " + dataException), (Throwable)dataException);
                objectArray[i] = null;
            }
        }
        return objectArray;
    }

    private Object getDataValue(Range range, Cell cell, DataType dataType) throws DataException {
        if (cell == null) {
            return null;
        }
        int n = dataType.getTypeId();
        if (this.isDateBased(n) && cell instanceof Cell.DateCell) {
            return XProcessor.adjustDate(n, ((Cell.DateCell)cell).getValue());
        }
        if (this.isDateBased(n) && cell instanceof Cell.TimeCell) {
            return XProcessor.adjustDate(n, ((Cell.TimeCell)cell).getValue());
        }
        if (this.isDateBased(n) && cell instanceof Cell.TimestampCell) {
            return XProcessor.adjustDate(n, ((Cell.TimestampCell)cell).getValue());
        }
        if (dataType.isNumeric() && cell instanceof Cell.NumberCell) {
            Double d = ((Cell.NumberCell)cell).getValue();
            return this.m_Schema.narrow(dataType, d);
        }
        if (n == 3 && cell instanceof Cell.BooleanCell) {
            return ((Cell.BooleanCell)cell).getValue();
        }
        String string = cell.getValueString();
        return this.m_Schema.parse(dataType, string);
    }

    private boolean isDateBased(int n) {
        return n == 4 || n == 12 || n == 13;
    }

    private static Date adjustDate(int n, Date date) {
        if (n != 12) {
            return date;
        }
        Calendar calendar = Calendar.getInstance();
        TimeZone timeZone = TimeZone.getDefault();
        int n2 = timeZone.getRawOffset();
        if (timeZone.inDaylightTime(calendar.getTime())) {
            n2 += timeZone.getDSTSavings();
        }
        calendar.setTime(date);
        calendar.add(14, -n2);
        return calendar.getTime();
    }
}

