/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.datasource.filter;

import com.elixirtech.data2.AbstractDataSource;
import com.elixirtech.data2.ArgumentMap;
import com.elixirtech.data2.DataGroup;
import com.elixirtech.data2.DataListener;
import com.elixirtech.data2.DataListener2;
import com.elixirtech.data2.DataRecord;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.data2.Parameter;
import com.elixirtech.data2.PushContext;
import com.elixirtech.data2.datasource.filter.Filter;
import com.elixirtech.data2.datasource.filter.ICompositeFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class FilteredDataSource
extends AbstractDataSource
implements ICompositeFilter {
    protected boolean m_Disabled;
    protected String m_Name;
    protected IDataSource m_Parent;
    protected List<Filter> m_Filters;

    public FilteredDataSource(String string, IDataSource iDataSource) {
        this.m_Name = string;
        this.m_Parent = iDataSource;
    }

    public FilteredDataSource(String string, IDataSource iDataSource, Filter filter) {
        this(string, iDataSource);
        this.addFilter(filter);
    }

    public IDataSource getParent() {
        return this.m_Parent;
    }

    public void setParent(IDataSource iDataSource) {
        this.m_Parent = iDataSource;
    }

    @Override
    public void addFilter(Filter filter) {
        if (this.m_Filters == null) {
            this.m_Filters = new ArrayList<Filter>();
        }
        this.m_Filters.add(filter);
    }

    public int getFilterCount() {
        if (this.m_Filters == null) {
            return 0;
        }
        return this.m_Filters.size();
    }

    public Filter getFilter(int n) {
        return this.m_Filters.get(n);
    }

    public void setFilter(int n, Filter filter) {
        this.m_Filters.set(n, filter);
    }

    @Override
    public String getName() {
        return this.m_Name;
    }

    @Override
    public String getType() {
        return "Filter";
    }

    @Override
    public List<Parameter> getParameters() {
        if (this.m_Disabled) {
            return Collections.emptyList();
        }
        ArgumentMap argumentMap = new ArgumentMap();
        if (this.m_Filters != null) {
            for (Filter filter : this.m_Filters) {
                filter.buildParameters(argumentMap);
            }
        }
        return argumentMap.getParameters();
    }

    @Override
    public String getDescription() {
        return this.m_Parent.getDescription();
    }

    @Override
    public DataSchema getSchema() {
        return this.m_Parent.getSchema();
    }

    @Override
    public void pushTo(PushContext pushContext, DataListener dataListener) {
        if (this.m_Disabled) {
            this.m_Parent.pushTo(pushContext, new PassThrough(dataListener));
        } else if (this.m_Parent != null) {
            if (this.m_Filters == null) {
                this.m_Parent.pushTo(pushContext, new PassThrough(dataListener));
            } else {
                DataSchema dataSchema = this.m_Parent.getSchema();
                if (dataSchema != null) {
                    for (Filter filter : this.m_Filters) {
                        filter.setSchema(pushContext, dataSchema);
                    }
                    this.m_Parent.pushTo(pushContext, new Rejecter(dataListener));
                } else {
                    throw new RuntimeException("Parent schema is null");
                }
            }
        }
    }

    private class PassThrough
    implements DataListener2 {
        private final DataListener m_DataListener;

        public PassThrough(DataListener dataListener) {
            this.m_DataListener = dataListener;
        }

        @Override
        public <T> T getAdapter(Class<T> clazz) {
            if (clazz == IDataSource.class) {
                return clazz.cast(FilteredDataSource.this);
            }
            return null;
        }

        @Override
        public void startData(IDataSource iDataSource) {
            this.m_DataListener.startData(FilteredDataSource.this);
        }

        @Override
        public void startGroup(DataGroup dataGroup) {
            this.m_DataListener.startGroup(dataGroup);
        }

        @Override
        public boolean processRecord(DataRecord dataRecord) {
            return this.m_DataListener.processRecord(dataRecord);
        }

        @Override
        public void endGroup(DataGroup dataGroup) {
            this.m_DataListener.endGroup(dataGroup);
        }

        @Override
        public void endData(IDataSource iDataSource) {
            this.m_DataListener.endData(FilteredDataSource.this);
        }
    }

    private class Rejecter
    extends PassThrough {
        public Rejecter(DataListener dataListener) {
            super(dataListener);
        }

        @Override
        public boolean processRecord(DataRecord dataRecord) {
            for (Filter filter : FilteredDataSource.this.m_Filters) {
                if (filter.accept(dataRecord)) continue;
                return true;
            }
            return super.processRecord(dataRecord);
        }
    }
}

