/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.datasource.filter;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.data2.ArgumentMap;
import com.elixirtech.data2.DataRecord;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.PushContext;
import com.elixirtech.data2.datasource.filter.Filter;
import com.elixirtech.data2.datasource.filter.LessThanFilter;
import com.elixirtech.data2.datasource.filter.MoreThanFilter;
import com.elixirtech.data2.datasource.filter.NotWrapper;

public class InRangeFilter
implements Filter {
    public static final String TYPE = "In Range";
    protected final String m_Name;
    protected final String m_Value;
    protected Filter m_First;
    protected Filter m_Last;
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(InRangeFilter.class);

    public InRangeFilter(String string, String string2) {
        assert (string != null);
        this.m_Name = string;
        this.m_Value = string2;
    }

    @Override
    public String getName() {
        return this.m_Name;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public String getValue() {
        return this.m_Value;
    }

    @Override
    public void buildParameters(ArgumentMap argumentMap) {
        argumentMap.extractParameters(this.m_Value);
    }

    @Override
    public void setSchema(PushContext pushContext, DataSchema dataSchema) {
        String string = pushContext.substitute(this.m_Value);
        int n = string.lastIndexOf("~");
        if (n > 0) {
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            this.m_First = new NotWrapper(new LessThanFilter(this.m_Name, string2));
            this.m_Last = new NotWrapper(new MoreThanFilter(this.m_Name, string3));
            this.m_First.setSchema(pushContext, dataSchema);
            this.m_Last.setSchema(pushContext, dataSchema);
        } else {
            m_Log.warn((Object)("In Range Filter syntax should be min~max: " + string));
            this.m_First = null;
            this.m_Last = null;
        }
    }

    @Override
    public boolean accept(DataRecord dataRecord) {
        if (this.m_First == null || this.m_Last == null) {
            return false;
        }
        return this.m_First.accept(dataRecord) && this.m_Last.accept(dataRecord);
    }
}

