/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.datasource.filter;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.data2.ArgumentMap;
import com.elixirtech.data2.DataRecord;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.PushContext;
import com.elixirtech.data2.RecordScope;
import com.elixirtech.data2.datasource.filter.Filter;
import com.elixirtech.js.CompiledScript;
import com.elixirtech.js.JavaScriptEngine;
import com.elixirtech.js.ScriptException;
import org.mozilla.javascript.Scriptable;

public class JavaScriptFilter
implements Filter {
    public static final String TYPE = "JavaScript";
    protected final String m_Script;
    protected String m_SubstitutedScript;
    protected CompiledScript m_CompiledScript;
    protected RecordScope m_Scope;
    protected Scriptable m_BaseScope;
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(JavaScriptFilter.class);
    private static final ElxLoggerJ m_JSLog = ElxLoggerJ.getLogger((String)"JavaScript");

    public JavaScriptFilter(String string) {
        assert (string != null);
        this.m_Script = string;
    }

    public void setBaseScope(Scriptable scriptable) {
        this.m_BaseScope = scriptable;
    }

    @Override
    public String getName() {
        return "";
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public String getValue() {
        return this.m_Script;
    }

    @Override
    public void buildParameters(ArgumentMap argumentMap) {
        argumentMap.extractParameters(this.m_Script);
    }

    @Override
    public void setSchema(PushContext pushContext, DataSchema dataSchema) {
        this.m_SubstitutedScript = pushContext.substitute(this.m_Script);
        JavaScriptEngine javaScriptEngine = JavaScriptEngine.getInstance();
        this.m_CompiledScript = javaScriptEngine.compile("Filter", this.m_SubstitutedScript);
        this.m_Scope = new RecordScope(dataSchema);
        this.m_Scope.setContext(pushContext);
        if (this.m_BaseScope != null) {
            this.m_Scope.setParentScope(this.m_BaseScope);
        } else {
            this.m_Scope.setParentScope(javaScriptEngine.getScope());
        }
    }

    @Override
    public boolean accept(DataRecord dataRecord) {
        this.m_Scope.setData(dataRecord.getData());
        try {
            return Boolean.TRUE.equals(this.m_CompiledScript.eval((Scriptable)this.m_Scope));
        }
        catch (ScriptException scriptException) {
            m_JSLog.error((Object)("Script error: " + this.m_SubstitutedScript), (Throwable)scriptException);
            return true;
        }
    }
}

