/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.datasource.ldap;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.arch.StringUtil;
import com.elixirtech.data2.ArgumentMap;
import com.elixirtech.data2.DataAttributes;
import com.elixirtech.data2.DataListener;
import com.elixirtech.data2.DataRecord;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DataType;
import com.elixirtech.data2.FileBasedDataSource;
import com.elixirtech.data2.Parameter;
import com.elixirtech.data2.PushContext;
import com.elixirtech.data2.SchemaBuilder;
import com.elixirtech.data2.datasource.ldap.AttributeIterator;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.SizeLimitExceededException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;

public class LDAPDataSource
extends FileBasedDataSource {
    protected String m_Name;
    protected DataSchema m_Schema;
    protected String m_Description;
    protected String m_Location;
    protected String m_BaseDN;
    protected String m_Scope = SCOPES[1];
    protected String m_Filter;
    protected int m_Port = 389;
    protected int m_TimeOut;
    protected int m_BatchSize;
    protected boolean m_IsLDAPTrace;
    protected String m_UseConnectionPool = "false";
    protected String m_AuthenticationType = "none";
    protected String m_Principle = "";
    protected String m_Credentials = "";
    protected String m_Protocol;
    public static final String[] SCOPES = new String[]{"Object", "One Level", "Subtree"};
    private static final Set<String> BYTE_ARRAY_ATTRIBUTE_NAMES = new HashSet<String>();
    private static final ElxLoggerJ m_Log;

    public LDAPDataSource() {
        this("", new DataSchema());
    }

    public LDAPDataSource(String string, DataSchema dataSchema) {
        this.m_Name = string;
        this.m_Schema = dataSchema;
    }

    @Override
    public String getName() {
        return this.m_Name;
    }

    public void setName(String string) {
        this.m_Name = string;
    }

    @Override
    public String getType() {
        return "LDAP";
    }

    @Override
    public String getDescription() {
        return this.m_Description;
    }

    public void setDescription(String string) {
        this.m_Description = string;
    }

    @Override
    public DataSchema getSchema() {
        return this.m_Schema;
    }

    public void setSchema(DataSchema dataSchema) {
        this.m_Schema = dataSchema;
    }

    @Override
    public List<Parameter> getParameters() {
        ArgumentMap argumentMap = new ArgumentMap();
        argumentMap.extractParameters(this.m_BaseDN);
        argumentMap.extractParameters(this.m_Credentials);
        argumentMap.extractParameters(this.m_Filter);
        argumentMap.extractParameters(this.m_Location);
        argumentMap.extractParameters(this.m_Principle);
        argumentMap.extractParameters(this.m_Protocol);
        return argumentMap.getParameters();
    }

    @Override
    public void pushTo(PushContext pushContext, DataListener dataListener) {
        int n = this.m_Schema.getColumnCount();
        String[] stringArray = new String[n];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = this.m_Schema.getColumnName(i);
        }
        dataListener.startData(this);
        try {
            InitialDirContext initialDirContext = this.signOn(pushContext);
            SearchControls searchControls = new SearchControls();
            searchControls.setSearchScope(this.getScopeInt());
            if (this.m_TimeOut != 0) {
                searchControls.setTimeLimit(this.m_TimeOut);
            }
            if (this.m_BatchSize != 0) {
                searchControls.setCountLimit(this.m_BatchSize);
            }
            searchControls.setReturningAttributes(stringArray);
            String string = this.getFilter();
            if (StringUtil.isEmpty(string)) {
                string = "objectClass=*";
            }
            NamingEnumeration<SearchResult> namingEnumeration = initialDirContext.search("", pushContext.substitute(string), searchControls);
            try {
                while (namingEnumeration.hasMore()) {
                    Object[] objectArray;
                    SearchResult searchResult = namingEnumeration.next();
                    AttributeIterator attributeIterator = new AttributeIterator(stringArray, searchResult.getAttributes());
                    while (attributeIterator.hasNext() && dataListener.processRecord(new DataRecord(this.m_Schema, objectArray = attributeIterator.getRecord()))) {
                    }
                }
            }
            catch (SizeLimitExceededException sizeLimitExceededException) {
                m_Log.warn((Object)"LDAP SizeLimit Exceeded.");
            }
        }
        catch (NamingException namingException) {
            throw new RuntimeException(namingException.toString(), namingException);
        }
        finally {
            dataListener.endData(this);
        }
    }

    public DataSchema inferSchema(PushContext pushContext) throws NamingException {
        SchemaBuilder schemaBuilder = new SchemaBuilder(true);
        InitialDirContext initialDirContext = this.signOn(pushContext);
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(this.getScopeInt());
        String string = this.getFilter();
        if (StringUtil.isEmpty(string)) {
            string = "objectClass=*";
        }
        NamingEnumeration<SearchResult> namingEnumeration = initialDirContext.search("", pushContext.substitute(string), searchControls);
        while (namingEnumeration.hasMore()) {
            SearchResult searchResult = namingEnumeration.next();
            Attributes attributes = searchResult.getAttributes();
            NamingEnumeration<? extends Attribute> namingEnumeration2 = attributes.getAll();
            while (namingEnumeration2.hasMore()) {
                Attribute attribute = namingEnumeration2.next();
                String string2 = attribute.getID();
                if (schemaBuilder.contains(string2)) continue;
                if (BYTE_ARRAY_ATTRIBUTE_NAMES.contains(string2)) {
                    schemaBuilder.add(string2, DataType.BYTE_ARRAY, new DataAttributes());
                    continue;
                }
                schemaBuilder.add(string2, DataType.STRING, new DataAttributes());
            }
        }
        return schemaBuilder.getSchema();
    }

    public void setBaseDN(String string) {
        this.m_BaseDN = string;
    }

    public String getBaseDN() {
        return this.m_BaseDN;
    }

    public String getLocation() {
        return this.m_Location;
    }

    public void setLocation(String string) {
        this.m_Location = string;
    }

    public String getFilter() {
        return this.m_Filter;
    }

    public void setFilter(String string) {
        this.m_Filter = string;
    }

    public void setPort(int n) {
        this.m_Port = n;
    }

    public int getPort() {
        return this.m_Port;
    }

    public void setScope(String string) {
        this.m_Scope = string;
    }

    public String getScope() {
        return this.m_Scope;
    }

    public int getScopeInt() {
        if (SCOPES[0].equals(this.m_Scope)) {
            return 0;
        }
        if (SCOPES[1].equals(this.m_Scope)) {
            return 1;
        }
        if (SCOPES[2].equals(this.m_Scope)) {
            return 2;
        }
        return 1;
    }

    public int getTimeOut() {
        return this.m_TimeOut;
    }

    public void setTimeOut(int n) {
        this.m_TimeOut = n;
    }

    public int getBatchSize() {
        return this.m_BatchSize;
    }

    public void setBatchSize(int n) {
        this.m_BatchSize = n;
    }

    public boolean getLDAPTrace() {
        return this.m_IsLDAPTrace;
    }

    public void setLDAPTrace(boolean bl) {
        this.m_IsLDAPTrace = bl;
    }

    public void setAuthenticationType(String string) {
        this.m_AuthenticationType = string;
    }

    public String getAuthenticationType() {
        return this.m_AuthenticationType;
    }

    public void setPrinciple(String string) {
        this.m_Principle = string;
    }

    public String getPrinciple() {
        return this.m_Principle;
    }

    public void setCredentials(String string) {
        this.m_Credentials = string;
    }

    public String getCredentials() {
        return this.m_Credentials;
    }

    public void setProtocol(String string) {
        this.m_Protocol = string;
    }

    public String getProtocol() {
        return this.m_Protocol;
    }

    public void setUseConnectionPool(String string) {
        this.m_UseConnectionPool = string;
    }

    public String getUseConnectionPool() {
        return this.m_UseConnectionPool;
    }

    private InitialDirContext signOn(PushContext pushContext) throws NamingException {
        Object object;
        StringBuilder stringBuilder = new StringBuilder("ldap://");
        stringBuilder.append(pushContext.substitute(this.m_Location)).append(":").append(this.m_Port).append('/');
        if (StringUtil.notEmpty(this.m_BaseDN)) {
            object = this.m_BaseDN.trim();
            m_Log.debug((Object)("Orignal dn " + (String)object));
            Pattern pattern = Pattern.compile("\\s+");
            Matcher matcher = pattern.matcher((CharSequence)object);
            object = matcher.replaceAll("");
            stringBuilder.append(pushContext.substitute((String)object));
        }
        object = new Hashtable();
        ((Hashtable)object).put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        ((Hashtable)object).put("com.sun.jndi.ldap.connect.pool", this.m_UseConnectionPool);
        ((Hashtable)object).put("com.sun.jndi.ldap.connect.timeout", Integer.toString(this.m_TimeOut));
        ((Hashtable)object).put("java.naming.batchsize", Integer.toString(this.m_BatchSize));
        ((Hashtable)object).put("java.naming.provider.url", stringBuilder.toString());
        m_Log.info((Object)("LDAP URL Generated" + stringBuilder.toString()));
        if (!"none".equals(this.m_AuthenticationType)) {
            ((Hashtable)object).put("java.naming.security.authentication", pushContext.substitute(this.m_AuthenticationType));
            ((Hashtable)object).put("java.naming.security.principal", pushContext.substitute(this.m_Principle));
            ((Hashtable)object).put("java.naming.security.credentials", pushContext.substitute(this.m_Credentials));
        }
        if (this.m_Protocol != null) {
            ((Hashtable)object).put("java.naming.security.protocol", pushContext.substitute(this.m_Protocol));
        }
        if (this.m_IsLDAPTrace) {
            ((Hashtable)object).put("com.sun.jndi.ldap.trace.ber", System.err);
        }
        return new InitialDirContext((Hashtable<?, ?>)object);
    }

    static {
        BYTE_ARRAY_ATTRIBUTE_NAMES.add("photo");
        BYTE_ARRAY_ATTRIBUTE_NAMES.add("personalSignature");
        BYTE_ARRAY_ATTRIBUTE_NAMES.add("audio");
        BYTE_ARRAY_ATTRIBUTE_NAMES.add("jpegPhoto");
        BYTE_ARRAY_ATTRIBUTE_NAMES.add("javaSerializedData");
        BYTE_ARRAY_ATTRIBUTE_NAMES.add("thumbnailPhoto");
        BYTE_ARRAY_ATTRIBUTE_NAMES.add("thumbnailLogo");
        BYTE_ARRAY_ATTRIBUTE_NAMES.add("userPassword");
        BYTE_ARRAY_ATTRIBUTE_NAMES.add("userCertificate");
        BYTE_ARRAY_ATTRIBUTE_NAMES.add("cACertificate");
        BYTE_ARRAY_ATTRIBUTE_NAMES.add("authorityRevocationList");
        BYTE_ARRAY_ATTRIBUTE_NAMES.add("certificateRevocationList");
        BYTE_ARRAY_ATTRIBUTE_NAMES.add("crossCertificatePair");
        BYTE_ARRAY_ATTRIBUTE_NAMES.add("x500UniqueIdentifier");
        m_Log = ElxLoggerJ.getLogger(LDAPDataSource.class);
    }
}

