/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.datasource.object;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.arch.job.JobLogging;
import com.elixirtech.data2.ArgumentMap;
import com.elixirtech.data2.DataException;
import com.elixirtech.data2.DataListener;
import com.elixirtech.data2.DataRecord;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.FileBasedDataSource;
import com.elixirtech.data2.Parameter;
import com.elixirtech.data2.PushContext;
import com.elixirtech.js.JavaScriptEngine;
import com.elixirtech.js.ScriptException;
import com.elixirtech.repository.RMLFileObject;
import com.elixirtech.repository.RMLRepository;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.mozilla.javascript.Scriptable;

public class ObjectDataSource
extends FileBasedDataSource {
    private String m_Name;
    private String m_Description;
    private DataSchema m_Schema;
    protected String m_JavaScript;
    protected final ArgumentMap m_Arguments = new ArgumentMap();
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(ObjectDataSource.class);

    public ObjectDataSource() {
    }

    public ObjectDataSource(String string, DataSchema dataSchema) {
        this();
        this.setName(string);
        this.setSchema(dataSchema);
    }

    public void setName(String string) {
        this.m_Name = string;
        this.setDirty(true);
    }

    @Override
    public String getName() {
        return this.m_Name;
    }

    @Override
    public String getDescription() {
        return this.m_Description;
    }

    public void setDescription(String string) {
        this.m_Description = string;
        this.setDirty(true);
    }

    @Override
    public String getType() {
        return "Java";
    }

    public void setSchema(DataSchema dataSchema) {
        this.m_Schema = dataSchema;
        this.setDirty(true);
    }

    @Override
    public DataSchema getSchema() {
        return this.m_Schema;
    }

    public DataRecord newRecordInstance() {
        Object[] objectArray = new Object[this.m_Schema.getColumnCount()];
        return new DataRecord(this.m_Schema, objectArray);
    }

    public String getRepositoryFileContents(String string) {
        RMLRepository rMLRepository = (RMLRepository)Elixir.get(RMLRepository.class);
        RMLFileObject rMLFileObject = rMLRepository.getFileJ(string);
        if (rMLFileObject != null) {
            try {
                InputStream inputStream = rMLFileObject.getInputStream();
                String string2 = new String(inputStream.readAllBytes(), StandardCharsets.UTF_8);
                inputStream.close();
                return string2;
            }
            catch (IOException iOException) {
                m_Log.error((Object)("Exception reading repository file contents: " + string + " : " + iOException));
                return null;
            }
        }
        m_Log.error((Object)("Can't read repository file contents: " + string));
        return null;
    }

    public DataRecord buildRecord(Scriptable scriptable) {
        Object[] objectArray = new Object[this.m_Schema.getColumnCount()];
        if (scriptable != null) {
            Scriptable scriptable2 = scriptable.getPrototype();
            for (int i = 0; i < objectArray.length; ++i) {
                try {
                    objectArray[i] = this.m_Schema.narrow(this.m_Schema.getColumnType(i), scriptable.get(this.m_Schema.getColumnName(i), scriptable2));
                    continue;
                }
                catch (RuntimeException runtimeException) {
                    m_Log.warn((Object)("Can't convert value into appropriate type: " + runtimeException));
                }
            }
        }
        return new DataRecord(this.m_Schema, objectArray);
    }

    public void setJavaScript(String string) {
        this.m_JavaScript = string;
        this.setDirty(true);
    }

    public String getJavaScript() {
        return this.m_JavaScript;
    }

    @Override
    public List<Parameter> getParameters() {
        ArgumentMap argumentMap = new ArgumentMap();
        argumentMap.extractParameters(this.m_JavaScript);
        return argumentMap.getParameters();
    }

    @Override
    public void pushTo(PushContext pushContext, DataListener dataListener) {
        try {
            JavaScriptEngine javaScriptEngine = JavaScriptEngine.getInstance();
            javaScriptEngine.pushScope();
            try {
                javaScriptEngine.execute(this.getClass().getName(), pushContext.substitute(this.m_JavaScript), JavaScriptEngine.getSystemCodeSource());
                javaScriptEngine.declareBean("Schema", this.m_Schema);
                javaScriptEngine.call("pushTo", this, new Object[]{pushContext, dataListener});
            }
            catch (JobLogging.JobCancelledException jobCancelledException) {
            }
            catch (ScriptException scriptException) {
                Throwable throwable = scriptException.getCause();
                if (throwable instanceof DataException) {
                    throw (DataException)throwable;
                }
                ElxLoggerJ.getLogger(ObjectDataSource.class).error((Object)(this.m_Name + " JavaScript error: " + scriptException), (Throwable)scriptException);
                throw new DataException(this.m_Name + " Error in JavaScript:" + scriptException + ". Check all necessary jars are in /ext");
            }
            catch (Throwable throwable) {
                ElxLoggerJ.getLogger(ObjectDataSource.class).error((Object)(this.m_Name + " JavaScript error: " + throwable), throwable);
                throw new DataException(this.m_Name + " Error in JavaScript:" + throwable + ". Check all necessary jars are in /ext");
            }
            finally {
                javaScriptEngine.popScope();
            }
        }
        catch (Exception exception) {
            throw new RuntimeException("pushTo Exception", exception);
        }
    }
}

