/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.datasource.parameters;

import com.elixirtech.data2.DataException;
import com.elixirtech.data2.DataSourceManager;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.data2.datasource.DataSourceDefinition;
import com.elixirtech.data2.datasource.parameters.ParameterSupplier;
import com.elixirtech.jdom.Element;

public class ParameterDefinition
extends DataSourceDefinition {
    public static final String PARAMS = "param-src";
    public static final String ITERATE = "iterate";

    @Override
    public IDataSource getDataSource(DataSourceManager dataSourceManager, Element element) throws DataException {
        if (!"datasource".equals(element.getName()) || element.getNamespace() != NS_DATASOURCE) {
            throw new IllegalArgumentException("Element " + element.getName() + " is not a ds:datasource");
        }
        Element element2 = element.getChild("parameters", NS_DATASOURCE);
        if (element2 == null) {
            throw new DataException("Can't load parameters element");
        }
        String string = element2.getAttributeValue("parent");
        IDataSource iDataSource = dataSourceManager.getDataSource(dataSourceManager, string);
        String string2 = element2.getAttributeValue(PARAMS);
        IDataSource iDataSource2 = dataSourceManager.getDataSource(dataSourceManager, string2);
        ParameterSupplier parameterSupplier = new ParameterSupplier();
        parameterSupplier.setName(element.getAttributeValue("name"));
        parameterSupplier.setDescription(element.getAttributeValue("description"));
        parameterSupplier.setParentDataSource(iDataSource);
        parameterSupplier.setParametersDataSource(iDataSource2);
        parameterSupplier.setIterate("Yes".equals(element.getAttributeValue(ITERATE)));
        return parameterSupplier;
    }

    @Override
    public Element setDataSource(IDataSource iDataSource) throws DataException {
        if (!(iDataSource instanceof ParameterSupplier)) {
            throw new IllegalArgumentException("Not a ParameterSupplier");
        }
        ParameterSupplier parameterSupplier = (ParameterSupplier)iDataSource;
        Element element = this.defineDataSource(parameterSupplier);
        Element element2 = new Element("parameters", NS_DATASOURCE);
        element2.setAttribute("parent", parameterSupplier.getParentDataSource().getName());
        element2.setAttribute(PARAMS, parameterSupplier.getParametersDataSource().getName());
        element2.setAttribute(ITERATE, parameterSupplier.isIterate() ? "Yes" : "No");
        element.addContent(element2);
        return element;
    }
}

