/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.datasource.processor;

import com.elixirtech.arch.StringUtil;
import com.elixirtech.data2.DataException;
import com.elixirtech.data2.DataSourceManager;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.data2.datasource.DataSourceDefinition;
import com.elixirtech.data2.datasource.processor.IProcessor;
import com.elixirtech.data2.datasource.processor.ProcessorDataSource;
import com.elixirtech.data2.datasource.processor.ProcessorRegistry;
import com.elixirtech.jdom.Element;
import java.io.IOException;

public class ProcessorDefinition
extends DataSourceDefinition {
    @Override
    public IDataSource getDataSource(DataSourceManager dataSourceManager, Element element) throws DataException {
        IDataSource iDataSource;
        if (!"datasource".equals(element.getName()) || element.getNamespace() != NS_DATASOURCE) {
            throw new IllegalArgumentException("Element " + element.getName() + " is not a ds:datasource");
        }
        String string = element.getAttributeValue("name");
        Element element2 = element.getChild("processor", NS_DATASOURCE);
        if (element2 == null) {
            throw new DataException("Can't load processor element");
        }
        ProcessorDataSource processorDataSource = new ProcessorDataSource(string);
        try {
            iDataSource = this.getProcessor(element2);
            if (iDataSource != null) {
                processorDataSource.setProcessor((IProcessor)iDataSource);
            }
        }
        catch (IOException iOException) {
            throw new DataException("Error loading processor: " + iOException, iOException);
        }
        iDataSource = this.getParent(dataSourceManager, element2);
        processorDataSource.setParent(iDataSource);
        return processorDataSource;
    }

    @Override
    public Element setDataSource(IDataSource iDataSource) throws DataException {
        if (!(iDataSource instanceof ProcessorDataSource)) {
            throw new IllegalArgumentException("Not a ProcessorDataSource");
        }
        ProcessorDataSource processorDataSource = (ProcessorDataSource)iDataSource;
        Element element = this.defineDataSource(processorDataSource);
        Element element2 = new Element("processor", NS_DATASOURCE);
        element2.setAttribute("parent", processorDataSource.getParent().getName());
        IProcessor iProcessor = processorDataSource.getProcessor();
        if (iProcessor != null) {
            element2.setAttribute("type", iProcessor.getType());
            iProcessor.saveTo(element2);
        }
        element.addContent(element2);
        return element;
    }

    private IProcessor getProcessor(Element element) throws IOException {
        IProcessor iProcessor = null;
        String string = element.getAttributeValue("type");
        if (StringUtil.notEmpty(string) && (iProcessor = ProcessorRegistry.newProcessor(string)) != null) {
            iProcessor.loadFrom(element);
        }
        return iProcessor;
    }
}

