/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.datasource.processor.javascript;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.arch.StringUtil;
import com.elixirtech.data2.DataGroup;
import com.elixirtech.data2.DataListener;
import com.elixirtech.data2.DataRecord;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.data2.PushContext;
import com.elixirtech.data2.datasource.processor.javascript.JSScope;
import com.elixirtech.data2.datasource.processor.javascript.JavaScriptNode;
import com.elixirtech.data2.datasource.processor.javascript.JavaScriptProcessor;
import com.elixirtech.js.CompiledScript;
import com.elixirtech.js.JavaScriptEngine;
import com.elixirtech.js.ScriptException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Wrapper;

public class JSDataListener
implements DataListener {
    private final JavaScriptProcessor m_Processor;
    private final JavaScriptEngine m_Engine;
    private final JavaScriptNode m_Node;
    private final PushContext m_Context;
    private final DataListener m_Next;
    private final CompiledScript m_StartData;
    private final CompiledScript m_StartGroup;
    private final CompiledScript m_ProcessRecord;
    private final CompiledScript m_EndGroup;
    private final CompiledScript m_EndData;
    private JSScope m_JSScope;
    private Scriptable m_Scope;
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(JSDataListener.class);

    public JSDataListener(JavaScriptProcessor javaScriptProcessor, PushContext pushContext, DataListener dataListener) {
        this.m_Processor = javaScriptProcessor;
        this.m_Engine = JavaScriptEngine.getInstance();
        this.m_Node = (JavaScriptNode)this.m_Processor.getProcessorNode();
        this.m_Context = pushContext;
        this.m_Next = dataListener;
        this.m_StartData = this.compileScript("startData", this.m_Node.getStartData());
        this.m_StartGroup = this.compileScript("startGroup", this.m_Node.getStartGroup());
        this.m_ProcessRecord = this.compileScript("processRecord", this.m_Node.getProcessRecord());
        this.m_EndGroup = this.compileScript("endGroup", this.m_Node.getEndGroup());
        this.m_EndData = this.compileScript("endData", this.m_Node.getEndData());
    }

    @Override
    public void startData(IDataSource iDataSource) {
        this.m_JSScope = new JSScope(this.m_Processor);
        this.m_JSScope.setParentScope(this.m_Engine.getScope());
        this.m_JSScope.put("next", new NextWrapper(this.m_Next));
        this.m_JSScope.put("src", iDataSource);
        this.m_JSScope.put("schema", this.m_Node.getSchema());
        this.m_Scope = this.m_Engine.toScriptable(this.m_Processor);
        this.m_Scope.setParentScope((Scriptable)this.m_JSScope);
        if (this.m_StartData != null) {
            try {
                this.m_StartData.eval(this.m_Scope);
            }
            catch (ScriptException scriptException) {
                throw new RuntimeException("startData error: " + scriptException, scriptException);
            }
        } else {
            this.m_Next.startData(this.m_Processor);
        }
    }

    @Override
    public void startGroup(DataGroup dataGroup) {
        if (this.m_StartGroup != null) {
            try {
                this.m_JSScope.put("group", dataGroup);
                try {
                    this.m_StartGroup.eval(this.m_Scope);
                }
                finally {
                    this.m_Scope.delete("group");
                }
            }
            catch (ScriptException scriptException) {
                throw new RuntimeException("startGroup error: " + scriptException, scriptException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean processRecord(DataRecord dataRecord) {
        boolean bl = true;
        if (this.m_ProcessRecord != null) {
            try {
                this.m_JSScope.put("record", dataRecord);
                this.m_JSScope.setData(dataRecord.getData());
                try {
                    Object object = this.m_ProcessRecord.eval(this.m_Scope);
                    if (object instanceof Boolean) {
                        bl = (Boolean)object;
                    }
                }
                finally {
                    this.m_JSScope.delete("record");
                    this.m_JSScope.setData(null);
                }
            }
            catch (ScriptException scriptException) {
                throw new RuntimeException("processRecord error: " + scriptException, scriptException);
            }
        }
        return bl;
    }

    @Override
    public void endGroup(DataGroup dataGroup) {
        if (this.m_EndGroup != null) {
            try {
                this.m_JSScope.put("group", dataGroup);
                try {
                    this.m_EndGroup.eval(this.m_Scope);
                }
                finally {
                    this.m_Scope.delete("group");
                }
            }
            catch (ScriptException scriptException) {
                throw new RuntimeException("endGroup error: " + scriptException, scriptException);
            }
        }
    }

    @Override
    public void endData(IDataSource iDataSource) {
        if (this.m_EndData != null) {
            try {
                this.m_EndData.eval(this.m_Scope);
            }
            catch (ScriptException scriptException) {
                throw new RuntimeException("endData error: " + scriptException, scriptException);
            }
        } else {
            this.m_Next.endData(this.m_Processor);
        }
        this.m_Scope = null;
    }

    private CompiledScript compileScript(String string, String string2) {
        if (StringUtil.isEmpty(string2)) {
            return null;
        }
        return this.m_Engine.compile(string, this.m_Context.substitute(string2));
    }

    public static class NextWrapper {
        private DataListener m_DataListener;

        public NextWrapper(DataListener dataListener) {
            this.m_DataListener = dataListener;
        }

        public void startData(Object object) {
            final Object object2 = this.unwrap(object);
            if (object2 instanceof IDataSource) {
                try {
                    AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                        @Override
                        public Object run() {
                            m_DataListener.startData((IDataSource)object2);
                            return null;
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException) {
                    Throwable throwable = privilegedActionException.getCause();
                    if (throwable instanceof RuntimeException) {
                        throw (RuntimeException)throwable;
                    }
                    m_Log.error((Object)("Error in startData: " + privilegedActionException));
                }
            } else {
                m_Log.warn((Object)("startData called with a " + object2));
            }
        }

        public void startGroup(Object object) {
            final Object object2 = this.unwrap(object);
            if (object2 instanceof DataGroup) {
                try {
                    AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                        @Override
                        public Object run() {
                            m_DataListener.startGroup((DataGroup)object2);
                            return null;
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException) {
                    Throwable throwable = privilegedActionException.getCause();
                    if (throwable instanceof RuntimeException) {
                        throw (RuntimeException)throwable;
                    }
                    m_Log.error((Object)("Error in startGroup: " + privilegedActionException));
                }
            } else {
                m_Log.warn((Object)("startGroup called with a " + object2));
            }
        }

        public void processRecord(Object object) {
            final Object object2 = this.unwrap(object);
            if (object2 instanceof DataRecord) {
                try {
                    AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                        @Override
                        public Object run() {
                            m_DataListener.processRecord((DataRecord)object2);
                            return null;
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException) {
                    Throwable throwable = privilegedActionException.getCause();
                    if (throwable instanceof RuntimeException) {
                        throw (RuntimeException)throwable;
                    }
                    m_Log.error((Object)("Error in processRecord: " + privilegedActionException));
                }
            } else {
                m_Log.warn((Object)("processRecord called with a " + object2));
            }
        }

        public void endGroup(Object object) {
            final Object object2 = this.unwrap(object);
            if (object2 instanceof DataGroup) {
                try {
                    AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                        @Override
                        public Object run() {
                            m_DataListener.endGroup((DataGroup)object2);
                            return null;
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException) {
                    Throwable throwable = privilegedActionException.getCause();
                    if (throwable instanceof RuntimeException) {
                        throw (RuntimeException)throwable;
                    }
                    m_Log.error((Object)("Error in endGroup: " + privilegedActionException));
                }
            } else {
                m_Log.warn((Object)("endGroup called with a " + object2));
            }
        }

        public void endData(Object object) {
            final Object object2 = this.unwrap(object);
            if (object2 instanceof IDataSource) {
                try {
                    AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                        @Override
                        public Object run() {
                            m_DataListener.endData((IDataSource)object2);
                            return null;
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException) {
                    Throwable throwable = privilegedActionException.getCause();
                    if (throwable instanceof RuntimeException) {
                        throw (RuntimeException)throwable;
                    }
                    m_Log.error((Object)("Error in endData: " + privilegedActionException));
                }
            } else {
                m_Log.warn((Object)("endData called with a " + object2));
            }
        }

        private Object unwrap(Object object) {
            Object object2 = object;
            if (object2 instanceof NativeObject) {
                object2 = ((NativeObject)object2).getPrototype();
            }
            if (object2 instanceof Wrapper) {
                object2 = ((Wrapper)object2).unwrap();
            }
            return object2;
        }
    }
}

