/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.datasource.properties;

import com.elixirtech.data2.ArgumentMap;
import com.elixirtech.data2.DataAttributes;
import com.elixirtech.data2.DataListener;
import com.elixirtech.data2.DataRecord;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DataType;
import com.elixirtech.data2.FileBasedDataSource;
import com.elixirtech.data2.Parameter;
import com.elixirtech.data2.PushContext;
import com.elixirtech.data2.SchemaBuilder;
import java.util.ArrayList;
import java.util.List;

public class PropertiesDataSource
extends FileBasedDataSource {
    private String m_Name;
    private String m_Description;
    private DataSchema m_Schema;
    private List<Property> m_Properties = new ArrayList<Property>();

    @Override
    public String getName() {
        return this.m_Name;
    }

    @Override
    public String getDescription() {
        return this.m_Description;
    }

    @Override
    public String getType() {
        return "Properties";
    }

    @Override
    public DataSchema getSchema() {
        if (this.m_Schema == null) {
            this.buildSchema();
        }
        return this.m_Schema;
    }

    public void setName(String string) {
        this.m_Name = string;
    }

    public void setDescription(String string) {
        this.m_Description = string;
    }

    public void addProperty(Property property) {
        this.m_Properties.add(property);
        this.m_Schema = null;
    }

    public void addProperty(String string, DataType dataType, String string2) {
        this.addProperty(new Property(string, dataType, string2));
    }

    public int getPropertyCount() {
        return this.m_Properties.size();
    }

    public Property getProperty(int n) {
        return this.m_Properties.get(n);
    }

    public void clearProperties() {
        this.m_Properties.clear();
    }

    @Override
    public List<Parameter> getParameters() {
        ArgumentMap argumentMap = new ArgumentMap();
        for (Property property : this.m_Properties) {
            argumentMap.extractParameters(property.value);
        }
        return argumentMap.getParameters();
    }

    @Override
    public void pushTo(PushContext pushContext, DataListener dataListener) {
        if (this.m_Schema == null) {
            this.buildSchema();
        }
        dataListener.startData(this);
        Object[] objectArray = new Object[this.m_Schema.getColumnCount()];
        for (int i = 0; i < objectArray.length; ++i) {
            Property property = this.m_Properties.get(i);
            objectArray[i] = this.m_Schema.parse(property.type, pushContext.substitute(property.value));
        }
        DataRecord dataRecord = new DataRecord(this.m_Schema, objectArray);
        dataListener.processRecord(dataRecord);
        dataListener.endData(this);
    }

    protected void buildSchema() {
        SchemaBuilder schemaBuilder = new SchemaBuilder(true);
        for (Property property : this.m_Properties) {
            schemaBuilder.add(property.name, property.type, new DataAttributes());
        }
        this.m_Schema = schemaBuilder.getSchema();
    }

    public static class Property {
        public String name;
        public DataType type;
        public String value;

        public Property(String string, DataType dataType, String string2) {
            this.name = string;
            this.type = dataType;
            this.value = string2;
        }
    }
}

