/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.datasource.text;

import com.elixirtech.arch.util.URLLoader$;
import com.elixirtech.data2.DataException;
import com.elixirtech.data2.DataRecord;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DefaultPushContext;
import com.elixirtech.data2.datasource.text.TextDataDefinition;
import com.elixirtech.data2.datasource.text.TextDataSource;
import com.elixirtech.data2.datasource.text.TextDataSource$;
import com.elixirtech.data2.iterator.IDataRecordIterator;
import com.elixirtech.util.FileUtil;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.collection.immutable.Map;
import scala.jdk.CollectionConverters$;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public class TextDataIterator
implements IDataRecordIterator {
    private final DataSchema schema;
    private final int columnCount;
    private Option<DataRecord> nextRecord;
    private final DefaultPushContext cxt;
    private final InputStream is;
    private final BufferedReader bufferedReader;
    private final TextDataDefinition dataDef;

    public TextDataIterator(TextDataSource ds, Map<String, String> parameters) {
        this.schema = ds.getSchema();
        this.columnCount = this.schema().getColumnCount();
        this.nextRecord = None$.MODULE$;
        this.cxt = new DefaultPushContext();
        this.cxt().setParameters(CollectionConverters$.MODULE$.MapHasAsJava(parameters).asJava());
        this.is = TextDataSource$.MODULE$.wrap(URLLoader$.MODULE$.getInputStream(this.cxt().substitute(ds.spec().url())));
        this.bufferedReader = new BufferedReader(new InputStreamReader(this.is(), ds.spec().encoding()));
        this.dataDef = ds.spec().dataDef();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), ds.spec().skipLines()).foreach((Function1)(JFunction1.mcVI.sp & Serializable)_$1 -> this.dataDef().skipLine(this.bufferedReader()));
        if (ds.spec().firstLineHeader()) {
            this.dataDef().skipLine(this.bufferedReader());
        }
        this.dataDef().startParsing(this.cxt(), ds);
        this.advance();
    }

    public DataSchema schema() {
        return this.schema;
    }

    public int columnCount() {
        return this.columnCount;
    }

    public DefaultPushContext cxt() {
        return this.cxt;
    }

    public InputStream is() {
        return this.is;
    }

    public BufferedReader bufferedReader() {
        return this.bufferedReader;
    }

    public TextDataDefinition dataDef() {
        return this.dataDef;
    }

    @Override
    public DataSchema getSchema() {
        return this.schema();
    }

    @Override
    public boolean hasNext() {
        return this.nextRecord.isDefined();
    }

    @Override
    public DataRecord next() {
        Option<DataRecord> option = this.nextRecord;
        if (option instanceof Some) {
            DataRecord rec = (DataRecord)((Some)option).value();
            this.advance();
            return rec;
        }
        if (None$.MODULE$.equals(option)) {
            throw new DataException("No more records");
        }
        throw new MatchError(option);
    }

    @Override
    public void close() {
        this.dataDef().endParsing();
        FileUtil.close(this.bufferedReader());
        this.nextRecord = None$.MODULE$;
    }

    private void advance() {
        Option option = Option$.MODULE$.apply((Object)this.dataDef().readLine(this.bufferedReader()));
        if (option instanceof Some) {
            String line = (String)((Some)option).value();
            DataRecord record = new DataRecord(this.schema(), new Object[this.columnCount()]);
            boolean ok = this.dataDef().parseLine(line, record);
            if (ok) {
                this.nextRecord = Some$.MODULE$.apply((Object)record);
                return;
            }
            this.nextRecord = None$.MODULE$;
            return;
        }
        if (None$.MODULE$.equals(option)) {
            this.nextRecord = None$.MODULE$;
            return;
        }
        throw new MatchError((Object)option);
    }
}

