/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.datasource.xml;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.arch.StringUtil;
import com.elixirtech.data2.DataType;
import com.elixirtech.data2.PushContext;
import com.elixirtech.data2.datasource.xml.IProcessor;
import com.elixirtech.data2.datasource.xml.Merge;
import com.elixirtech.data2.datasource.xml.XMLDataSource;
import com.elixirtech.jaxen.JaxenException;
import com.elixirtech.jaxen.NamespaceContext;
import com.elixirtech.jaxen.XPath;
import com.elixirtech.jaxen.dom.DOMXPath;
import com.elixirtech.jdom.Document;
import com.elixirtech.jdom.input.DOMBuilder;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class ColProcessor {
    protected XMLDataSource m_DataSource;
    protected int m_Index;
    protected XMLDataSource.Column m_Column;
    protected DataType m_DataType;
    protected XPath m_XPath;
    protected ColProcessor m_Next;
    protected static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(ColProcessor.class);

    public ColProcessor(PushContext pushContext, XMLDataSource xMLDataSource, int n) throws JaxenException {
        this.m_DataSource = xMLDataSource;
        this.m_Index = n;
        this.m_Column = this.m_DataSource.getColumn(this.m_Index);
        this.m_DataType = this.m_DataSource.getSchema().getColumnType(this.m_Index);
        String string = pushContext.substitute(this.m_DataSource.getColumn(this.m_Index).getXPath());
        if (StringUtil.notEmpty(string)) {
            this.m_XPath = this.buildXPath(string);
        }
        if (n + 1 < xMLDataSource.getColumnCount()) {
            this.m_Next = this.buildProcessor(pushContext, xMLDataSource, n + 1);
        }
    }

    public void setNamespaceContext(NamespaceContext namespaceContext) {
        if (this.m_XPath != null) {
            this.m_XPath.setNamespaceContext(namespaceContext);
        }
        if (this.m_Next != null) {
            this.m_Next.setNamespaceContext(namespaceContext);
        }
    }

    public void prepare(IProcessor iProcessor, Node node, Object[] objectArray) throws RuntimeException, JaxenException {
        if (this.m_XPath != null) {
            Object object = this.m_XPath.evaluate(node);
            if (object instanceof List) {
                Merge merge = this.m_Column.getMerge();
                Iterator iterator = ((List)object).iterator();
                if (Merge.GROUP.equals(merge)) {
                    int n = 0;
                    if (iterator.hasNext()) {
                        while (iterator.hasNext()) {
                            Object e = iterator.next();
                            if (!(e instanceof Node)) continue;
                            if (this.m_DataType.getTypeId() == 8) {
                                objectArray[this.m_Index] = new Integer(n++);
                            }
                            if (this.m_Next == null) continue;
                            this.m_Next.prepare(iProcessor, (Node)e, objectArray);
                        }
                        return;
                    }
                    this.noValue(iProcessor, objectArray);
                    return;
                }
                StringBuilder stringBuilder = new StringBuilder();
                while (iterator.hasNext()) {
                    stringBuilder.append(this.nodeText((Node)iterator.next()));
                    if (merge == null || merge.getSeparator() == null) break;
                    if (!iterator.hasNext()) continue;
                    stringBuilder.append(merge.getSeparator());
                }
                objectArray[this.m_Index] = stringBuilder.toString();
            } else {
                objectArray[this.m_Index] = object.toString();
            }
            try {
                objectArray[this.m_Index] = this.m_DataSource.getSchema().parse(this.m_DataType, (String)objectArray[this.m_Index]);
            }
            catch (RuntimeException runtimeException) {
                m_Log.error((Object)("convertTypes: " + runtimeException.toString()));
                objectArray[this.m_Index] = null;
            }
        }
        if (this.m_Next != null) {
            this.m_Next.prepare(iProcessor, node, objectArray);
        } else {
            iProcessor.processRecord(objectArray);
        }
    }

    protected void noValue(IProcessor iProcessor, Object[] objectArray) throws RuntimeException {
        objectArray[this.m_Index] = null;
        if (this.m_Next != null) {
            this.m_Next.noValue(iProcessor, objectArray);
        } else {
            iProcessor.processRecord(objectArray);
        }
    }

    protected XPath buildXPath(String string) throws JaxenException {
        return new DOMXPath(string);
    }

    protected ColProcessor buildProcessor(PushContext pushContext, XMLDataSource xMLDataSource, int n) throws JaxenException {
        return new ColProcessor(pushContext, xMLDataSource, n);
    }

    protected Document buildDocument(Element element) {
        try {
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            org.w3c.dom.Document document = documentBuilder.newDocument();
            Node node = document.importNode(element, true);
            document.getDocumentElement().appendChild(node);
            DOMBuilder dOMBuilder = new DOMBuilder();
            return dOMBuilder.build(document);
        }
        catch (Exception exception) {
            m_Log.error((Object)("Unable to clone subtree: " + exception));
            return null;
        }
    }

    protected String nodeText(Node node) {
        short s = node.getNodeType();
        if (s == 1) {
            StringBuilder stringBuilder = new StringBuilder();
            for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                if (!(node2 instanceof Text)) continue;
                stringBuilder.append(node2.getNodeValue().trim());
            }
            return stringBuilder.toString();
        }
        if (s == 2) {
            return node.getNodeValue();
        }
        return "";
    }
}

