/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.datasource.xml;

import com.elixirtech.arch.StringUtil;
import com.elixirtech.data2.ArgumentMap;
import com.elixirtech.data2.DataListener;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DataType;
import com.elixirtech.data2.FileBasedDataSource;
import com.elixirtech.data2.Parameter;
import com.elixirtech.data2.PushContext;
import com.elixirtech.data2.datasource.xml.DomProcessor;
import com.elixirtech.data2.datasource.xml.HugeProcessor;
import com.elixirtech.data2.datasource.xml.Merge;
import com.elixirtech.data2.datasource.xml.XMLDataSchema;
import java.util.List;

public class XMLDataSource
extends FileBasedDataSource {
    private String m_Name;
    DataSchema m_Schema;
    Column[] m_Columns;
    String m_RootXPath = "/";
    private String m_Description;
    private String m_URL;
    private String m_XML;
    private boolean m_HTML;
    private boolean m_EDIFACT;
    private boolean m_Huge;

    public XMLDataSource() {
        this("", new DataSchema());
    }

    public XMLDataSource(String string, DataSchema dataSchema) {
        this.m_Name = string;
        this.setSchema(dataSchema);
    }

    @Override
    public String getName() {
        return this.m_Name;
    }

    public void setName(String string) {
        if (XMLDataSource.changed(this.m_Name, string)) {
            this.m_Name = string;
            this.setDirty(true);
        }
    }

    @Override
    public String getDescription() {
        return this.m_Description;
    }

    public void setDescription(String string) {
        if (XMLDataSource.changed(this.m_Description, string)) {
            this.m_Description = string;
            this.setDirty(true);
        }
    }

    @Override
    public String getType() {
        return "XML";
    }

    @Override
    public DataSchema getSchema() {
        return this.m_Schema;
    }

    public void setSchema(DataSchema dataSchema) {
        if (XMLDataSource.changed(this.m_Schema, dataSchema)) {
            this.m_Schema = dataSchema;
            this.m_Columns = new Column[this.m_Schema.getColumnCount()];
            this.setDirty(true);
        }
    }

    public XMLDataSchema getXMLSchema() {
        XMLDataSchema xMLDataSchema = new XMLDataSchema(this.m_Schema);
        xMLDataSchema.setRootXPath(this.m_RootXPath);
        for (int i = 0; i < this.m_Columns.length; ++i) {
            XMLDataSchema.Column column = xMLDataSchema.getColumn(i);
            column.xpath = this.m_Columns[i].m_XPath;
            column.merge = this.m_Columns[i].m_Merge;
        }
        return xMLDataSchema;
    }

    public void setXMLSchema(XMLDataSchema xMLDataSchema) {
        this.m_RootXPath = xMLDataSchema.getRootXPath();
        int n = xMLDataSchema.getColumnCount();
        String[] stringArray = new String[n];
        DataType[] dataTypeArray = new DataType[n];
        this.m_Columns = new Column[n];
        for (int i = 0; i < n; ++i) {
            XMLDataSchema.Column column = xMLDataSchema.getColumn(i);
            stringArray[i] = column.name;
            dataTypeArray[i] = column.type;
            this.m_Columns[i].m_XPath = column.xpath;
            this.m_Columns[i].m_Merge = column.merge;
        }
        DataSchema dataSchema = this.m_Schema;
        this.m_Schema = new DataSchema(true, stringArray, dataTypeArray);
        if (dataSchema != null) {
            this.m_Schema.setDateFormat(dataSchema.getDateFormat());
            this.m_Schema.setTimeFormat(dataSchema.getTimeFormat());
            this.m_Schema.setTimestampFormat(dataSchema.getTimestampFormat());
        }
        this.setDirty(true);
    }

    public void setURL(String string) {
        if (XMLDataSource.changed(this.m_URL, string)) {
            this.m_URL = string;
            this.setDirty(true);
        }
    }

    public String getURL() {
        return this.m_URL;
    }

    public void setXML(String string) {
        if (XMLDataSource.changed(this.m_XML, string)) {
            this.m_XML = string;
            this.setDirty(true);
        }
    }

    public String getXML() {
        return this.m_XML;
    }

    public void setRootXPath(String string) {
        if (XMLDataSource.changed(this.m_RootXPath, string)) {
            this.m_RootXPath = string;
            this.setDirty(true);
        }
    }

    public String getRootXPath() {
        return this.m_RootXPath;
    }

    public void setHTML(boolean bl) {
        if (bl != this.m_HTML) {
            this.m_HTML = bl;
            this.setDirty(true);
        }
    }

    public boolean isHTML() {
        return this.m_HTML;
    }

    public boolean isEDIFACT() {
        return this.m_EDIFACT;
    }

    public void setEDIFACT(boolean bl) {
        if (bl != this.m_EDIFACT) {
            this.m_EDIFACT = bl;
            this.setDirty(true);
        }
    }

    public void setHuge(boolean bl) {
        if (bl != this.m_Huge) {
            this.m_Huge = bl;
            this.setDirty(true);
        }
    }

    public boolean isHuge() {
        return this.m_Huge;
    }

    public String getReadMode() {
        if (this.m_Huge) {
            return "HugeXML";
        }
        if (this.m_HTML) {
            return "HTML";
        }
        if (this.m_EDIFACT) {
            return "EDIFACT";
        }
        return "XML";
    }

    public void setColumn(int n, Column column) {
        if (XMLDataSource.changed(this.m_Columns[n], column)) {
            this.m_Columns[n] = column;
            this.setDirty(true);
        }
    }

    public int getColumnCount() {
        return this.m_Columns.length;
    }

    public Column getColumn(int n) {
        return this.m_Columns[n];
    }

    @Override
    public List<Parameter> getParameters() {
        ArgumentMap argumentMap = new ArgumentMap();
        argumentMap.extractParameters(this.m_XML);
        argumentMap.extractParameters(this.m_URL);
        argumentMap.extractParameters(this.m_RootXPath);
        for (Column column : this.m_Columns) {
            argumentMap.extractParameters(column.m_XPath);
        }
        return argumentMap.getParameters();
    }

    @Override
    public void pushTo(PushContext pushContext, DataListener dataListener) throws RuntimeException {
        String string = pushContext.substitute(this.m_XML);
        if (this.m_Huge && StringUtil.isEmpty(string)) {
            HugeProcessor hugeProcessor = new HugeProcessor(this, pushContext, dataListener);
            hugeProcessor.run();
        } else {
            DomProcessor domProcessor = new DomProcessor(this, pushContext, dataListener);
            domProcessor.setXML(string);
            domProcessor.run();
        }
    }

    public static class Column {
        String m_XPath;
        Merge m_Merge;

        public Column(String string, Merge merge) {
            this.m_XPath = string;
            this.m_Merge = merge;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Column)) {
                return false;
            }
            Column column = (Column)object;
            return this.m_XPath.equals(column.m_XPath) && this.m_Merge == column.m_Merge;
        }

        public String getXPath() {
            return this.m_XPath;
        }

        public Merge getMerge() {
            return this.m_Merge;
        }

        public void setXPath(String string) {
            this.m_XPath = string;
        }

        public void setMerge(Merge merge) {
            this.m_Merge = merge;
        }
    }
}

