/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.function;

import com.elixirtech.data2.DataType;
import com.elixirtech.data2.DecimalHelper;
import com.elixirtech.data2.function.Function;
import java.math.BigDecimal;

public class DecimalAverage
implements Function {
    private BigDecimal m_Value = BigDecimal.ZERO;
    private int m_Count;

    @Override
    public Object clone() {
        return new DecimalAverage();
    }

    @Override
    public String getName() {
        return "Average";
    }

    @Override
    public void update(Object object) {
        if (object instanceof BigDecimal) {
            this.m_Value = this.m_Value.add((BigDecimal)object);
            ++this.m_Count;
        }
    }

    @Override
    public void update(Object[] objectArray) {
        for (int i = 0; i < objectArray.length; ++i) {
            if (!(objectArray[i] instanceof BigDecimal)) continue;
            this.m_Value = this.m_Value.add((BigDecimal)objectArray[i]);
            ++this.m_Count;
        }
    }

    @Override
    public Object getResult() {
        if (this.m_Count == 0) {
            return null;
        }
        return this.m_Value.divide(new BigDecimal(this.m_Count), DecimalHelper.MATH_CONTEXT);
    }

    @Override
    public String getResultName(String string) {
        return "Average(" + string + ")";
    }

    @Override
    public DataType getResultType(DataType dataType) {
        return DataType.DECIMAL;
    }

    @Override
    public void reset() {
        this.m_Value = BigDecimal.ZERO;
        this.m_Count = 0;
    }

    public boolean equals(Object object) {
        return object != null && object.getClass() == this.getClass();
    }
}

