/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.function;

import com.elixirtech.data2.DataType;
import com.elixirtech.data2.DecimalHelper;
import com.elixirtech.data2.function.RangedFunction;
import java.math.BigDecimal;

public class DecimalPercent
implements RangedFunction {
    BigDecimal m_Total = BigDecimal.ZERO;
    BigDecimal m_Value = BigDecimal.ZERO;

    @Override
    public void setRange(Object[] objectArray) {
        this.m_Total = BigDecimal.ZERO;
        for (int i = 0; i < objectArray.length; ++i) {
            if (!(objectArray[i] instanceof BigDecimal)) continue;
            this.m_Total = this.m_Total.add((BigDecimal)objectArray[i]);
        }
    }

    @Override
    public Object clone() {
        DecimalPercent decimalPercent = new DecimalPercent();
        decimalPercent.m_Total = this.m_Total;
        return decimalPercent;
    }

    @Override
    public String getName() {
        return "Percent";
    }

    @Override
    public void update(Object object) {
        if (object instanceof BigDecimal) {
            this.m_Value = this.m_Value.add((BigDecimal)object);
        }
    }

    @Override
    public void update(Object[] objectArray) {
        for (int i = 0; i < objectArray.length; ++i) {
            if (!(objectArray[i] instanceof BigDecimal)) continue;
            this.m_Value = this.m_Value.add((BigDecimal)objectArray[i]);
        }
    }

    @Override
    public Object getResult() {
        if (this.m_Total == BigDecimal.ZERO) {
            return BigDecimal.valueOf(Double.NaN);
        }
        return this.m_Value.divide(this.m_Total, DecimalHelper.MATH_CONTEXT);
    }

    @Override
    public void reset() {
        this.m_Value = new BigDecimal(0);
    }

    @Override
    public String getResultName(String string) {
        return "Percent(" + string + ")";
    }

    @Override
    public DataType getResultType(DataType dataType) {
        return DataType.DECIMAL;
    }

    public boolean equals(Object object) {
        return object != null && object.getClass() == this.getClass();
    }
}

