/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.function;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.data2.DataType;
import com.elixirtech.data2.function.Function;
import com.elixirtech.data2.function.FunctionFactory;
import com.elixirtech.data2.function.IFunctionFactory;
import java.util.ArrayList;

public class LocalFunctionFactory
implements IFunctionFactory {
    private static final Function[] FN_ARRAY = new Function[0];
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(LocalFunctionFactory.class);

    @Override
    public Function getFunction(DataType dataType, String string) {
        Function function = FunctionFactory.getFunction(dataType, string);
        if (function == null) {
            m_Log.warn((Object)("No function \"" + string + "\" found"));
            function = FunctionFactory.getFunction(dataType, null);
        }
        return (Function)function.clone();
    }

    @Override
    public Function[] getAll() {
        ArrayList<Function> arrayList = new ArrayList<Function>();
        for (Function function : FunctionFactory.ALL) {
            arrayList.add(function);
        }
        return arrayList.toArray(FN_ARRAY);
    }

    @Override
    public Function[] getAllCube() {
        ArrayList<Function> arrayList = new ArrayList<Function>();
        for (Function function : FunctionFactory.ALL) {
            arrayList.add(function);
        }
        for (Function function : FunctionFactory.CUBE) {
            arrayList.add(function);
        }
        return arrayList.toArray(FN_ARRAY);
    }

    @Override
    public Function[] getAllWithRecord() {
        ArrayList<Function> arrayList = new ArrayList<Function>();
        for (Function function : FunctionFactory.ALL) {
            arrayList.add(function);
        }
        for (Function function : FunctionFactory.RECORD) {
            arrayList.add(function);
        }
        return arrayList.toArray(FN_ARRAY);
    }
}

