/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.grouping;

import com.elixirtech.data2.DataException;
import com.elixirtech.data2.DataSourceManager;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.data2.datasource.DataSourceDefinition;
import com.elixirtech.data2.grouping.GroupDataSource2;
import com.elixirtech.data2.grouping.GroupDefinition;
import com.elixirtech.jdom.Element;

public class GroupDSDefinition
extends DataSourceDefinition {
    public static final String EXTRACT = "extract";

    @Override
    public IDataSource getDataSource(DataSourceManager dataSourceManager, Element element) throws DataException {
        if (!"datasource".equals(element.getName()) || element.getNamespace() != NS_DATASOURCE) {
            throw new IllegalArgumentException("Element " + element.getName() + " is not a ds:datasource");
        }
        String string = element.getAttributeValue("name");
        Element element2 = element.getChild("group", NS_DATASOURCE);
        if (element2 == null) {
            throw new DataException("Can't load group element");
        }
        IDataSource iDataSource = this.getParent(dataSourceManager, element2);
        GroupDataSource2 groupDataSource2 = new GroupDataSource2(string, iDataSource);
        groupDataSource2.setExtract(element2.getAttributeValue(EXTRACT));
        for (Element element3 : element2.getChildren("item", NS_DATASOURCE)) {
            String string2 = element3.getAttributeValue("name");
            String string3 = element3.getAttributeValue("sort");
            String string4 = element3.getAttributeValue("group-on");
            String string5 = element3.getAttributeValue("group-data");
            String string6 = element3.getAttributeValue("derived-field");
            GroupDefinition groupDefinition = new GroupDefinition(string2, string3, string4, string5, string6);
            groupDataSource2.group(groupDefinition);
        }
        return groupDataSource2;
    }

    @Override
    public Element setDataSource(IDataSource iDataSource) throws DataException {
        if (!(iDataSource instanceof GroupDataSource2)) {
            throw new IllegalArgumentException("Not a GroupDataSource2");
        }
        GroupDataSource2 groupDataSource2 = (GroupDataSource2)iDataSource;
        Element element = this.defineDataSource(groupDataSource2);
        Element element2 = new Element("group", NS_DATASOURCE);
        element2.setAttribute("parent", groupDataSource2.getParent().getName());
        String string = groupDataSource2.getExtract();
        if (string != null) {
            element2.setAttribute(EXTRACT, string);
        }
        int n = groupDataSource2.getGroupCount();
        for (int i = 0; i < n; ++i) {
            GroupDefinition groupDefinition = groupDataSource2.getGroup(i);
            Element element3 = this.getItem(groupDefinition);
            element2.addContent(element3);
        }
        element.addContent(element2);
        return element;
    }

    protected Element getItem(GroupDefinition groupDefinition) {
        Element element = new Element("item", NS_DATASOURCE);
        element.setAttribute("name", this.attr(groupDefinition.getName()));
        element.setAttribute("sort", this.attr(groupDefinition.getSortOrder()));
        element.setAttribute("group-on", this.attr(groupDefinition.getGroupOn()));
        element.setAttribute("group-data", this.attr(groupDefinition.getGroupData()));
        element.setAttribute("derivedField", this.attr(groupDefinition.getDerivedFieldName()));
        return element;
    }

    protected String attr(String string) {
        if (string == null) {
            return "";
        }
        return string;
    }
}

