/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.olap;

import com.elixirtech.arch.Elixir;
import com.elixirtech.data2.DataType;
import com.elixirtech.data2.function.Function;
import com.elixirtech.data2.function.IFunctionFactory;
import com.elixirtech.data2.olap.Cube;
import com.elixirtech.data2.olap.Measure;

public class CubeHelper {
    public static final DataType CUBE_DATA_TYPE = DataType.DOUBLE;

    public static Measure[] buildMeasures(MeasureInfoSet measureInfoSet) {
        IFunctionFactory iFunctionFactory = (IFunctionFactory)Elixir.get(IFunctionFactory.class);
        Measure[] measureArray = new Measure[measureInfoSet.getCount()];
        Cube cube = measureInfoSet.getCube();
        assert (cube != null);
        for (int i = 0; i < measureArray.length; ++i) {
            String[] stringArray = measureInfoSet.getFunctionInfo(i);
            Function function = iFunctionFactory.getFunction(CUBE_DATA_TYPE, stringArray[1]);
            measureArray[i] = cube.createMeasure(stringArray[0], function, stringArray[2]);
        }
        return measureArray;
    }

    public static interface MeasureInfoSet {
        public static final int NAME = 0;
        public static final int FUNCTION_NAME = 1;
        public static final int PATTERN = 2;

        public Cube getCube();

        public int getCount();

        public String[] getFunctionInfo(int var1);
    }
}

