/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.olap;

import com.elixirtech.data2.olap.IDimension;
import com.elixirtech.data2.olap.Level;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Hierarchy
implements IDimension {
    protected String m_Name;
    protected List<Level> m_Levels = new ArrayList<Level>();

    public Hierarchy() {
    }

    public Hierarchy(String string) {
        this.m_Name = string;
    }

    @Override
    public String getType() {
        return "Hierarchy";
    }

    public void setName(String string) {
        this.m_Name = string;
    }

    @Override
    public String getName() {
        if (this.m_Name != null) {
            return this.m_Name;
        }
        if (this.m_Levels.size() > 0) {
            return this.m_Levels.get(0).getName();
        }
        return "All";
    }

    public void addLevel(Level level) {
        this.m_Levels.add(level);
    }

    public void addLevel(int n, Level level) {
        this.m_Levels.add(n, level);
    }

    public void removeLevel(Level level) {
        this.m_Levels.remove(level);
    }

    @Override
    public int getLevelCount() {
        return this.m_Levels.size();
    }

    public Iterator<Level> getLevelIterator() {
        return this.m_Levels.iterator();
    }

    @Override
    public Level getLevel(int n) {
        return this.m_Levels.get(n);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("olap.Hierarchy(");
        stringBuilder.append(super.toString());
        Iterator<Level> iterator = this.m_Levels.iterator();
        while (iterator.hasNext()) {
            stringBuilder.append(iterator.next());
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }
}

