/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.olap;

import com.elixirtech.data2.olap.IDataSet;
import com.elixirtech.data2.olap.Index;
import java.util.ArrayList;
import java.util.List;

public class TreeNode {
    public static final TreeNode[] EMPTY_ARRAY = new TreeNode[0];
    private final TreeNode m_Parent;
    private final IDataSet m_DataSet;
    private final List<TreeNode> m_Children = new ArrayList<TreeNode>();
    private final int m_Depth;
    private final Index m_TreeIndex;
    private String m_Name;

    protected TreeNode(IDataSet iDataSet) {
        this.m_Parent = null;
        this.m_DataSet = iDataSet;
        this.m_Depth = 0;
        this.m_TreeIndex = this.m_DataSet.getIndex();
    }

    public TreeNode(TreeNode treeNode, IDataSet iDataSet, Index index) {
        if (treeNode == null) {
            throw new IllegalArgumentException("parent cannot be null");
        }
        this.m_Parent = treeNode;
        this.m_DataSet = iDataSet;
        this.m_TreeIndex = index;
        this.m_Parent.addChild(this);
        this.m_Depth = this.m_Parent.m_Depth + 1;
    }

    public boolean isLeaf() {
        return this.m_Children.isEmpty();
    }

    public void addChild(TreeNode treeNode) {
        this.m_Children.add(treeNode);
    }

    public void removeChild(TreeNode treeNode) {
        this.m_Children.remove(treeNode);
    }

    public Index getTreeIndex() {
        return this.m_TreeIndex;
    }

    public IDataSet getDataSet() {
        return this.m_DataSet;
    }

    public Index getIndex() {
        return this.m_DataSet.getIndex();
    }

    public TreeNode getParent() {
        return this.m_Parent;
    }

    public List<TreeNode> getChildren() {
        return this.m_Children;
    }

    public int getDepth() {
        return this.m_Depth;
    }

    public int getMaxDepth() {
        int n = this.m_Depth;
        for (TreeNode treeNode : this.m_Children) {
            int n2 = treeNode.getMaxDepth();
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    public void setName(String string) {
        this.m_Name = string;
    }

    public String getName() {
        if (this.m_Name != null) {
            return this.m_Name;
        }
        if (this.m_DataSet != null) {
            return this.m_DataSet.getName();
        }
        return "All";
    }

    public TreeNode getChild(String string) {
        for (TreeNode treeNode : this.m_Children) {
            if (!string.equals(treeNode.getName())) continue;
            return treeNode;
        }
        return null;
    }

    public TreeNode[] getPath() {
        TreeNode[] treeNodeArray = new TreeNode[this.m_Depth + 1];
        this.buildPath(treeNodeArray);
        return treeNodeArray;
    }

    public boolean isShowTotals() {
        return this.m_DataSet.getLevel().isShowTotals();
    }

    public void buildLeaves(List<TreeNode> list) {
        if (this.m_Children.size() == 0) {
            list.add(this);
        } else {
            for (TreeNode treeNode : this.m_Children) {
                treeNode.buildLeaves(list);
            }
        }
    }

    public void buildAll(List<TreeNode> list) {
        for (TreeNode treeNode : this.m_Children) {
            treeNode.buildAll(list);
        }
        list.add(this);
    }

    protected void buildPath(TreeNode[] treeNodeArray) {
        treeNodeArray[this.m_Depth] = this;
        if (this.m_Parent != null) {
            this.m_Parent.buildPath(treeNodeArray);
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.buildString(stringBuilder, 0);
        return stringBuilder.toString();
    }

    private void buildString(StringBuilder stringBuilder, int n) {
        for (int i = 0; i < n; ++i) {
            stringBuilder.append("  ");
        }
        if (this.m_DataSet != null) {
            stringBuilder.append(this.m_DataSet.getName());
        } else {
            stringBuilder.append("Null DataSet");
        }
        stringBuilder.append("\n");
        for (TreeNode treeNode : this.m_Children) {
            treeNode.buildString(stringBuilder, n + 1);
        }
    }
}

