/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.output;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.arch.job.JobLogging;
import com.elixirtech.data2.ArgumentMap;
import com.elixirtech.data2.DataGroup;
import com.elixirtech.data2.DataRecord;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.data2.Parameter;
import com.elixirtech.data2.PushContext;
import com.elixirtech.data2.datasource.composite.DataStore;
import com.elixirtech.data2.output.DSWrapper;
import com.elixirtech.data2.output.IDataStore2;
import com.elixirtech.data2.output.OutputHandler;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class CSVDataStore
implements IDataStore2 {
    private static AtomicInteger m_SerialIds = new AtomicInteger(0);
    private int m_Serial = m_SerialIds.incrementAndGet();
    private String m_Name;
    private DataStore m_DataStore;
    protected String m_URL;
    private String m_URLString;
    protected Writer m_Writer;
    private PushContext m_Context;
    protected DataSchema m_Schema;
    private char m_SeparatorChar = (char)44;
    private char m_QualifierChar;
    private boolean m_Append;
    private String m_LineSeparator = "\r\n";
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(CSVDataStore.class);

    public CSVDataStore() {
    }

    public CSVDataStore(Writer writer) {
        this.m_Writer = writer;
    }

    @Override
    public <T> T getAdapter(Class<T> clazz) {
        if (clazz == IDataSource.class) {
            return clazz.cast(new DSWrapper(this));
        }
        return null;
    }

    @Override
    public void setContext(PushContext pushContext) {
        this.m_Context = pushContext;
    }

    @Override
    public String getName() {
        return this.m_Name;
    }

    @Override
    public void setName(String string) {
        this.m_Name = string;
    }

    @Override
    public DataStore getDataStore() {
        return this.m_DataStore;
    }

    @Override
    public void setDataStore(DataStore dataStore) {
        this.m_DataStore = dataStore;
    }

    @Override
    public List<Parameter> getParameters() {
        ArgumentMap argumentMap = new ArgumentMap();
        argumentMap.extractParameters(this.m_URL);
        return argumentMap.getParameters();
    }

    public void setURL(String string) {
        this.m_URL = string;
    }

    public String getURL() {
        return this.m_URL;
    }

    protected void setSeparatorChar(char c) {
        this.m_SeparatorChar = c;
    }

    protected char getSeparatorChar() {
        return this.m_SeparatorChar;
    }

    protected void setQualifierChar(char c) {
        this.m_QualifierChar = c;
    }

    protected char getQualifierChar() {
        return this.m_QualifierChar;
    }

    public void setSeparator(String string) {
        if ("Tab".equals(string)) {
            this.setSeparatorChar('\t');
        } else if ("Semicolon".equals(string)) {
            this.setSeparatorChar(';');
        } else if ("Comma".equals(string)) {
            this.setSeparatorChar(',');
        } else if ("Space".equals(string)) {
            this.setSeparatorChar(' ');
        } else if (string.length() > 0) {
            this.setSeparatorChar(string.charAt(0));
        }
    }

    public String getSeparator() {
        if (this.m_SeparatorChar == '\t') {
            return "Tab";
        }
        if (this.m_SeparatorChar == ';') {
            return "Semicolon";
        }
        if (this.m_SeparatorChar == ',') {
            return "Comma";
        }
        if (this.m_SeparatorChar == ' ') {
            return "Space";
        }
        return String.valueOf(this.m_SeparatorChar);
    }

    public void setQualifier(String string) {
        if (string == null || string.length() == 0 || "None".equals(string)) {
            this.setQualifierChar('\u0000');
        } else {
            this.setQualifierChar(string.charAt(0));
        }
    }

    public String getQualifier() {
        if (this.m_QualifierChar == '\u0000') {
            return "";
        }
        return String.valueOf(this.m_QualifierChar);
    }

    public void setAppend(boolean bl) {
        this.m_Append = bl;
    }

    public boolean getAppend() {
        return this.m_Append;
    }

    @Override
    public void startData(IDataSource iDataSource) {
        this.m_Schema = iDataSource.getSchema();
        boolean bl = false;
        if (this.m_Writer == null) {
            bl = this.initWriter();
        }
        if (!this.m_Append || !bl) {
            int n = this.m_Schema.getColumnCount();
            try {
                for (int i = 0; i < n; ++i) {
                    this.m_Writer.write(this.m_Schema.getColumnName(i));
                    if (i >= n - 1) continue;
                    this.m_Writer.write(this.m_SeparatorChar);
                }
                this.m_Writer.write(this.m_LineSeparator);
            }
            catch (IOException iOException) {
                m_Log.error((Object)"IOException in startData", (Throwable)iOException);
            }
        }
    }

    @Override
    public void startGroup(DataGroup dataGroup) {
    }

    @Override
    public boolean processRecord(DataRecord dataRecord) {
        Object[] objectArray = dataRecord.getData();
        try {
            for (int i = 0; i < objectArray.length; ++i) {
                if (this.m_QualifierChar != '\u0000') {
                    this.m_Writer.write(this.m_QualifierChar);
                }
                try {
                    boolean bl;
                    String string = this.m_Schema.format(this.m_Schema.getColumnType(i), objectArray[i]);
                    int n = this.m_QualifierChar != '\u0000' ? (int)this.m_QualifierChar : 34;
                    boolean bl2 = bl = string.indexOf(n) >= 0 || this.m_QualifierChar == '\u0000' && string.indexOf(this.m_SeparatorChar) >= 0;
                    if (bl) {
                        if (this.m_QualifierChar == '\u0000') {
                            this.m_Writer.write(34);
                            this.m_Writer.write(string.replace("\"", "\"\""));
                            this.m_Writer.write(34);
                        } else {
                            String string2 = "" + this.m_QualifierChar;
                            this.m_Writer.write(string.replace(string2, string2 + string2));
                        }
                    } else {
                        this.m_Writer.write(string);
                    }
                }
                catch (Exception exception) {
                    m_Log.error((Object)("Can't write field " + i + " with data " + objectArray[i]), (Throwable)exception);
                }
                if (this.m_QualifierChar != '\u0000') {
                    this.m_Writer.write(this.m_QualifierChar);
                }
                if (i >= objectArray.length - 1) continue;
                this.m_Writer.write(this.m_SeparatorChar);
            }
            this.m_Writer.write(this.m_LineSeparator);
            return this.m_Context != null ? !this.m_Context.isAborted() : true;
        }
        catch (IOException iOException) {
            m_Log.error((Object)"IOException in processRecord", (Throwable)iOException);
            throw new RuntimeException("IOException in processRecord", iOException);
        }
    }

    @Override
    public void endGroup(DataGroup dataGroup) {
    }

    @Override
    public void endData(IDataSource iDataSource) {
        if (this.m_URL != null) {
            try {
                String string = "[" + this.m_Serial + "] Closing " + this.m_URLString;
                m_Log.info((Object)string);
                JobLogging.logInfo("CSVDataStore", string);
                this.m_Writer.close();
                this.m_URL = null;
            }
            catch (IOException iOException) {
                m_Log.error((Object)"IOException in endData", (Throwable)iOException);
                throw new RuntimeException("IOException in endData", iOException);
            }
        }
    }

    protected boolean initWriter() {
        this.m_URLString = this.m_Context.substitute(this.m_URL);
        Object object = this.m_URLString;
        if (!OutputHandler.hasExtension((String)object)) {
            object = (String)object + ".csv";
        }
        try {
            boolean bl = OutputHandler.exists((String)object);
            OutputStream outputStream = OutputHandler.getOutputStream((String)object, this.m_Append);
            String string = "[" + this.m_Serial + "] Opening " + this.m_URLString + " for output (append=" + this.m_Append + ")";
            m_Log.info((Object)string);
            JobLogging.logInfo("CSVDataStore", string);
            this.m_Writer = new BufferedWriter(new OutputStreamWriter(outputStream, "UTF-8"));
            return bl;
        }
        catch (IOException iOException) {
            m_Log.error((Object)"IOException in initWriter", (Throwable)iOException);
            throw new RuntimeException("IOException in initWriter", iOException);
        }
    }
}

