/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.types;

import com.elixirtech.data2.DataType;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Date;

public class BooleanDataType
extends DataType {
    @Override
    public int getTypeId() {
        return 3;
    }

    @Override
    public String getTypeName() {
        return "Boolean";
    }

    @Override
    public boolean isNumeric() {
        return false;
    }

    @Override
    public Object defaultValue() {
        return Boolean.FALSE;
    }

    @Override
    public int compare(Object object, Object object2) {
        if (object == null && object2 == null) {
            return 0;
        }
        if (object == null) {
            return -1;
        }
        if (object2 == null) {
            return 1;
        }
        Boolean bl = (Boolean)object;
        Boolean bl2 = (Boolean)object2;
        return bl.compareTo(bl2);
    }

    @Override
    public Boolean narrow(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof Number) {
            return ((Number)object).doubleValue() != 0.0;
        }
        if (object instanceof String) {
            return ((String)object).length() != 0;
        }
        if (object instanceof Date) {
            return ((Date)object).getTime() != 0L;
        }
        if (object instanceof byte[]) {
            return ((byte[])object).length != 0;
        }
        return Boolean.TRUE;
    }

    @Override
    public int writeLength(Object object) {
        if (object == null) {
            return 1;
        }
        return 2;
    }

    @Override
    public void write(DataOutputStream dataOutputStream, Object object) throws IOException {
        if (object == null) {
            dataOutputStream.writeByte(0);
        } else {
            dataOutputStream.writeByte(3);
            if (Boolean.TRUE.equals(object)) {
                dataOutputStream.writeByte(84);
            } else {
                dataOutputStream.writeByte(70);
            }
        }
    }

    @Override
    public Object read(DataInputStream dataInputStream) throws IOException {
        byte by = dataInputStream.readByte();
        if (by == 0) {
            return null;
        }
        if (by != 3) {
            throw new IOException("Boolean tag expected, got " + by);
        }
        byte by2 = dataInputStream.readByte();
        if (by2 == 84) {
            return Boolean.TRUE;
        }
        if (by2 == 70) {
            return Boolean.FALSE;
        }
        throw new IOException("Invalid boolean value: " + by2);
    }
}

