/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.types;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.data2.DataType;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class DoubleDataType
extends DataType {
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(DoubleDataType.class);

    @Override
    public int getTypeId() {
        return 6;
    }

    @Override
    public String getTypeName() {
        return "Double";
    }

    @Override
    public boolean isNumeric() {
        return true;
    }

    @Override
    public Object defaultValue() {
        return 0.0;
    }

    @Override
    public int compare(Object object, Object object2) {
        if (object == null && object2 == null) {
            return 0;
        }
        if (object == null) {
            return -1;
        }
        if (object2 == null) {
            return 1;
        }
        Double d = (Double)object;
        Double d2 = (Double)object2;
        return d.compareTo(d2);
    }

    @Override
    public Double narrow(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Double) {
            return (Double)object;
        }
        if (object instanceof Number) {
            return ((Number)object).doubleValue();
        }
        try {
            return Double.valueOf(String.valueOf(object));
        }
        catch (NumberFormatException numberFormatException) {
            m_Log.error((Object)("Cannot parse " + object + " as a Double"));
            return 0.0;
        }
    }

    @Override
    public int writeLength(Object object) {
        if (object == null) {
            return 1;
        }
        return 9;
    }

    @Override
    public void write(DataOutputStream dataOutputStream, Object object) throws IOException {
        if (object == null) {
            dataOutputStream.writeByte(0);
        } else {
            Double d = (Double)object;
            dataOutputStream.writeByte(6);
            dataOutputStream.writeDouble(d);
        }
    }

    @Override
    public Object read(DataInputStream dataInputStream) throws IOException {
        byte by = dataInputStream.readByte();
        if (by == 0) {
            return null;
        }
        if (by != 6) {
            throw new IOException("Double tag expected, got " + by);
        }
        return dataInputStream.readDouble();
    }
}

