/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.xlsx;

import com.elixirtech.data2.xlsx.Range;
import com.elixirtech.data2.xlsx.Sheet;
import com.elixirtech.data2.xlsx.Style;
import com.elixirtech.data2.xlsx.XLSXReader;
import com.elixirtech.jdom.Document;
import com.elixirtech.jdom.Element;
import com.elixirtech.opc.Build;
import com.elixirtech.opc.Package;
import com.elixirtech.opc.RelationshipsPart;
import com.elixirtech.opc.XMLPart;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Workbook {
    private final Package m_Package;
    private final List<Sheet> m_Sheets = new ArrayList<Sheet>();
    private final List<String> m_SharedStrings = new ArrayList<String>();
    private final List<Style> m_Styles = new ArrayList<Style>();
    private final Map<String, Range> m_Ranges = new HashMap<String, Range>();
    private boolean m_Uses1904Dates;

    public Workbook(Package package_) {
        this.m_Package = package_;
        this.loadProperties();
        this.loadSharedStrings();
        this.loadStyles();
        this.loadSheets();
        this.loadRanges();
    }

    public int getSheetCount() {
        return this.m_Sheets.size();
    }

    public int getUsedSheetCount() {
        int n = this.m_Sheets.size();
        for (int i = 0; i < n; ++i) {
            Sheet sheet = this.m_Sheets.get(i);
            if (sheet.getRowCount() != 0) continue;
            return i;
        }
        return n;
    }

    public Sheet getSheet(int n) {
        return this.m_Sheets.get(n);
    }

    public Sheet getSheet(String string) {
        for (Sheet sheet : this.m_Sheets) {
            if (!string.equals(sheet.getName())) continue;
            return sheet;
        }
        return null;
    }

    public int getSheetIndex(String string) {
        int n = this.m_Sheets.size();
        for (int i = 0; i < n; ++i) {
            Sheet sheet = this.m_Sheets.get(i);
            if (!string.equals(sheet.getName())) continue;
            return i;
        }
        return -1;
    }

    public String getSharedString(int n) {
        return this.m_SharedStrings.get(n);
    }

    public Style getStyle(int n) {
        return this.m_Styles.get(n);
    }

    public Range getRange(String string) {
        return null;
    }

    public boolean uses1904Dates() {
        return this.m_Uses1904Dates;
    }

    protected void loadProperties() {
        XMLPart xMLPart = (XMLPart)this.m_Package.getPart("/xl/workbook.xml");
        Document document = xMLPart.getDocument();
        Element element = document.getRootElement();
        if (!"workbook".equals(element.getName())) {
            throw new IllegalStateException("root element is " + element.getName());
        }
        Element element2 = element.getChild("workbookPr", XLSXReader.NS);
        this.m_Uses1904Dates = element2.getAttribute("date1904") != null;
    }

    protected void loadSheets() {
        XMLPart xMLPart = (XMLPart)this.m_Package.getPart("/xl/workbook.xml");
        Document document = xMLPart.getDocument();
        Element element = document.getRootElement();
        if (!"workbook".equals(element.getName())) {
            throw new IllegalStateException("root element is " + element.getName());
        }
        Element element2 = element.getChild("sheets", XLSXReader.NS);
        if (element2 == null) {
            throw new IllegalStateException("sheets==null");
        }
        RelationshipsPart relationshipsPart = xMLPart.getRelationships();
        for (Element element3 : element2.getChildren("sheet", XLSXReader.NS)) {
            String string = element3.getAttributeValue("name");
            String string2 = element3.getAttributeValue("id", Build.NS_R2);
            String string3 = relationshipsPart.getPartName(string2);
            Sheet sheet = new Sheet(this, string, (XMLPart)this.m_Package.getPart(string3));
            this.m_Sheets.add(sheet);
        }
    }

    protected void loadSharedStrings() {
        XMLPart xMLPart = (XMLPart)this.m_Package.getPart("/xl/sharedStrings.xml");
        if (xMLPart != null) {
            Element element = xMLPart.getDocument().getRootElement();
            for (Element element2 : element.getChildren("si", XLSXReader.NS)) {
                Element element3 = element2.getChild("t", XLSXReader.NS);
                if (element3 != null) {
                    this.m_SharedStrings.add(element3.getText());
                    continue;
                }
                this.m_SharedStrings.add("");
            }
        }
    }

    protected void loadStyles() {
        Object object;
        Object object2;
        XMLPart xMLPart = (XMLPart)this.m_Package.getPart("/xl/styles.xml");
        Element element = xMLPart.getDocument().getRootElement();
        Element element2 = element.getChild("numFmts", XLSXReader.NS);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (element2 != null) {
            object2 = element2.getChildren("numFmt", XLSXReader.NS).iterator();
            while (object2.hasNext()) {
                Element element3 = (Element)object2.next();
                String object3 = element3.getAttributeValue("numFmtId");
                object = element3.getAttributeValue("formatCode");
                hashMap.put(object3, (String)object);
            }
        }
        if ((object2 = element.getChild("cellXfs", XLSXReader.NS)) != null) {
            for (Element element3 : ((Element)object2).getChildren("xf", XLSXReader.NS)) {
                object = new Style(element3);
                String string = (String)hashMap.get(String.valueOf(((Style)object).getFormatId()));
                if (string != null) {
                    boolean bl;
                    boolean bl2 = string.indexOf(100) >= 0 || string.indexOf(121) >= 0;
                    boolean bl3 = bl = string.indexOf(104) >= 0 || string.indexOf(115) >= 0;
                    if (bl2 && bl) {
                        ((Style)object).setCustomType(4);
                    } else if (bl2) {
                        ((Style)object).setCustomType(2);
                    } else if (bl) {
                        ((Style)object).setCustomType(3);
                    }
                }
                this.m_Styles.add((Style)object);
            }
        }
    }

    protected void loadRanges() {
        XMLPart xMLPart = (XMLPart)this.m_Package.getPart("/xl/workbook.xml");
        Document document = xMLPart.getDocument();
        Element element = document.getRootElement();
        if (!"workbook".equals(element.getName())) {
            throw new IllegalStateException("root element is " + element.getName());
        }
        Element element2 = element.getChild("definedNames", XLSXReader.NS);
        if (element2 != null) {
            for (Element element3 : element2.getChildren("definedName", XLSXReader.NS)) {
                String string = element3.getAttributeValue("name");
                String string2 = element3.getText();
                this.m_Ranges.put(string, new Range(this, string2));
            }
        }
    }
}

