/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.edifact;

import com.elixirtech.edifact.Annotation;
import com.elixirtech.edifact.Tokenizer;
import com.elixirtech.edifact.TreeNode;
import com.elixirtech.jdom.Document;
import com.elixirtech.jdom.Element;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

public class Parser {
    private final TreeNode m_Root;

    public Parser(InputStream inputStream) throws IOException {
        this(Parser.buildReader(inputStream));
    }

    private static Reader buildReader(InputStream inputStream) throws IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        String string = Parser.determineEncoding(bufferedInputStream);
        return new InputStreamReader((InputStream)bufferedInputStream, string);
    }

    public Parser(Reader reader) throws IOException {
        TreeNode treeNode = this.m_Root = new TreeNode(null, null);
        treeNode.setName("EDIFACT");
        Annotation annotation = new Annotation(new Tokenizer(reader));
        treeNode = new TreeNode(treeNode, null);
        Tokenizer.Token token = annotation.next();
        treeNode.setName(token.data);
        while (annotation.hasNext()) {
            Object object;
            Tokenizer.Token token2 = annotation.next();
            if (token2.id == 1) {
                if (treeNode != this.m_Root) {
                    treeNode = treeNode.getParent();
                }
                if ((object = annotation.next()) == null) continue;
                treeNode = new TreeNode(treeNode, token2);
                treeNode.setName(((Tokenizer.Token)object).data);
                continue;
            }
            if (token2.id == 4) {
                treeNode = new TreeNode(treeNode, token2);
                treeNode.setName("component");
                continue;
            }
            if (token2.id == 6) {
                if (treeNode == this.m_Root) continue;
                treeNode = treeNode.getParent();
                continue;
            }
            if (token2.id == 2 || token2.id == 3) continue;
            object = new TreeNode(treeNode, token2);
            ((TreeNode)object).setName("simple");
        }
    }

    private static String determineEncoding(InputStream inputStream) throws IOException {
        if (!inputStream.markSupported()) {
            throw new IOException("Mark not supported on " + inputStream);
        }
        inputStream.mark(10);
        String string = "646";
        byte[] byArray = new byte[10];
        inputStream.read(byArray);
        if (byArray[0] != 85 || byArray[1] != 78 || byArray[2] != 66) {
            throw new IOException("Missing UNB header");
        }
        if (byArray[3] == 43 && byArray[4] == 85 && byArray[5] == 78 && byArray[6] == 79) {
            switch (byArray[7]) {
                case 65: {
                    string = "646";
                    break;
                }
                case 66: {
                    string = "646";
                    break;
                }
                case 67: {
                    string = "ISO-8859-1";
                    break;
                }
                case 68: {
                    string = "ISO-8859-2";
                    break;
                }
                case 69: {
                    string = "ISO-8859-5";
                    break;
                }
                case 70: {
                    string = "ISO-8859-7";
                    break;
                }
                case 71: {
                    string = "ISO-8859-3";
                    break;
                }
                case 72: {
                    string = "ISO-8859-4";
                    break;
                }
                case 73: {
                    string = "ISO-8859-6";
                    break;
                }
                case 74: {
                    string = "ISO-8859-8";
                    break;
                }
                case 75: {
                    string = "ISO-8859-9";
                    break;
                }
                case 88: {
                    string = "ISO-2022-CN-CNS";
                    break;
                }
                case 89: {
                    string = "ISO-10646-UCS-2";
                    break;
                }
                default: {
                    throw new RuntimeException("Unexpected encoding: " + byArray[7]);
                }
            }
        }
        inputStream.reset();
        return string;
    }

    public TreeNode getTree() {
        return this.m_Root;
    }

    public Document getDocument() {
        return new Document(Parser.buildXML(this.m_Root));
    }

    private static Element buildXML(TreeNode treeNode) {
        String string = treeNode.getName();
        if (string == null) {
            string = "item";
        }
        Element element = new Element(string);
        Tokenizer.Token token = treeNode.getToken();
        if (token != null && token.data != null) {
            element.setText(token.data);
        }
        for (TreeNode treeNode2 : treeNode.getChildren()) {
            element.addContent(Parser.buildXML(treeNode2));
        }
        return element;
    }
}

