/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ensemble.canvas;

import com.elixirtech.canvas.graph.Node;
import com.elixirtech.canvas.graph.RelCol;
import com.elixirtech.canvas.graph.RelType;
import com.elixirtech.data2.DataAttribute;
import com.elixirtech.data2.DataAttributes;
import com.elixirtech.data2.DataType;
import com.elixirtech.ensemble.canvas.AttributeNode;
import java.util.ArrayList;
import java.util.Map;

public class DerivedNode
extends Node {
    private String m_Name;
    private DataType m_Type;
    private String m_Value;

    public DerivedNode() {
    }

    public DerivedNode(String string, DataType dataType, String string2, DataAttributes dataAttributes) {
        this.m_Name = string;
        this.m_Type = dataType;
        this.m_Value = string2;
        if (dataAttributes != null) {
            for (DataAttribute dataAttribute : dataAttributes.getAttributes()) {
                AttributeNode attributeNode = new AttributeNode(dataAttribute);
                this.connectTo(attributeNode, RelType.Owns);
            }
        }
    }

    public String getName() {
        return this.m_Name;
    }

    public DataType getType() {
        return this.m_Type;
    }

    public String getValue() {
        return this.m_Value;
    }

    public DataAttributes getAttributes() {
        RelCol relCol = this.getOutRelCol(RelType.Owns);
        ArrayList<DataAttribute> arrayList = new ArrayList<DataAttribute>();
        int n = relCol.getCount();
        for (int i = 0; i < n; ++i) {
            AttributeNode attributeNode = (AttributeNode)relCol.getItem(i).getDestination();
            arrayList.add(attributeNode.getDataAttribute());
        }
        return new DataAttributes(arrayList);
    }

    @Override
    public Map<String, String> getProperties() {
        Map<String, String> map = super.getProperties();
        map.put("Name", this.m_Name);
        map.put("DataType", this.m_Type.getTypeName());
        map.put("Value", this.m_Value);
        return map;
    }

    @Override
    public void setProperty(String string, String string2) {
        if (string.equals("Name")) {
            this.m_Name = string2;
        } else if (string.equals("DataType")) {
            this.m_Type = DataType.getInstance(string2);
        } else if (string.equals("Value")) {
            this.m_Value = string2;
        } else {
            super.setProperty(string, string2);
        }
    }
}

