/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ensemble.canvas;

import com.elixirtech.awt.ITextHolder;
import com.elixirtech.canvas.corego.RectGO;
import com.elixirtech.canvas.geometry.Geometry;
import com.elixirtech.canvas.geometry.RectangleEx;
import com.elixirtech.canvas.graph.Node;
import com.elixirtech.canvas.graph.Relationship;
import com.elixirtech.data2.ArgumentMap;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.ensemble.canvas.DataFlowGO;
import com.elixirtech.ensemble.canvas.GOLabels;
import com.elixirtech.ui.StandardColor;
import java.awt.Color;
import java.awt.Font;
import java.awt.Point;
import java.awt.font.FontRenderContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class InOutGO
extends RectGO
implements ITextHolder {
    static final Font LABEL_FONT = new Font("SansSerif", 0, 10);
    protected static final String TEXT = "text";
    protected static final String FILL = "fill";
    protected String m_Text;
    protected Color m_FillColor = StandardColor.WHEAT;
    protected List<In> m_Ins = new ArrayList<In>();
    protected List<Out> m_Outs = new ArrayList<Out>();
    protected static final int TEXT_HANDLE = 100;
    static final FontRenderContext FRC = new FontRenderContext(null, false, false);
    static final int FONT_HEIGHT = (int)Math.ceil(LABEL_FONT.getLineMetrics("Sample chars", FRC).getHeight());

    public InOutGO() {
        this.m_MinWidth = 60;
        this.m_MinHeight = 40;
        this.m_Rect = new RectangleEx(0, 0, this.m_MinWidth + 20, this.m_MinHeight);
    }

    @Override
    public void setText(String string) {
        this.m_Text = string;
    }

    @Override
    public String getText() {
        return this.m_Text;
    }

    public abstract DataSchema getSchema();

    public void buildParameters(ArgumentMap argumentMap) {
    }

    @Override
    public Point snapToEdge(Point point) {
        double d = Double.MAX_VALUE;
        Point object = null;
        for (In object2 : this.m_Ins) {
            Point point2 = object2.getTip();
            double d2 = Geometry.distanceBetweenPoints(point2, point);
            if (!(d2 < d)) continue;
            d = d2;
            object = point2;
        }
        for (Out out : this.m_Outs) {
            Point point3 = out.getTip();
            double d3 = Geometry.distanceBetweenPoints(point3, point);
            if (!(d3 < d)) continue;
            d = d3;
            object = point3;
        }
        return object;
    }

    @Override
    public void buildDeleteSet(Set<Node> set) {
        if (set.contains(this)) {
            return;
        }
        set.add(this);
        for (Relationship relationship : this.getOutRelationships()) {
            Node node = relationship.getDestination();
            if (!(node instanceof DataFlowGO)) continue;
            node.buildDeleteSet(set);
        }
    }

    public In getIn(Point point) {
        In in = null;
        if (point != null) {
            double d = Double.MAX_VALUE;
            for (In in2 : this.m_Ins) {
                Point point2 = in2.getTip();
                double d2 = Geometry.distanceBetweenPoints(point2, point);
                if (!(d2 < d)) continue;
                d = d2;
                in = in2;
            }
        }
        if (in == null) {
            System.out.println("InOutGO getIn for " + this + " with pt " + point + " returns null");
        }
        return in;
    }

    public Out getOut(Point point) {
        double d = Double.MAX_VALUE;
        Out out = null;
        for (Out out2 : this.m_Outs) {
            Point point2 = out2.getTip();
            double d2 = Geometry.distanceBetweenPoints(point2, point);
            if (!(d2 < d)) continue;
            d = d2;
            out = out2;
        }
        return out;
    }

    public In getIn(String string) {
        int n = this.m_Ins.size();
        for (int i = 0; i < n; ++i) {
            In in = this.m_Ins.get(i);
            if (!in.getId().equals(string)) continue;
            return in;
        }
        return null;
    }

    public Out getOut(String string) {
        int n = this.m_Outs.size();
        for (int i = 0; i < n; ++i) {
            Out out = this.m_Outs.get(i);
            if (!out.getId().equals(string)) continue;
            return out;
        }
        return null;
    }

    public List<DataFlowGO> getFlowGOs(In in) {
        ArrayList<DataFlowGO> arrayList = new ArrayList<DataFlowGO>();
        for (Relationship relationship : this.getOutRelationships()) {
            DataFlowGO dataFlowGO;
            Node node = relationship.getDestination();
            if (!(node instanceof DataFlowGO) || (dataFlowGO = (DataFlowGO)node).getStopIO() != in) continue;
            arrayList.add(dataFlowGO);
        }
        return arrayList;
    }

    public List<DataFlowGO> getFlowGOs(Out out) {
        ArrayList<DataFlowGO> arrayList = new ArrayList<DataFlowGO>();
        for (Relationship relationship : this.getOutRelationships()) {
            DataFlowGO dataFlowGO;
            Node node = relationship.getDestination();
            if (!(node instanceof DataFlowGO) || (dataFlowGO = (DataFlowGO)node).getStartIO() != out) continue;
            arrayList.add(dataFlowGO);
        }
        return arrayList;
    }

    @Override
    public Map<String, String> getProperties() {
        Map<String, String> map = super.getProperties();
        if (this.m_Text != null) {
            map.put(TEXT, this.m_Text);
        }
        map.put(FILL, StandardColor.getColorName(this.m_FillColor));
        return map;
    }

    @Override
    public void setProperty(String string, String string2) {
        if (string.equals(TEXT)) {
            this.m_Text = string2;
        } else if (string.equals(FILL)) {
            this.m_FillColor = StandardColor.lookup(string2);
        } else {
            super.setProperty(string, string2);
        }
    }

    public Color getFillColor() {
        return this.m_FillColor;
    }

    public void setFillColor(Color color) {
        this.m_FillColor = color;
    }

    public int stringWidth(String string) {
        return (int)Math.ceil(LABEL_FONT.getStringBounds(string, FRC).getWidth());
    }

    public int getRectGOLeft() {
        return this.m_Rect.left;
    }

    public int getRectGORight() {
        return this.m_Rect.right;
    }

    public int getRectGOTop() {
        return this.m_Rect.top;
    }

    public List<In> getIns() {
        return this.m_Ins;
    }

    public List<Out> getOuts() {
        return this.m_Outs;
    }

    public class In
    extends IOBase {
        public In(String string, double d) {
            super(string, d);
        }

        @Override
        public Point getTip() {
            RectangleEx rectangleEx = InOutGO.this.getRect();
            return new Point(InOutGO.this.getRectGOLeft() - this.m_Width, (int)((double)rectangleEx.top + (double)rectangleEx.height() * this.m_Y));
        }
    }

    public class Out
    extends IOBase {
        public Out(String string, double d) {
            super(string, d);
        }

        @Override
        public Point getTip() {
            int n = InOutGO.this.getRectGORight();
            RectangleEx rectangleEx = InOutGO.this.getRect();
            return new Point(n + this.m_Width, (int)((double)rectangleEx.top + (double)rectangleEx.height() * this.m_Y));
        }
    }

    public abstract class IOBase {
        protected String m_Id;
        protected String m_Label;
        public int m_Width;
        public double m_Y;

        public IOBase(String string, double d) {
            this.m_Id = string;
            this.m_Label = GOLabels.ioText(string);
            this.m_Width = InOutGO.this.stringWidth(string) + 5;
            this.m_Width = 5 * (this.m_Width / 5) + 5 - this.m_Width % 5;
            this.m_Y = d;
        }

        public void setWidthToMatchLabel(String string) {
            int n = InOutGO.this.stringWidth(string) + 5;
            n = 5 * (n / 5) + 5 - n % 5;
            this.m_Width = Math.max(this.m_Width, n);
        }

        public String getId() {
            return this.m_Id;
        }

        public String getLabel() {
            return this.m_Label;
        }

        public abstract Point getTip();
    }

    public class Top
    extends In {
        public int m_Height;

        public Top(String string, double d) {
            super(string, d);
            this.m_Height = FONT_HEIGHT + 5;
            this.m_Height = 5 * (this.m_Height / 5) + 5 - this.m_Height % 5;
        }

        @Override
        public Point getTip() {
            int n = InOutGO.this.getRectGOTop();
            RectangleEx rectangleEx = InOutGO.this.getRect();
            return new Point((int)((double)rectangleEx.left + (double)rectangleEx.width() * this.m_Y), n - this.m_Height);
        }
    }
}

