/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ensemble.ds.builders;

import com.elixirtech.arch.StringUtil;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.data2.olap.Cube;
import com.elixirtech.data2.olap.CubeDataSource;
import com.elixirtech.data2.olap.CubeHelper;
import com.elixirtech.data2.olap.IDimension;
import com.elixirtech.data2.olap.Level;
import com.elixirtech.data2.olap.Measure;
import com.elixirtech.ensemble.canvas.CubeGO;
import com.elixirtech.ensemble.canvas.DimensionNode;
import com.elixirtech.ensemble.canvas.InOutGO;
import com.elixirtech.ensemble.canvas.MeasureNode;
import com.elixirtech.ensemble.canvas.SortNode;
import com.elixirtech.ensemble.ds.builders.BuildContext;

public class CubeBuilder {
    public void build(BuildContext buildContext, InOutGO inOutGO) {
        CubeGO cubeGO = (CubeGO)inOutGO;
        InOutGO inOutGO2 = cubeGO.getInput();
        buildContext.addGO(inOutGO2);
        String string = buildContext.getNodeId(cubeGO);
        String string2 = buildContext.getNodeId(inOutGO2);
        IDataSource iDataSource = buildContext.getDataSource(string2);
        if (iDataSource != null) {
            Measure[] measureArray;
            Cube cube = new Cube(iDataSource);
            DataSchema dataSchema = iDataSource.getSchema();
            this.buildDimensions(cubeGO, cube, dataSchema);
            try {
                measureArray = this.buildMeasures(cubeGO, cube);
            }
            catch (RuntimeException runtimeException) {
                System.out.println("CubeBuilder CANT_BUILD_SCHEMA");
                runtimeException.printStackTrace();
                return;
            }
            IDimension[] iDimensionArray = this.buildRows(cubeGO, cube);
            IDimension[] iDimensionArray2 = this.buildColumns(cubeGO, cube);
            try {
                CubeDataSource cubeDataSource = new CubeDataSource(string, cube, iDimensionArray, iDimensionArray2, measureArray);
                cubeDataSource.setSchema(cubeGO.getSchema());
                cubeDataSource.setCollapseRows(cubeGO.isCollapseRows());
                cubeDataSource.setCollapseColumns(cubeGO.isCollapseColumns());
                cubeDataSource.setKeepRowTotals(cubeGO.isKeepRowTotals());
                cubeDataSource.setKeepColumnTotals(cubeGO.isKeepColumnTotals());
                cubeDataSource.setRowTitle(cubeGO.getRowTitle());
                cubeDataSource.setColumnTitle(cubeGO.getColumnTitle());
                buildContext.addDataSource(cubeGO, string, cubeDataSource);
            }
            catch (RuntimeException runtimeException) {
                System.out.println("CubeBuilder.CANT_BUILD_CUBE");
                runtimeException.printStackTrace();
            }
        }
    }

    private IDimension[] buildColumns(CubeGO cubeGO, Cube cube) {
        String[] stringArray = cubeGO.getUserProperty("Cube_Column").split(",");
        if (StringUtil.isEmpty(stringArray[0])) {
            stringArray = new String[]{};
        }
        String[] stringArray2 = CubeBuilder.loadUserProperty(cubeGO, "Cube_Column_Sort", "Ascending", stringArray.length);
        String[] stringArray3 = CubeBuilder.loadUserProperty(cubeGO, "Cube_Column_GroupOn", "Each Value", stringArray.length);
        String[] stringArray4 = CubeBuilder.loadUserProperty(cubeGO, "Cube_Column_GroupData", "", stringArray.length);
        String[] stringArray5 = CubeBuilder.loadUserProperty(cubeGO, "Cube_Column_ShowTotals", "Yes", stringArray.length);
        IDimension[] iDimensionArray = new IDimension[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            iDimensionArray[i] = cube.hasHierarchy(stringArray[i]) ? cube.getHierarchy(stringArray[i]) : cube.createDimension(stringArray[i], stringArray2[i], stringArray3[i], stringArray4[i], null, "Yes".equals(stringArray5[i]));
        }
        return iDimensionArray;
    }

    private IDimension[] buildRows(CubeGO cubeGO, Cube cube) {
        String[] stringArray = cubeGO.getUserProperty("Cube_Row").split(",");
        if (StringUtil.isEmpty(stringArray[0])) {
            stringArray = new String[]{};
        }
        String[] stringArray2 = CubeBuilder.loadUserProperty(cubeGO, "Cube_Row_Sort", "Ascending", stringArray.length);
        String[] stringArray3 = CubeBuilder.loadUserProperty(cubeGO, "Cube_Row_GroupOn", "Each Value", stringArray.length);
        String[] stringArray4 = CubeBuilder.loadUserProperty(cubeGO, "Cube_Row_GroupData", "", stringArray.length);
        String[] stringArray5 = CubeBuilder.loadUserProperty(cubeGO, "Cube_Row_ShowTotals", "Yes", stringArray.length);
        IDimension[] iDimensionArray = new IDimension[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            iDimensionArray[i] = cube.hasHierarchy(stringArray[i]) ? cube.getHierarchy(stringArray[i]) : cube.createDimension(stringArray[i], stringArray2[i], stringArray3[i], stringArray4[i], null, "Yes".equals(stringArray5[i]));
        }
        return iDimensionArray;
    }

    private Measure[] buildMeasures(final CubeGO cubeGO, final Cube cube) {
        CubeHelper.MeasureInfoSet measureInfoSet = new CubeHelper.MeasureInfoSet(){

            @Override
            public int getCount() {
                return cubeGO.getMeasureCount();
            }

            @Override
            public String[] getFunctionInfo(int n) {
                MeasureNode measureNode = cubeGO.getMeasure(n);
                return new String[]{measureNode.getName(), measureNode.getFunction(), measureNode.getPattern()};
            }

            @Override
            public Cube getCube() {
                return cube;
            }
        };
        return CubeHelper.buildMeasures(measureInfoSet);
    }

    private void buildDimensions(CubeGO cubeGO, Cube cube, DataSchema dataSchema) {
        int n = cubeGO.getDimensionCount();
        for (int i = 0; i < n; ++i) {
            DimensionNode dimensionNode = cubeGO.getDimension(i);
            String string = dimensionNode.getName();
            Level[] levelArray = CubeBuilder.getLevels(dataSchema, dimensionNode.getPath());
            if (levelArray.length == 1) {
                if (dataSchema.getColumnIndex(string) >= 0) continue;
                cube.createHierarchy(string, levelArray);
                continue;
            }
            cube.createHierarchy(string, levelArray);
        }
    }

    public static String[] loadUserProperty(CubeGO cubeGO, String string, String string2, int n) {
        if (n == 0) {
            return new String[0];
        }
        String string3 = cubeGO.getUserProperty(string);
        if (string3 != null) {
            String[] stringArray = string3.split("#");
            if (stringArray.length != n) {
                String[] stringArray2 = new String[n];
                System.arraycopy(stringArray, 0, stringArray2, 0, Math.min(stringArray.length, stringArray2.length));
                stringArray = stringArray2;
            }
            return stringArray;
        }
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = string2;
        }
        return stringArray;
    }

    private static Level[] getLevels(DataSchema dataSchema, SortNode[] sortNodeArray) {
        Level[] levelArray = new Level[sortNodeArray.length];
        for (int i = 0; i < sortNodeArray.length; ++i) {
            levelArray[i] = new Level(sortNodeArray[i].getName(), sortNodeArray[i].getSortOrder(), sortNodeArray[i].getGroupOn(), sortNodeArray[i].getGroupData(), sortNodeArray[i].getDerivedField());
        }
        return levelArray;
    }
}

