/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ensemble.ds.builders;

import com.elixirtech.arch.StringUtil;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.data2.datasource.derivative.CrossJoinDerivative;
import com.elixirtech.data2.datasource.derivative.DerivedDataSource;
import com.elixirtech.data2.datasource.derivative.JoinDerivative;
import com.elixirtech.data2.datasource.derivative.Prefix;
import com.elixirtech.ensemble.canvas.DataFlowGO;
import com.elixirtech.ensemble.canvas.GOUtil;
import com.elixirtech.ensemble.canvas.InOutGO;
import com.elixirtech.ensemble.canvas.JoinGO;
import com.elixirtech.ensemble.canvas.JoinNode;
import com.elixirtech.ensemble.ds.builders.BuildContext;
import java.util.List;

public class JoinBuilder {
    public void build(BuildContext buildContext, InOutGO inOutGO) {
        JoinGO joinGO = (JoinGO)inOutGO;
        List<DataFlowGO> list = joinGO.getFlowGOs(joinGO.getIn("primary"));
        if (list.size() != 1) {
            return;
        }
        DataFlowGO dataFlowGO = list.get(0);
        InOutGO inOutGO2 = (InOutGO)dataFlowGO.getStartGO();
        buildContext.addGO(inOutGO2);
        String string = buildContext.getNodeId(inOutGO2);
        DataSchema dataSchema = dataFlowGO.getSchema();
        List<DataFlowGO> list2 = joinGO.getFlowGOs(joinGO.getIn("secondary"));
        if (list2.size() != 1) {
            return;
        }
        DataFlowGO dataFlowGO2 = list2.get(0);
        InOutGO inOutGO3 = (InOutGO)dataFlowGO2.getStartGO();
        buildContext.addGO(inOutGO3);
        String string2 = buildContext.getNodeId(inOutGO3);
        DataSchema dataSchema2 = dataFlowGO2.getSchema();
        if (string != null && string2 != null && dataSchema != null && dataSchema2 != null) {
            String string3 = buildContext.getNodeId(joinGO);
            DerivedDataSource derivedDataSource = new DerivedDataSource(string3, buildContext.getDataSource(string));
            String string4 = joinGO.getUserProperty("Join_PrimaryPrefix");
            if (StringUtil.notEmpty(string4)) {
                derivedDataSource.setPrefix(Prefix.getInstance(string4));
            }
            derivedDataSource.setDiscardSet(GOUtil.getDiscardSet(joinGO, "Join_PrimaryDiscard"));
            IDataSource iDataSource = buildContext.getDataSource(string2);
            if (joinGO.isCrossedJoin()) {
                this.buildCrossedJoin(joinGO, derivedDataSource, iDataSource);
            } else {
                this.buildJoin(joinGO, derivedDataSource, iDataSource);
            }
            buildContext.addDataSource(joinGO, string3, derivedDataSource);
        }
    }

    private void buildCrossedJoin(JoinGO joinGO, DerivedDataSource derivedDataSource, IDataSource iDataSource) {
        CrossJoinDerivative crossJoinDerivative = new CrossJoinDerivative(iDataSource);
        String string = joinGO.getUserProperty("Join_SecondaryPrefix");
        if (StringUtil.notEmpty(string)) {
            crossJoinDerivative.setPrefix(string.trim());
        }
        crossJoinDerivative.setDiscardSet(GOUtil.getDiscardSet(joinGO, "Join_SecondaryDiscard"));
        derivedDataSource.addDerivative(crossJoinDerivative);
    }

    private void buildJoin(JoinGO joinGO, DerivedDataSource derivedDataSource, IDataSource iDataSource) {
        int n = joinGO.getJoinCount();
        if (n > 0) {
            JoinDerivative joinDerivative = new JoinDerivative(iDataSource);
            String string = joinGO.getUserProperty("Join_SecondaryPrefix");
            if (string != null) {
                joinDerivative.setPrefix(Prefix.getInstance(string));
            }
            joinDerivative.setDiscardSet(GOUtil.getDiscardSet(joinGO, "Join_SecondaryDiscard"));
            joinDerivative.setZeroAction(joinGO.getUserProperty("Join_ZeroSecondary"));
            joinDerivative.setMultipleAction(joinGO.getUserProperty("Join_MultipleSecondary"));
            for (int i = 0; i < n; ++i) {
                JoinNode joinNode = joinGO.getJoin(i);
                joinDerivative.addJoin(joinNode.getPrimary(), joinNode.getSecondary());
            }
            derivedDataSource.addDerivative(joinDerivative);
        }
    }
}

