/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.glint;

import com.elixirtech.glint.EyeConstants;
import com.elixirtech.glint.GlintInput;
import com.elixirtech.glint.GlintOutput;
import com.elixirtech.glint.IEye;
import com.elixirtech.glint.IGlint;
import com.elixirtech.glint.PrintAttributes;
import com.elixirtech.glint.ResourceManager;
import com.elixirtech.glint.TOC;
import com.elixirtech.glint.midp.MIDPResourceManager;
import java.awt.Dimension;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class Eye
implements IEye,
EyeConstants {
    protected final String m_Name;
    protected final boolean m_ShareImages;
    protected Dimension m_Size;
    protected ByteArrayOutputStream m_Resources;
    protected ResourceManager m_ResourceManager;
    protected List<EyeGlint> m_Glints;
    protected TOC m_Tick;
    protected PrintAttributes m_PrintAttributes;

    public Eye(String string, boolean bl) {
        this.m_Name = string;
        this.m_ShareImages = bl;
        this.m_Size = new Dimension(0, 0);
        this.m_Resources = new ByteArrayOutputStream();
        this.m_ResourceManager = new ResourceManager(this.m_Resources);
        this.m_Glints = new ArrayList<EyeGlint>();
    }

    public ResourceManager getResourceManager() {
        return this.m_ResourceManager;
    }

    @Override
    public String getName() {
        return this.m_Name;
    }

    public IGlint newPage() throws IOException {
        EyeGlint eyeGlint = new EyeGlint();
        this.m_Glints.add(eyeGlint);
        return eyeGlint;
    }

    public void setSize(Dimension dimension) {
        this.m_Size = dimension;
    }

    public void setResources(byte[] byArray) throws IOException {
        this.m_Resources.write(byArray);
    }

    public void addGlint(byte[] byArray) throws IOException {
        this.m_Glints.add(new EyeGlint(byArray));
    }

    public void setTick(TOC tOC) {
        this.m_Tick = tOC;
    }

    @Override
    public TOC getTick() {
        return this.m_Tick;
    }

    public void setPrintAttributes(PrintAttributes printAttributes) {
        this.m_PrintAttributes = printAttributes;
    }

    @Override
    public PrintAttributes getPrintAttributes() {
        return this.m_PrintAttributes;
    }

    public void close() throws IOException {
    }

    @Override
    public int getWidth() {
        return this.m_Size.width;
    }

    @Override
    public int getHeight() {
        return this.m_Size.height;
    }

    @Override
    public byte[] getResources(int n) {
        if (n != 0) {
            throw new IllegalArgumentException("Only a single resource [0] supported");
        }
        return this.m_Resources.toByteArray();
    }

    @Override
    public int getResourceCount() {
        return 1;
    }

    public void getResources(int n, IGlint iGlint) {
        GlintInput.read(new ByteArrayInputStream(this.getResources(n)), false, iGlint);
    }

    @Override
    public void getResources(IGlint iGlint) {
        GlintInput.read(new ByteArrayInputStream(this.getResources(0)), false, iGlint);
    }

    @Override
    public int getPageCount() {
        return this.m_Glints.size();
    }

    @Override
    public byte[] getPage(int n) {
        EyeGlint eyeGlint = this.m_Glints.get(n - 1);
        return eyeGlint.toByteArray();
    }

    @Override
    public void getPage(int n, IGlint iGlint) {
        GlintInput.read(new ByteArrayInputStream(this.getPage(n)), true, iGlint);
    }

    @Override
    public IEye.PageSetup getPageSetup(int n) {
        EyeGlint eyeGlint = this.m_Glints.get(n - 1);
        return new IEye.PageSetup(eyeGlint.getWidth(), eyeGlint.getHeight(), eyeGlint.getOrientation());
    }

    public int getByteCount() {
        int n = this.m_Resources.size();
        for (EyeGlint eyeGlint : this.m_Glints) {
            n += eyeGlint.getByteCount();
        }
        return n;
    }

    protected class EyeGlint
    extends GlintOutput {
        private final ByteArrayOutputStream m_BAOS = new ByteArrayOutputStream();

        public EyeGlint() {
            this.m_Out = new DataOutputStream(this.m_BAOS);
            this.initResourceManager();
        }

        public EyeGlint(byte[] byArray) throws IOException {
            this.m_BAOS.write(byArray);
            this.m_Out = new DataOutputStream(this.m_BAOS);
            this.initResourceManager();
        }

        @Override
        public void init(int n, int n2, int n3) {
            Eye.this.m_Size.width = Math.max(Eye.this.m_Size.width, n);
            Eye.this.m_Size.height = Math.max(Eye.this.m_Size.height, n2);
            super.init(n, n2, n3);
        }

        @Override
        public void initResourceManager() {
            if (Eye.this.m_ShareImages) {
                this.m_ResourceManager = Eye.this.m_ResourceManager;
            } else {
                ResourceManager resourceManager = new ResourceManager(this.m_Out);
                this.m_ResourceManager = new MIDPResourceManager(Eye.this.m_ResourceManager, resourceManager);
            }
        }

        @Override
        public int getWidth() {
            return this.m_Width;
        }

        @Override
        public int getHeight() {
            return this.m_Height;
        }

        @Override
        public int getOrientation() {
            return this.m_Orientation;
        }

        public int size() {
            return this.m_BAOS.size();
        }

        public byte[] toByteArray() {
            return this.m_BAOS.toByteArray();
        }

        public int getByteCount() {
            return this.m_BAOS.size();
        }
    }
}

