/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.glint;

import com.elixirtech.glint.Eye;
import com.elixirtech.glint.IGlint;
import com.elixirtech.glint.PrintAttributes;
import com.elixirtech.glint.TickBuilder;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;

public class EyeWriter
extends Eye {
    public static final int HEADER_SIZE = 8;
    protected DataOutputStream m_Out;

    public EyeWriter(String string, OutputStream outputStream, boolean bl) throws IOException {
        super(string, bl);
        if (outputStream == null) {
            throw new IllegalArgumentException("Null output stream");
        }
        this.m_Out = new DataOutputStream(outputStream);
        this.writeHeader();
    }

    @Override
    public void setPrintAttributes(PrintAttributes printAttributes) {
        super.setPrintAttributes(printAttributes);
        try {
            this.m_Out.write(5);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintAttributes.write(printAttributes, byteArrayOutputStream);
            this.m_Out.writeInt(byteArrayOutputStream.size());
            this.m_Out.write(byteArrayOutputStream.toByteArray());
        }
        catch (IOException iOException) {
            throw new RuntimeException("Unable to write print attributes", iOException);
        }
    }

    @Override
    public IGlint newPage() throws IOException {
        this.writeGlints();
        return super.newPage();
    }

    @Override
    public void close() throws IOException {
        this.writeGlints();
        this.writeTick();
        this.writeResources();
        this.m_Out.write(0);
    }

    private void writeHeader() throws IOException {
        this.m_Out.write(MARKER.bytes());
        this.m_Out.write(VERSION.bytes());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream.writeInt(this.m_Size.width);
        dataOutputStream.writeInt(this.m_Size.height);
        dataOutputStream.writeUTF(this.m_Name);
        dataOutputStream.flush();
        this.m_Out.write(4);
        this.m_Out.writeInt(byteArrayOutputStream.size());
        this.m_Out.write(byteArrayOutputStream.toByteArray());
    }

    private void writeGlints() throws IOException {
        Iterator iterator = this.m_Glints.iterator();
        while (iterator.hasNext()) {
            this.writeGlint((Eye.EyeGlint)iterator.next());
        }
        this.m_Glints.clear();
    }

    private void writeTick() throws IOException {
        if (this.m_Tick != null) {
            this.m_Out.write(3);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            TickBuilder.write(this.m_Tick, byteArrayOutputStream);
            this.m_Out.writeInt(byteArrayOutputStream.size());
            this.m_Out.write(byteArrayOutputStream.toByteArray());
        }
    }

    private void writeResources() throws IOException {
        this.m_Out.write(2);
        this.m_Out.writeInt(this.m_Resources.size());
        this.m_Out.write(this.m_Resources.toByteArray());
    }

    private void writeGlint(Eye.EyeGlint eyeGlint) throws IOException {
        this.m_Out.write(1);
        this.m_Out.writeInt(eyeGlint.size());
        this.m_Out.write(eyeGlint.toByteArray());
    }
}

