/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.glint;

import com.elixirtech.glint.Color;
import com.elixirtech.glint.Font;
import com.elixirtech.glint.GlintException;
import com.elixirtech.glint.GraphicsCodes;
import com.elixirtech.glint.IEye;
import com.elixirtech.glint.IGlint;
import com.elixirtech.glint.Image;
import com.elixirtech.glint.Pen;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

public class GlintInput
implements GraphicsCodes {
    public static void read(InputStream inputStream, boolean bl, IGlint iGlint) throws GlintException {
        GlintInput.read(inputStream, bl, iGlint, 0, 0);
    }

    public static IEye.PageSetup getPageSetup(byte[] byArray) throws GlintException {
        try {
            DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
            int n = MARKER.length() + VERSION.length();
            int n2 = dataInputStream.skipBytes(n);
            if (n2 != n) {
                throw new GlintException("Unable to skip header");
            }
            int n3 = dataInputStream.readInt();
            int n4 = dataInputStream.readInt();
            int n5 = dataInputStream.read();
            dataInputStream.close();
            return new IEye.PageSetup(n3, n4, n5);
        }
        catch (IOException iOException) {
            throw new GlintException("Unable to read page setup", iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void read(InputStream inputStream, boolean bl, IGlint iGlint, int n, int n2) throws GlintException {
        boolean bl2 = false;
        int n3 = 0;
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        try {
            int n4;
            if (bl) {
                int n5;
                n4 = MARKER.length();
                for (n5 = 0; n5 < n4; ++n5) {
                    if (dataInputStream.read() == MARKER.get(n5)) continue;
                    throw new GlintException("Error at marker " + n5);
                }
                n5 = VERSION.length();
                byte[] byArray = new byte[n5];
                dataInputStream.readFully(byArray);
                if (byArray[2] > VERSION.get(2)) {
                    throw new GlintException("Unsupported version [" + byArray[0] + byArray[1] + "." + byArray[2] + byArray[3]);
                }
                if (byArray[2] == 1) {
                    bl2 = true;
                }
                iGlint.init(dataInputStream.readInt(), dataInputStream.readInt(), dataInputStream.read());
            }
            if (n != 0 || n2 != 0) {
                iGlint.offsetOrigin(n, n2);
            }
            try {
                while ((n4 = dataInputStream.read()) > 0) {
                    switch (n4) {
                        case 1: {
                            IGlint.PenId penId = new IGlint.PenId(dataInputStream.readShort());
                            int n6 = dataInputStream.readInt();
                            int n7 = dataInputStream.readInt();
                            int n8 = dataInputStream.readInt();
                            iGlint.drawLine(penId, n6, n7, n8, n7);
                            break;
                        }
                        case 2: {
                            IGlint.PenId penId = new IGlint.PenId(dataInputStream.readShort());
                            int n9 = dataInputStream.readInt();
                            int n10 = dataInputStream.readInt();
                            int n11 = dataInputStream.readInt();
                            iGlint.drawLine(penId, n9, n10, n9, n11);
                            break;
                        }
                        case 3: {
                            IGlint.PenId penId = new IGlint.PenId(dataInputStream.readShort());
                            int n12 = dataInputStream.readInt();
                            int n13 = dataInputStream.readInt();
                            int n14 = dataInputStream.readInt();
                            int n15 = dataInputStream.readInt();
                            iGlint.drawLine(penId, n12, n13, n14, n15);
                            break;
                        }
                        case 4: {
                            IGlint.PenId penId = new IGlint.PenId(dataInputStream.readShort());
                            int n16 = dataInputStream.readInt();
                            int[] nArray = new int[n16];
                            int[] nArray2 = new int[n16];
                            for (int i = 0; i < n16; ++i) {
                                nArray[i] = dataInputStream.readInt();
                                nArray2[i] = dataInputStream.readInt();
                            }
                            iGlint.drawPolyline(penId, nArray, nArray2);
                            break;
                        }
                        case 16: {
                            IGlint.PenId penId = new IGlint.PenId(dataInputStream.readShort());
                            IGlint.ColorId colorId = new IGlint.ColorId(dataInputStream.readShort());
                            int n17 = dataInputStream.readInt();
                            int n18 = dataInputStream.readInt();
                            int n19 = dataInputStream.readInt();
                            int n20 = dataInputStream.readInt();
                            iGlint.drawRect(penId, colorId, n17, n18, n19, n20);
                            break;
                        }
                        case 17: {
                            IGlint.PenId penId = new IGlint.PenId(dataInputStream.readShort());
                            IGlint.ColorId colorId = new IGlint.ColorId(dataInputStream.readShort());
                            int n21 = dataInputStream.readInt();
                            int n22 = dataInputStream.readInt();
                            int n23 = dataInputStream.readInt();
                            int n24 = dataInputStream.readInt();
                            int n25 = dataInputStream.read();
                            iGlint.drawCellRect(penId, colorId, n21, n22, n23, n24, n25);
                            break;
                        }
                        case 18: {
                            IGlint.PenId penId = new IGlint.PenId(dataInputStream.readShort());
                            IGlint.ColorId colorId = new IGlint.ColorId(dataInputStream.readShort());
                            int n26 = dataInputStream.readInt();
                            int n27 = dataInputStream.readInt();
                            int n28 = dataInputStream.readInt();
                            int n29 = dataInputStream.readInt();
                            int n30 = dataInputStream.readInt();
                            int n31 = dataInputStream.readInt();
                            iGlint.drawRoundRect(penId, colorId, n26, n27, n28, n29, n30, n31);
                            break;
                        }
                        case 21: {
                            IGlint.PenId penId = new IGlint.PenId(dataInputStream.readShort());
                            IGlint.ColorId colorId = new IGlint.ColorId(dataInputStream.readShort());
                            int n32 = dataInputStream.readInt();
                            int n33 = dataInputStream.readInt();
                            int n34 = dataInputStream.readInt();
                            int n35 = dataInputStream.readInt();
                            int n36 = dataInputStream.readInt();
                            int n31 = dataInputStream.readInt();
                            int n37 = dataInputStream.read();
                            iGlint.drawRoundCellRect(penId, colorId, n32, n33, n34, n35, n36, n31, n37);
                            break;
                        }
                        case 19: {
                            IGlint.PenId penId = new IGlint.PenId(dataInputStream.readShort());
                            IGlint.ColorId colorId = new IGlint.ColorId(dataInputStream.readShort());
                            int n38 = dataInputStream.readInt();
                            int n39 = dataInputStream.readInt();
                            int n40 = dataInputStream.readInt();
                            int n41 = dataInputStream.readInt();
                            iGlint.drawEllipse(penId, colorId, n38, n39, n40, n41);
                            break;
                        }
                        case 20: {
                            IGlint.PenId penId = new IGlint.PenId(dataInputStream.readShort());
                            IGlint.ColorId colorId = new IGlint.ColorId(dataInputStream.readShort());
                            int n42 = dataInputStream.readInt();
                            int[] nArray = new int[n42];
                            int[] nArray3 = new int[n42];
                            for (int i = 0; i < n42; ++i) {
                                nArray[i] = dataInputStream.readInt();
                                nArray3[i] = dataInputStream.readInt();
                            }
                            iGlint.drawPolygon(penId, colorId, nArray, nArray3);
                            break;
                        }
                        case 80: {
                            IGlint.ImageId imageId = new IGlint.ImageId(dataInputStream.readShort());
                            int n43 = dataInputStream.readInt();
                            int n44 = dataInputStream.readInt();
                            iGlint.drawImage(imageId, n43, n44);
                            break;
                        }
                        case 81: {
                            IGlint.ImageId imageId = new IGlint.ImageId(dataInputStream.readShort());
                            int n45 = dataInputStream.readInt();
                            int n46 = dataInputStream.readInt();
                            int n47 = dataInputStream.readInt();
                            int n48 = dataInputStream.readInt();
                            iGlint.drawScaledImage(imageId, n45, n46, n47, n48);
                            break;
                        }
                        case 82: {
                            IGlint.ImageId imageId = new IGlint.ImageId(dataInputStream.readShort());
                            int n49 = dataInputStream.readInt();
                            int n50 = dataInputStream.readInt();
                            int n51 = dataInputStream.readInt();
                            int n52 = dataInputStream.readInt();
                            int n53 = dataInputStream.readInt();
                            int n54 = dataInputStream.readInt();
                            iGlint.drawSubImage(imageId, n49, n50, n51, n52, n53, n54);
                            break;
                        }
                        case 83: {
                            IGlint.ImageId imageId = new IGlint.ImageId(dataInputStream.readShort());
                            int n55 = dataInputStream.readInt();
                            int n56 = dataInputStream.readInt();
                            int n57 = dataInputStream.readInt();
                            int n58 = dataInputStream.readInt();
                            int n59 = dataInputStream.readInt();
                            int n60 = dataInputStream.readInt();
                            int n31 = dataInputStream.readInt();
                            int n37 = dataInputStream.readInt();
                            iGlint.drawScaledSubImage(imageId, n55, n56, n57, n58, n59, n60, n31, n37);
                            break;
                        }
                        case 96: {
                            int n61 = dataInputStream.readInt();
                            int n62 = dataInputStream.readInt();
                            iGlint.offsetOrigin(n61, n62);
                            break;
                        }
                        case 97: {
                            int n63 = dataInputStream.readInt();
                            int n64 = dataInputStream.readInt();
                            iGlint.setOrigin(n63, n64);
                            break;
                        }
                        case 98: {
                            String string = dataInputStream.readUTF();
                            iGlint.setURL(string, null);
                            break;
                        }
                        case 99: {
                            String string = dataInputStream.readUTF();
                            String string2 = dataInputStream.readUTF();
                            iGlint.setURL(string, string2);
                            break;
                        }
                        case 100: {
                            iGlint.resetURL();
                            break;
                        }
                        case 101: {
                            int n65 = dataInputStream.readInt();
                            int n66 = dataInputStream.readInt();
                            int n67 = dataInputStream.readInt();
                            int n68 = dataInputStream.readInt();
                            iGlint.pushClip(n65, n66, n67, n68);
                            break;
                        }
                        case 103: {
                            int n69 = dataInputStream.readInt();
                            int n70 = dataInputStream.readInt();
                            int n71 = dataInputStream.readInt();
                            int n72 = dataInputStream.readInt();
                            int n73 = dataInputStream.readInt();
                            int n74 = dataInputStream.readInt();
                            int n75 = dataInputStream.read();
                            iGlint.pushClip(n69, n70, n71, n72, n73, n74, n75);
                            break;
                        }
                        case 102: {
                            iGlint.popClip();
                            break;
                        }
                        case 112: {
                            IGlint.FontId fontId = new IGlint.FontId(dataInputStream.readShort());
                            IGlint.ColorId colorId = new IGlint.ColorId(dataInputStream.readShort());
                            int n76 = dataInputStream.readInt();
                            int n77 = dataInputStream.readInt();
                            String string = dataInputStream.readUTF();
                            iGlint.drawText(fontId, colorId, n76, n77, 1, string);
                            break;
                        }
                        case 113: {
                            IGlint.FontId fontId = new IGlint.FontId(dataInputStream.readShort());
                            IGlint.ColorId colorId = new IGlint.ColorId(dataInputStream.readShort());
                            int n78 = dataInputStream.readInt();
                            int n79 = dataInputStream.readInt();
                            String string = dataInputStream.readUTF();
                            iGlint.drawText(fontId, colorId, n78, n79, 2, string);
                            break;
                        }
                        case 114: {
                            IGlint.FontId fontId = new IGlint.FontId(dataInputStream.readShort());
                            IGlint.ColorId colorId = new IGlint.ColorId(dataInputStream.readShort());
                            int n80 = dataInputStream.readInt();
                            int n81 = dataInputStream.readInt();
                            String string = dataInputStream.readUTF();
                            iGlint.drawText(fontId, colorId, n80, n81, 3, string);
                            break;
                        }
                        case 118: {
                            IGlint.FontId fontId = new IGlint.FontId(dataInputStream.readShort());
                            IGlint.ColorId colorId = new IGlint.ColorId(dataInputStream.readShort());
                            int n82 = dataInputStream.readInt();
                            int n83 = dataInputStream.readInt();
                            int n84 = dataInputStream.readInt();
                            String string = dataInputStream.readUTF();
                            iGlint.drawJustifiedText(fontId, colorId, n82, n83, n84, string);
                            break;
                        }
                        case 115: {
                            IGlint.FontId fontId = new IGlint.FontId(dataInputStream.readShort());
                            IGlint.ColorId colorId = new IGlint.ColorId(dataInputStream.readShort());
                            int n85 = dataInputStream.readInt();
                            int n86 = dataInputStream.readInt();
                            int n87 = dataInputStream.readInt();
                            String string = dataInputStream.readUTF();
                            iGlint.drawRotatedText(fontId, colorId, n85, n86, 1, n87, string);
                            break;
                        }
                        case 116: {
                            IGlint.FontId fontId = new IGlint.FontId(dataInputStream.readShort());
                            IGlint.ColorId colorId = new IGlint.ColorId(dataInputStream.readShort());
                            int n88 = dataInputStream.readInt();
                            int n89 = dataInputStream.readInt();
                            int n90 = dataInputStream.readInt();
                            String string = dataInputStream.readUTF();
                            iGlint.drawRotatedText(fontId, colorId, n88, n89, 2, n90, string);
                            break;
                        }
                        case 117: {
                            IGlint.FontId fontId = new IGlint.FontId(dataInputStream.readShort());
                            IGlint.ColorId colorId = new IGlint.ColorId(dataInputStream.readShort());
                            int n91 = dataInputStream.readInt();
                            int n92 = dataInputStream.readInt();
                            int n93 = dataInputStream.readInt();
                            String string = dataInputStream.readUTF();
                            iGlint.drawRotatedText(fontId, colorId, n91, n92, 3, n93, string);
                            break;
                        }
                        case 119: {
                            IGlint.FontId fontId = new IGlint.FontId(dataInputStream.readShort());
                            IGlint.ColorId colorId = new IGlint.ColorId(dataInputStream.readShort());
                            int n94 = dataInputStream.readInt();
                            int n95 = dataInputStream.readInt();
                            int n96 = dataInputStream.readInt();
                            int n97 = dataInputStream.readInt();
                            String string = dataInputStream.readUTF();
                            iGlint.drawRotatedJustifiedText(fontId, colorId, n94, n95, n96, n97, string);
                            break;
                        }
                        case 120: {
                            int n98 = dataInputStream.readInt();
                            int n99 = dataInputStream.readInt();
                            int n100 = dataInputStream.readInt();
                            int n101 = dataInputStream.readInt();
                            String string = dataInputStream.readUTF();
                            iGlint.drawRTF(n98, n99, n100, n101, string);
                            break;
                        }
                        case 128: {
                            String string = dataInputStream.readUTF();
                            int n102 = dataInputStream.readInt();
                            int n103 = dataInputStream.readInt();
                            if (bl2) {
                                n103 *= 20;
                            }
                            Font font = Font.newInstance(string, n102, n103);
                            iGlint.defineFont(font);
                            break;
                        }
                        case 129: {
                            String string = dataInputStream.readUTF();
                            int n104 = dataInputStream.readInt();
                            int n105 = dataInputStream.readInt();
                            if (bl2) {
                                n105 *= 20;
                            }
                            int n106 = dataInputStream.readInt();
                            byte[] byArray = new byte[n106];
                            dataInputStream.readFully(byArray);
                            Font font = Font.newInstance(string, byArray, n104, n105);
                            iGlint.defineFont(font);
                            break;
                        }
                        case 130: {
                            short s = dataInputStream.readShort();
                            Font font = iGlint.getFont(new IGlint.FontId(s));
                            int n107 = dataInputStream.readInt();
                            int n108 = dataInputStream.readInt();
                            if (bl2) {
                                n108 *= 20;
                            }
                            Font font2 = Font.newInstance(font, n107, n108);
                            iGlint.defineFont(font2);
                            break;
                        }
                        case 132: {
                            iGlint.defineColor(Color.newInstance(dataInputStream.readInt()));
                            break;
                        }
                        case 133: {
                            int n109 = dataInputStream.readInt();
                            int n110 = dataInputStream.readInt();
                            int n111 = dataInputStream.readInt();
                            int[] nArray = new int[n111];
                            for (int i = 0; i < n111; ++i) {
                                nArray[i] = dataInputStream.readInt();
                            }
                            BufferedImage bufferedImage = new BufferedImage(n109, n110, 2);
                            bufferedImage.setRGB(0, 0, n109, n110, nArray, 0, n109);
                            Image image = Image.getInstance(bufferedImage, "image" + n3);
                            iGlint.defineImage(image);
                            ++n3;
                            break;
                        }
                        case 134: {
                            int n112 = dataInputStream.readInt();
                            byte[] byArray = new byte[n112];
                            dataInputStream.readFully(byArray);
                            Image image = Image.getInstance(byArray, "image" + n3);
                            iGlint.defineImage(image);
                            ++n3;
                            break;
                        }
                        case 135: {
                            short s = dataInputStream.readShort();
                            short s2 = dataInputStream.readShort();
                            int n113 = dataInputStream.read();
                            iGlint.definePen(new Pen(iGlint.getColor(new IGlint.ColorId(s)), s2, n113));
                            break;
                        }
                        case 136: {
                            iGlint.defineString();
                            break;
                        }
                        case 137: {
                            short s = dataInputStream.readShort();
                            String string = dataInputStream.readUTF();
                            iGlint.setString(new IGlint.StringId(s), string);
                            break;
                        }
                    }
                }
            }
            finally {
                iGlint.offsetOrigin(-n, -n2);
                if (bl) {
                    iGlint.flush();
                }
            }
        }
        catch (IOException iOException) {
            throw new GlintException("IOException: " + iOException);
        }
    }
}

