/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.glint;

import com.elixirtech.arch.ElxLoggerJ;
import java.awt.image.PixelGrabber;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import javax.imageio.ImageIO;

public abstract class Image {
    public static final int TYPE_ARGB = 1;
    public static final int TYPE_BYTES = 2;
    public static final int TYPE_JPEG = 3;
    public static final int TYPE_GIF = 4;
    public static final int TYPE_PNG = 5;
    private static final byte[] SIG_JPEG = new byte[]{-1, -39, -1, -40};
    private static final byte[] SIG_GIF = new byte[]{71, 73, 70};
    private static final byte[] SIG_PNG = new byte[]{37, 80, 78, 71, 13, 10, 26, 10};
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(Image.class);

    public static Image getInstance(URL uRL) throws MalformedURLException, IOException {
        int n;
        byte[] byArray = new byte[4096];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        InputStream inputStream = uRL.openStream();
        while ((n = inputStream.read(byArray)) >= 0) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        return new ByteImage(byteArrayOutputStream.toByteArray(), uRL.toString());
    }

    public static Image getInstance(byte[] byArray, String string) {
        return new ByteImage(byArray, string);
    }

    public static Image getInstance(byte[] byArray, String string, java.awt.Image image) {
        return new ByteImage(byArray, string, image);
    }

    public static Image getInstance(java.awt.Image image, String string) {
        if (image instanceof java.awt.image.BufferedImage) {
            return new BufferedImage((java.awt.image.BufferedImage)image, string);
        }
        return new AWTImage(image, string);
    }

    public abstract int getWidth();

    public abstract int getHeight();

    public abstract String getId();

    public abstract int getDataType();

    public abstract Object getData();

    public abstract java.awt.Image asAWTImage();

    private static class ByteImage
    extends Image {
        private final byte[] m_Bytes;
        private final String m_Id;
        private java.awt.Image m_Image;
        private int m_Width;
        private int m_Height;

        public ByteImage(byte[] byArray, String string) {
            this.m_Bytes = byArray;
            this.m_Id = string;
        }

        public ByteImage(byte[] byArray, String string, java.awt.Image image) {
            this.m_Bytes = byArray;
            this.m_Id = string;
            this.m_Image = image;
            this.m_Width = this.m_Image.getWidth(null);
            this.m_Height = this.m_Image.getHeight(null);
        }

        private void load() {
            try {
                this.m_Image = ImageIO.read(new ByteArrayInputStream(this.m_Bytes));
                if (this.m_Image == null) {
                    throw new IOException("Java ImageIO can't determine or process this image format");
                }
                this.m_Width = this.m_Image.getWidth(null);
                this.m_Height = this.m_Image.getHeight(null);
            }
            catch (IOException iOException) {
                m_Log.error((Object)("Error loading image: " + iOException), (Throwable)iOException);
            }
        }

        @Override
        public int getWidth() {
            if (this.m_Image == null) {
                this.load();
            }
            return this.m_Width;
        }

        @Override
        public int getHeight() {
            if (this.m_Image == null) {
                this.load();
            }
            return this.m_Height;
        }

        @Override
        public String getId() {
            return this.m_Id;
        }

        @Override
        public int getDataType() {
            if (this.startsWith(this.m_Bytes, SIG_JPEG)) {
                return 3;
            }
            if (this.startsWith(this.m_Bytes, SIG_GIF)) {
                return 4;
            }
            if (this.startsWith(this.m_Bytes, SIG_PNG)) {
                return 5;
            }
            return 2;
        }

        private boolean startsWith(byte[] byArray, byte[] byArray2) {
            for (int i = 0; i < byArray2.length; ++i) {
                if (byArray[i] == byArray2[i]) continue;
                return false;
            }
            return true;
        }

        @Override
        public Object getData() {
            return this.m_Bytes;
        }

        @Override
        public java.awt.Image asAWTImage() {
            if (this.m_Image == null) {
                this.load();
            }
            return this.m_Image;
        }
    }

    private static class BufferedImage
    extends Image {
        private final java.awt.image.BufferedImage m_Image;
        private final String m_Id;
        private final int m_Width;
        private final int m_Height;

        public BufferedImage(java.awt.image.BufferedImage bufferedImage, String string) {
            this.m_Image = bufferedImage;
            this.m_Id = string;
            this.m_Width = this.m_Image.getWidth();
            this.m_Height = this.m_Image.getHeight();
        }

        @Override
        public int getWidth() {
            return this.m_Width;
        }

        @Override
        public int getHeight() {
            return this.m_Height;
        }

        @Override
        public String getId() {
            return this.m_Id;
        }

        @Override
        public int getDataType() {
            return 1;
        }

        @Override
        public Object getData() {
            int n = this.m_Image.getWidth();
            int n2 = this.m_Image.getHeight();
            return this.m_Image.getRGB(0, 0, n, n2, null, 0, n);
        }

        @Override
        public java.awt.Image asAWTImage() {
            return this.m_Image;
        }
    }

    private static class AWTImage
    extends Image {
        private final java.awt.Image m_Image;
        private final String m_Id;
        private final int m_Width;
        private final int m_Height;

        public AWTImage(java.awt.Image image, String string) {
            if (image == null) {
                throw new IllegalArgumentException("Image is null");
            }
            this.m_Image = image;
            this.m_Id = string;
            this.m_Width = this.m_Image.getWidth(null);
            this.m_Height = this.m_Image.getHeight(null);
        }

        @Override
        public int getWidth() {
            return this.m_Width;
        }

        @Override
        public int getHeight() {
            return this.m_Height;
        }

        @Override
        public String getId() {
            return this.m_Id;
        }

        @Override
        public int getDataType() {
            return 1;
        }

        @Override
        public Object getData() {
            int[] nArray = new int[this.m_Width * this.m_Height];
            PixelGrabber pixelGrabber = new PixelGrabber(this.m_Image, 0, 0, this.m_Width, this.m_Height, nArray, 0, this.m_Width);
            try {
                if (pixelGrabber.grabPixels()) {
                    return nArray;
                }
            }
            catch (InterruptedException interruptedException) {
                m_Log.warn((Object)"PixelGrabber interrupted");
                Thread.currentThread().interrupt();
            }
            return null;
        }

        @Override
        public java.awt.Image asAWTImage() {
            return this.m_Image;
        }
    }
}

