/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.glint.g;

import com.elixirtech.glint.Color;
import com.elixirtech.glint.Drawing;
import com.elixirtech.glint.Font;
import com.elixirtech.glint.GraphicsCodes;
import com.elixirtech.glint.IGlint;
import com.elixirtech.glint.Image;
import com.elixirtech.glint.Pen;
import com.elixirtech.glint.g.GlintContext;
import com.elixirtech.glint.g.URLMap;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;

public class GlintGraphics
implements IGlint,
GraphicsCodes {
    private final Graphics g;
    private final GlintContext cxt;
    private int m_Width;
    private int m_Height;
    private int m_Orientation;
    private int m_OffsetX;
    private int m_OffsetY;

    public GlintGraphics(Graphics graphics) {
        this.g = graphics;
        this.cxt = new GlintContext(graphics);
    }

    @Override
    public void init(int n, int n2, int n3) {
        this.m_Width = n;
        this.m_Height = n2;
        this.m_Orientation = n3;
    }

    @Override
    public int getWidth() {
        return this.m_Width;
    }

    @Override
    public int getHeight() {
        return this.m_Height;
    }

    @Override
    public int getOrientation() {
        return this.m_Orientation;
    }

    public URLMap getURLMap() {
        return this.cxt.getURLMap();
    }

    @Override
    public IGlint.FontId defineFont(Font font) {
        return this.cxt.addFont(font);
    }

    @Override
    public IGlint.ColorId defineColor(Color color) {
        return this.cxt.addColor(color);
    }

    @Override
    public IGlint.ImageId defineImage(Image image) {
        return this.cxt.addImage(image);
    }

    @Override
    public IGlint.PenId definePen(Pen pen) {
        return this.cxt.addPen(pen);
    }

    @Override
    public IGlint.StringId defineString() {
        return this.cxt.addString();
    }

    @Override
    public void setString(IGlint.StringId stringId, String string) {
        this.cxt.setString(stringId, string);
    }

    @Override
    public Font getFont(IGlint.FontId fontId) {
        return this.cxt.getFont(fontId);
    }

    @Override
    public Color getColor(IGlint.ColorId colorId) {
        return this.cxt.getColor(colorId);
    }

    @Override
    public Image getImage(IGlint.ImageId imageId) {
        return this.cxt.getImage(imageId);
    }

    @Override
    public Pen getPen(IGlint.PenId penId) {
        return this.cxt.getPen(penId);
    }

    @Override
    public String getString(IGlint.StringId stringId) {
        return this.cxt.getString(stringId);
    }

    @Override
    public void drawLine(IGlint.PenId penId, int n, int n2, int n3, int n4) {
        Drawing.drawLine(this.g, this.cxt.getPen(penId), n / 20, n2 / 20, n3 / 20, n4 / 20);
    }

    @Override
    public void drawPolyline(IGlint.PenId penId, int[] nArray, int[] nArray2) {
        int[] nArray3 = new int[nArray.length];
        int[] nArray4 = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray3[i] = nArray[i] / 20;
            nArray4[i] = nArray2[i] / 20;
        }
        Drawing.drawPolyline(this.g, this.cxt.getPen(penId), nArray3, nArray4);
    }

    @Override
    public void drawRect(IGlint.PenId penId, IGlint.ColorId colorId, int n, int n2, int n3, int n4) {
        Object object;
        int n5 = n / 20;
        int n6 = n2 / 20;
        int n7 = n3 / 20;
        int n8 = n4 / 20;
        if (colorId.id != 0) {
            this.cxt.setColor(colorId.id);
            this.g.fillRect(n5, n6, n7, n8);
        }
        if (penId.id != 0) {
            object = this.cxt.getPen(penId);
            this.cxt.setColor(((Pen)object).getColor().getAWTColor());
            int n9 = ((Pen)object).getWidth() / 20;
            int n10 = n9 / 2;
            int n11 = n5 + n7 - 1;
            int n12 = n6 + n8 - 1;
            for (int i = 0; i < n9; ++i) {
                this.g.drawLine(n5 - n10 + i, n6 - n10, n5 - n10 + i, n12 + n10);
                this.g.drawLine(n5, n6 - n10 + i, n11, n6 - n10 + i);
                this.g.drawLine(n11 - n10 + i, n6 - n10, n11 - n10 + i, n12 + n10);
                this.g.drawLine(n5, n12 - n10 + i, n11, n12 - n10 + i);
            }
        }
        object = new Rectangle2D.Float(n5, n6, n7, n8);
        this.addURLShape(this.cxt, (Shape)object);
    }

    @Override
    public void drawCellRect(IGlint.PenId penId, IGlint.ColorId colorId, int n, int n2, int n3, int n4, int n5) {
        Object object;
        int n6 = n / 20;
        int n7 = n2 / 20;
        int n8 = n3 / 20;
        int n9 = n4 / 20;
        int n10 = n6 + n8 - 1;
        int n11 = n7 + n9 - 1;
        if (colorId.id != 0) {
            this.cxt.setColor(colorId.id);
            this.g.fillRect(n6, n7, n8, n9);
        }
        if (penId.id != 0) {
            int n12;
            object = this.cxt.getPen(penId);
            this.cxt.setColor(((Pen)object).getColor().getAWTColor());
            int n13 = ((Pen)object).getWidth() / 20;
            int n14 = n13 / 2;
            if ((n5 & 1) != 0) {
                for (n12 = 0; n12 < n13; ++n12) {
                    this.g.drawLine(n6 - n14 + n12, n7, n6 - n14 + n12, n11);
                }
            }
            if ((n5 & 2) != 0) {
                for (n12 = 0; n12 < n13; ++n12) {
                    this.g.drawLine(n6, n7 - n14 + n12, n10, n7 - n14 + n12);
                }
            }
            if ((n5 & 4) != 0) {
                for (n12 = 0; n12 < n13; ++n12) {
                    this.g.drawLine(n10 - n14 + n12, n7, n10 - n14 + n12, n11);
                }
            }
            if ((n5 & 8) != 0) {
                for (n12 = 0; n12 < n13; ++n12) {
                    this.g.drawLine(n6, n11 - n14 + n12, n10, n11 - n14 + n12);
                }
            }
        }
        object = new Rectangle2D.Float(n6, n7, n8, n9);
        this.addURLShape(this.cxt, (Shape)object);
    }

    @Override
    public void drawRoundRect(IGlint.PenId penId, IGlint.ColorId colorId, int n, int n2, int n3, int n4, int n5, int n6) {
    }

    @Override
    public void drawRoundCellRect(IGlint.PenId penId, IGlint.ColorId colorId, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
    }

    @Override
    public void drawEllipse(IGlint.PenId penId, IGlint.ColorId colorId, int n, int n2, int n3, int n4) {
    }

    @Override
    public void drawPolygon(IGlint.PenId penId, IGlint.ColorId colorId, int[] nArray, int[] nArray2) {
    }

    @Override
    public void drawImage(IGlint.ImageId imageId, int n, int n2) {
        int n3 = n / 20;
        int n4 = n2 / 20;
        Image image = this.cxt.getImage(imageId);
        this.g.drawImage(image.asAWTImage(), n3, n4, null);
        if (this.cxt.hasURL()) {
            Rectangle rectangle = new Rectangle(n3, n4, image.getWidth(), image.getHeight());
            this.addURLShape(this.cxt, rectangle);
        }
    }

    @Override
    public void drawScaledImage(IGlint.ImageId imageId, int n, int n2, int n3, int n4) {
        int n5 = n / 20;
        int n6 = n2 / 20;
        int n7 = n3 / 20;
        int n8 = n4 / 20;
        Image image = this.cxt.getImage(imageId);
        this.g.drawImage(image.asAWTImage(), n5, n6, n5 + n7, n6 + n8, 0, 0, image.getWidth(), image.getHeight(), null);
        if (this.cxt.hasURL()) {
            Rectangle rectangle = new Rectangle(n5, n6, n7, n8);
            this.addURLShape(this.cxt, rectangle);
        }
    }

    @Override
    public void drawSubImage(IGlint.ImageId imageId, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = n / 20;
        int n8 = n2 / 20;
        Image image = this.cxt.getImage(imageId);
        this.g.drawImage(image.asAWTImage(), n7, n8, n7 + n5, n8 + n6, n3, n4, n3 + n5, n4 + n6, null);
        if (this.cxt.hasURL()) {
            Rectangle rectangle = new Rectangle(n7, n8, n5 * 20, n6 * 20);
            this.addURLShape(this.cxt, rectangle);
        }
    }

    @Override
    public void drawScaledSubImage(IGlint.ImageId imageId, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        int n9 = n / 20;
        int n10 = n2 / 20;
        int n11 = n3 / 20;
        int n12 = n4 / 20;
        Image image = this.cxt.getImage(imageId);
        this.g.drawImage(image.asAWTImage(), n9, n10, n9 + n11, n10 + n12, n5, n6, n5 + n7, n6 + n8, null);
        if (this.cxt.hasURL()) {
            Rectangle rectangle = new Rectangle(n, n2, n3, n4);
            this.addURLShape(this.cxt, rectangle);
        }
    }

    @Override
    public void offsetOrigin(int n, int n2) {
        int n3 = n / 20;
        int n4 = n2 / 20;
        this.g.translate(n3, n4);
        this.m_OffsetX += n3;
        this.m_OffsetY += n4;
    }

    @Override
    public void setOrigin(int n, int n2) {
        int n3 = n / 20;
        int n4 = n2 / 20;
        this.g.translate(-this.m_OffsetX + n3, -this.m_OffsetY + n4);
        this.m_OffsetX = n3;
        this.m_OffsetY = n4;
    }

    @Override
    public int getOriginX() {
        return this.m_OffsetX * 20;
    }

    @Override
    public int getOriginY() {
        return this.m_OffsetY * 20;
    }

    @Override
    public void setURL(String string, String string2) {
        this.cxt.setURL(string, string2);
    }

    @Override
    public void resetURL() {
        this.cxt.resetURL();
    }

    @Override
    public void pushClip(int n, int n2, int n3, int n4) {
        int n5 = n / 20;
        int n6 = n2 / 20;
        int n7 = n3 / 20;
        int n8 = n4 / 20;
        this.cxt.pushClip(this.g.getClipBounds());
        this.g.clipRect(n5, n6, n7, n8);
    }

    @Override
    public void pushClip(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        this.pushClip(n, n2, n3, n4);
    }

    @Override
    public void popClip() {
        Rectangle rectangle = this.cxt.popClip();
        this.g.setClip(rectangle);
    }

    @Override
    public void drawText(IGlint.FontId fontId, IGlint.ColorId colorId, int n, int n2, int n3, String string) {
        int n4 = n / 20;
        int n5 = n2 / 20;
        this.cxt.setFont(fontId);
        this.cxt.setColor(colorId.id);
        FontMetrics fontMetrics = this.g.getFontMetrics();
        int n6 = fontMetrics.stringWidth(string);
        if (n3 == 2) {
            n4 -= n6;
        } else if (n3 == 3) {
            n4 -= n6 / 2;
        }
        this.g.drawString(string, n4, n5);
        if (this.cxt.isFontUnderlined()) {
            this.g.drawLine(n4, n5 + 2, n4 + n6, n5 + 2);
        }
        if (this.cxt.hasURL()) {
            int n7 = fontMetrics.getHeight();
            Rectangle rectangle = new Rectangle(n, n2 - n7, n6, n7);
            this.addURLShape(this.cxt, rectangle);
        }
    }

    @Override
    public void drawJustifiedText(IGlint.FontId fontId, IGlint.ColorId colorId, int n, int n2, int n3, String string) {
        this.drawText(fontId, colorId, n, n2, 1, string);
    }

    @Override
    public void drawRotatedText(IGlint.FontId fontId, IGlint.ColorId colorId, int n, int n2, int n3, int n4, String string) {
    }

    @Override
    public void drawRotatedJustifiedText(IGlint.FontId fontId, IGlint.ColorId colorId, int n, int n2, int n3, int n4, String string) {
        this.drawRotatedText(fontId, colorId, n, n2, 1, n4, string);
    }

    @Override
    public void drawRTF(int n, int n2, int n3, int n4, String string) {
    }

    @Override
    public void flush() {
    }

    private void addURLShape(GlintContext glintContext, Shape shape) {
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(this.m_OffsetX, this.m_OffsetY);
        Shape shape2 = affineTransform.createTransformedShape(shape);
        glintContext.addURLShape(shape2);
    }
}

