/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.glint.g;

import com.elixirtech.glint.Color;
import com.elixirtech.glint.Font;
import com.elixirtech.glint.IGlint;
import com.elixirtech.glint.Image;
import com.elixirtech.glint.Pen;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.image.ImageObserver;
import java.text.AttributedCharacterIterator;
import java.util.HashMap;
import java.util.Map;

public class GraphicsToGlint
extends Graphics {
    private final IGlint m_Glint;
    private final Rectangle m_Bounds;
    private int m_ClipDepth;
    private java.awt.Color m_Color = java.awt.Color.black;
    private Font m_Font = new Font(null);
    private Rectangle m_Clip;
    private IGlint.PenId m_PenId;
    private IGlint.ColorId m_ColorId;
    private IGlint.FontId m_FontId;
    private final Map<java.awt.Color, IGlint.PenId> m_PenMap = new HashMap<java.awt.Color, IGlint.PenId>();
    private final Map<java.awt.Color, IGlint.ColorId> m_ColorMap = new HashMap<java.awt.Color, IGlint.ColorId>();
    private final Map<Font, IGlint.FontId> m_FontMap = new HashMap<Font, IGlint.FontId>();
    private final Map<java.awt.Image, IGlint.ImageId> m_ImageMap = new HashMap<java.awt.Image, IGlint.ImageId>();
    private static final IGlint.PenId NULL_PEN = new IGlint.PenId(0);
    private static final IGlint.ColorId NULL_FILL = new IGlint.ColorId(0);

    public GraphicsToGlint(IGlint iGlint, Rectangle rectangle) {
        this.m_Glint = iGlint;
        this.m_Bounds = rectangle;
        this.m_Clip = rectangle;
    }

    @Override
    public void dispose() {
    }

    @Override
    public void setPaintMode() {
    }

    @Override
    public void translate(int n, int n2) {
        this.m_Glint.setOrigin(n * 20, n2 * 20);
    }

    @Override
    public void clearRect(int n, int n2, int n3, int n4) {
    }

    @Override
    public void clipRect(int n, int n2, int n3, int n4) {
        this.m_Glint.pushClip(n * 20, n2 * 20, n3 * 20, n4 * 20);
        ++this.m_ClipDepth;
        this.m_Clip = this.m_Clip.intersection(new Rectangle(n, n2, n3, n4));
    }

    @Override
    public void drawLine(int n, int n2, int n3, int n4) {
        this.m_Glint.drawLine(this.getPenId(), n * 20, n2 * 20, n3 * 20, n4 * 20);
    }

    @Override
    public void drawOval(int n, int n2, int n3, int n4) {
        this.m_Glint.drawEllipse(this.getPenId(), NULL_FILL, n * 20, n2 * 20, n3 * 20, n4 * 20);
    }

    @Override
    public void fillOval(int n, int n2, int n3, int n4) {
        this.m_Glint.drawEllipse(NULL_PEN, this.getFillId(), n * 20, n2 * 20, n3 * 20, n4 * 20);
    }

    @Override
    public void fillRect(int n, int n2, int n3, int n4) {
        this.m_Glint.drawRect(NULL_PEN, this.getFillId(), n * 20, n2 * 20, n3 * 20, n4 * 20);
    }

    @Override
    public void setClip(int n, int n2, int n3, int n4) {
        for (int i = 0; i < this.m_ClipDepth; ++i) {
            this.m_Glint.popClip();
        }
        this.m_Glint.pushClip(n, n2, n3, n4);
        this.m_ClipDepth = 1;
        this.m_Clip = new Rectangle(n, n2, n3, n4);
    }

    @Override
    public void copyArea(int n, int n2, int n3, int n4, int n5, int n6) {
    }

    @Override
    public void drawArc(int n, int n2, int n3, int n4, int n5, int n6) {
    }

    @Override
    public void drawRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        this.m_Glint.drawRoundRect(this.getPenId(), NULL_FILL, n * 20, n2 * 20, n3 * 20, n4 * 20, n5 * 20, n6 * 20);
    }

    @Override
    public void fillArc(int n, int n2, int n3, int n4, int n5, int n6) {
    }

    @Override
    public void fillRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        this.m_Glint.drawRoundRect(NULL_PEN, this.getFillId(), n * 20, n2 * 20, n3 * 20, n4 * 20, n5 * 20, n6 * 20);
    }

    @Override
    public void drawPolygon(int[] nArray, int[] nArray2, int n) {
        int[] nArray3 = new int[nArray.length];
        int[] nArray4 = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray3[i] = nArray[i] * 20;
            nArray4[i] = nArray2[i] * 20;
        }
        this.m_Glint.drawPolygon(this.getPenId(), NULL_FILL, nArray3, nArray4);
    }

    @Override
    public void drawPolyline(int[] nArray, int[] nArray2, int n) {
        int[] nArray3 = new int[nArray.length];
        int[] nArray4 = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray3[i] = nArray[i] * 20;
            nArray4[i] = nArray2[i] * 20;
        }
        this.m_Glint.drawPolyline(this.getPenId(), nArray3, nArray4);
    }

    @Override
    public void fillPolygon(int[] nArray, int[] nArray2, int n) {
        int[] nArray3 = new int[nArray.length];
        int[] nArray4 = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray3[i] = nArray[i] * 20;
            nArray4[i] = nArray2[i] * 20;
        }
        this.m_Glint.drawPolygon(NULL_PEN, this.getFillId(), nArray3, nArray4);
    }

    @Override
    public java.awt.Color getColor() {
        return this.m_Color;
    }

    @Override
    public void setColor(java.awt.Color color) {
        this.m_Color = color;
        this.m_PenId = null;
        this.m_ColorId = null;
    }

    @Override
    public void setXORMode(java.awt.Color color) {
    }

    @Override
    public Font getFont() {
        return this.m_Font;
    }

    @Override
    public void setFont(Font font) {
        this.m_Font = font;
        this.m_FontId = null;
    }

    @Override
    public Graphics create() {
        return new GraphicsToGlint(this.m_Glint, this.m_Bounds);
    }

    @Override
    public Rectangle getClipBounds() {
        return this.m_Clip;
    }

    @Override
    public Shape getClip() {
        return this.m_Clip;
    }

    @Override
    public void setClip(Shape shape) {
        Rectangle rectangle = shape.getBounds();
        this.setClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    @Override
    public void drawString(String string, int n, int n2) {
        this.m_Glint.drawText(this.getFontId(), this.getFillId(), n * 20, n2 * 20, 1, string);
    }

    @Override
    public void drawString(AttributedCharacterIterator attributedCharacterIterator, int n, int n2) {
    }

    @Override
    @Deprecated
    public FontMetrics getFontMetrics(Font font) {
        return Toolkit.getDefaultToolkit().getFontMetrics(font);
    }

    @Override
    public boolean drawImage(java.awt.Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, ImageObserver imageObserver) {
        this.m_Glint.drawScaledSubImage(this.getImageId(image), n * 20, n2 * 20, (n3 - n) * 20, (n4 - n2) * 20, n5, n7, n7 - n5, n8 - n6);
        return true;
    }

    @Override
    public boolean drawImage(java.awt.Image image, int n, int n2, int n3, int n4, ImageObserver imageObserver) {
        this.m_Glint.drawScaledImage(this.getImageId(image), n * 20, n2 * 20, n3 * 20, n4 * 20);
        return true;
    }

    @Override
    public boolean drawImage(java.awt.Image image, int n, int n2, ImageObserver imageObserver) {
        this.m_Glint.drawImage(this.getImageId(image), n * 20, n2 * 20);
        return true;
    }

    @Override
    public boolean drawImage(java.awt.Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, java.awt.Color color, ImageObserver imageObserver) {
        this.m_Glint.drawScaledSubImage(this.getImageId(image), n * 20, n2 * 20, (n3 - n) * 20, (n4 - n2) * 20, n5, n7, n7 - n5, n8 - n6);
        return true;
    }

    @Override
    public boolean drawImage(java.awt.Image image, int n, int n2, int n3, int n4, java.awt.Color color, ImageObserver imageObserver) {
        this.m_Glint.drawScaledImage(this.getImageId(image), n * 20, n2 * 20, n3 * 20, n4 * 20);
        return true;
    }

    @Override
    public boolean drawImage(java.awt.Image image, int n, int n2, java.awt.Color color, ImageObserver imageObserver) {
        this.m_Glint.drawImage(this.getImageId(image), n * 20, n2 * 20);
        return true;
    }

    private IGlint.PenId getPenId() {
        if (this.m_PenId == null) {
            this.m_PenId = this.m_PenMap.get(this.m_Color);
            if (this.m_PenId == null) {
                Color color = Color.newInstance(this.m_Color);
                this.m_PenId = this.m_Glint.definePen(Pen.newInstance(color, 1));
                this.m_PenMap.put(this.m_Color, this.m_PenId);
            }
        }
        return this.m_PenId;
    }

    private IGlint.ColorId getFillId() {
        if (this.m_ColorId == null) {
            this.m_ColorId = this.m_ColorMap.get(this.m_Color);
            if (this.m_ColorId == null) {
                this.m_ColorId = this.m_Glint.defineColor(Color.newInstance(this.m_Color));
                this.m_ColorMap.put(this.m_Color, this.m_ColorId);
            }
        }
        return this.m_ColorId;
    }

    private IGlint.FontId getFontId() {
        if (this.m_FontId == null) {
            this.m_FontId = this.m_FontMap.get(this.m_Font);
            if (this.m_FontId == null) {
                this.m_FontId = this.m_Glint.defineFont(new Font.AWTFont(this.m_Font));
                this.m_FontMap.put(this.m_Font, this.m_FontId);
            }
        }
        return this.m_FontId;
    }

    private IGlint.ImageId getImageId(java.awt.Image image) {
        IGlint.ImageId imageId = this.m_ImageMap.get(image);
        if (imageId == null) {
            String string = "Img" + this.m_ImageMap.size();
            imageId = this.m_Glint.defineImage(Image.getInstance(image, string));
            this.m_ImageMap.put(image, imageId);
        }
        return imageId;
    }
}

