/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.glint.g2d;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.glint.Color;
import com.elixirtech.glint.Font;
import com.elixirtech.glint.GraphicsCodes;
import com.elixirtech.glint.IGlint;
import com.elixirtech.glint.Image;
import com.elixirtech.glint.Pen;
import com.elixirtech.glint.g2d.DoubleStroke;
import com.elixirtech.glint.g2d.Glint2DContext;
import com.elixirtech.glint.g2d.URLMap;
import com.elixirtech.graphics.BorderStyle;
import com.elixirtech.graphics.GRectangle;
import com.elixirtech.graphics.util.WaveStroke;
import com.elixirtech.rtf.RtfGraphicsWalker;
import com.elixirtech.rtf.RtfGroup;
import com.elixirtech.rtf.RtfReader;
import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.io.ByteArrayInputStream;
import java.text.AttributedString;

public class GlintGraphics2D
implements IGlint,
GraphicsCodes {
    private static final IGlint.ColorId ID_COLOR_NONE = new IGlint.ColorId(0);
    private static final IGlint.PenId ID_PEN_NONE = new IGlint.PenId(0);
    private static final boolean ENABLE_CLIPPING = true;
    private static final boolean AVOID_TEXTLAYOUT = true;
    private final Graphics2D g;
    private final Glint2DContext cxt;
    private int m_Width;
    private int m_Height;
    private int m_Orientation;
    private double m_ZoomPercent;
    private final AffineTransform m_Transform = new AffineTransform();
    private static final BasicStroke PLAIN_STROKE = new BasicStroke(1.0f);
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(GlintGraphics2D.class);

    public GlintGraphics2D(Graphics2D graphics2D) {
        this(graphics2D, 100.0);
    }

    public GlintGraphics2D(Graphics2D graphics2D, double d) {
        this.g = graphics2D;
        this.m_ZoomPercent = d;
        this.cxt = new Glint2DContext(graphics2D);
        graphics2D.scale(0.05, 0.05);
        graphics2D.scale(this.m_ZoomPercent / 100.0, this.m_ZoomPercent / 100.0);
        this.m_Transform.scale(this.m_ZoomPercent / 100.0, this.m_ZoomPercent / 100.0);
    }

    @Override
    public void init(int n, int n2, int n3) {
        this.m_Width = n;
        this.m_Height = n2;
        this.m_Orientation = n3;
    }

    @Override
    public int getWidth() {
        return this.m_Width;
    }

    @Override
    public int getHeight() {
        return this.m_Height;
    }

    @Override
    public int getOrientation() {
        return this.m_Orientation;
    }

    public URLMap getURLMap() {
        return this.cxt.getURLMap();
    }

    @Override
    public IGlint.FontId defineFont(Font font) {
        return this.cxt.addFont(font);
    }

    @Override
    public IGlint.ColorId defineColor(Color color) {
        if (color == Color.NONE) {
            return ID_COLOR_NONE;
        }
        return this.cxt.addColor(color);
    }

    @Override
    public IGlint.ImageId defineImage(Image image) {
        return this.cxt.addImage(image);
    }

    @Override
    public IGlint.PenId definePen(Pen pen) {
        if (pen == Pen.NONE) {
            return ID_PEN_NONE;
        }
        return this.cxt.addPen(pen);
    }

    @Override
    public IGlint.StringId defineString() {
        return this.cxt.addString();
    }

    @Override
    public void setString(IGlint.StringId stringId, String string) {
        this.cxt.setString(stringId, string);
    }

    @Override
    public Font getFont(IGlint.FontId fontId) {
        return this.cxt.getFont(fontId);
    }

    @Override
    public Color getColor(IGlint.ColorId colorId) {
        return this.cxt.getColor(colorId);
    }

    @Override
    public Image getImage(IGlint.ImageId imageId) {
        return this.cxt.getImage(imageId);
    }

    @Override
    public Pen getPen(IGlint.PenId penId) {
        return this.cxt.getPen(penId);
    }

    @Override
    public String getString(IGlint.StringId stringId) {
        return this.cxt.getString(stringId);
    }

    @Override
    public void drawLine(IGlint.PenId penId, int n, int n2, int n3, int n4) {
        this.cxt.setPen(penId);
        this.g.drawLine(n, n2, n3, n4);
    }

    @Override
    public void drawPolyline(IGlint.PenId penId, int[] nArray, int[] nArray2) {
        this.cxt.setPen(penId);
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(nArray[0], nArray2[0]);
        for (int i = 1; i < nArray.length; ++i) {
            generalPath.lineTo(nArray[i], nArray2[i]);
        }
        this.g.draw(generalPath);
    }

    @Override
    public void drawRect(IGlint.PenId penId, IGlint.ColorId colorId, int n, int n2, int n3, int n4) {
        this.drawCellRect(penId, colorId, n, n2, n3, n4, 15);
    }

    @Override
    public void drawCellRect(IGlint.PenId penId, IGlint.ColorId colorId, int n, int n2, int n3, int n4, int n5) {
        Rectangle rectangle = new Rectangle(n, n2, n3, n4);
        GRectangle gRectangle = new GRectangle(rectangle);
        if (colorId.id != 0) {
            gRectangle.setBackground(this.cxt.getColor(colorId).getAWTColor());
        }
        if (penId.id != 0) {
            Pen pen = this.cxt.getPen(penId);
            gRectangle.setBorder(BorderStyle.get(pen.getStyle()), pen.getWidth(), pen.getColor().getAWTColor(), n5);
        }
        gRectangle.draw(this.g);
        this.cxt.setColor(null);
        if (this.cxt.hasURL()) {
            this.addURLShape(this.cxt, gRectangle.getShape());
        }
    }

    @Override
    public void drawRoundRect(IGlint.PenId penId, IGlint.ColorId colorId, int n, int n2, int n3, int n4, int n5, int n6) {
        this.drawRoundCellRect(penId, colorId, n, n2, n3, n4, n5, n6, 15);
    }

    @Override
    public void drawRoundCellRect(IGlint.PenId penId, IGlint.ColorId colorId, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        Rectangle rectangle = new Rectangle(n, n2, n3, n4);
        GRectangle gRectangle = new GRectangle(rectangle);
        if (colorId.id != 0) {
            gRectangle.setBackground(this.cxt.getColor(colorId).getAWTColor());
        }
        if (penId.id != 0) {
            Pen pen = this.cxt.getPen(penId);
            gRectangle.setBorder(BorderStyle.get(pen.getStyle()), pen.getWidth(), pen.getColor().getAWTColor(), n7);
            gRectangle.setBorderRadius(n5, n6);
        }
        gRectangle.draw(this.g);
        this.cxt.setColor(null);
        if (this.cxt.hasURL()) {
            this.addURLShape(this.cxt, gRectangle.getShape());
        }
    }

    @Override
    public void drawEllipse(IGlint.PenId penId, IGlint.ColorId colorId, int n, int n2, int n3, int n4) {
        Ellipse2D.Float float_ = new Ellipse2D.Float(n, n2, n3, n4);
        this.render(penId, colorId, float_);
    }

    @Override
    public void drawPolygon(IGlint.PenId penId, IGlint.ColorId colorId, int[] nArray, int[] nArray2) {
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(nArray[0], nArray2[0]);
        for (int i = 1; i < nArray.length; ++i) {
            generalPath.lineTo(nArray[i], nArray2[i]);
        }
        generalPath.closePath();
        this.render(penId, colorId, generalPath);
    }

    @Override
    public void drawImage(IGlint.ImageId imageId, int n, int n2) {
        Image image = this.cxt.getImage(imageId);
        int n3 = image.getWidth() * 20;
        int n4 = image.getHeight() * 20;
        this.g.drawImage(image.asAWTImage(), n, n2, n3, n4, null);
        if (this.cxt.hasURL()) {
            Rectangle rectangle = new Rectangle(n, n2, n3, n4);
            this.addURLShape(this.cxt, rectangle);
        }
    }

    @Override
    public void drawScaledImage(IGlint.ImageId imageId, int n, int n2, int n3, int n4) {
        Image image = this.cxt.getImage(imageId);
        this.g.drawImage(image.asAWTImage(), n, n2, n + n3, n2 + n4, 0, 0, image.getWidth(), image.getHeight(), null);
        if (this.cxt.hasURL()) {
            Rectangle rectangle = new Rectangle(n, n2, n3, n4);
            this.addURLShape(this.cxt, rectangle);
        }
    }

    @Override
    public void drawSubImage(IGlint.ImageId imageId, int n, int n2, int n3, int n4, int n5, int n6) {
        Image image = this.cxt.getImage(imageId);
        this.g.drawImage(image.asAWTImage(), n, n2, n + n5 * 20, n2 + n6 * 20, n3, n4, n3 + n5, n4 + n6, null);
        if (this.cxt.hasURL()) {
            Rectangle rectangle = new Rectangle(n, n2, n5 * 20, n6 * 20);
            this.addURLShape(this.cxt, rectangle);
        }
    }

    @Override
    public void drawScaledSubImage(IGlint.ImageId imageId, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        Image image = this.cxt.getImage(imageId);
        this.g.drawImage(image.asAWTImage(), n, n2, n + n3, n2 + n4, n5, n6, n5 + n7, n6 + n8, null);
        if (this.cxt.hasURL()) {
            Rectangle rectangle = new Rectangle(n, n2, n3, n4);
            this.addURLShape(this.cxt, rectangle);
        }
    }

    @Override
    public void offsetOrigin(int n, int n2) {
        this.g.translate(n, n2);
        this.m_Transform.translate(n, n2);
    }

    @Override
    public void setOrigin(int n, int n2) {
        int n3 = (int)this.m_Transform.getTranslateX();
        int n4 = (int)this.m_Transform.getTranslateY();
        this.g.translate(-n3 + n, -n4 + n2);
        this.m_Transform.translate(-n3 + n, -n4 + n2);
    }

    @Override
    public int getOriginX() {
        return (int)this.m_Transform.getTranslateX();
    }

    @Override
    public int getOriginY() {
        return (int)this.m_Transform.getTranslateY();
    }

    @Override
    public void setURL(String string, String string2) {
        this.cxt.setURL(string, string2);
    }

    @Override
    public void resetURL() {
        this.cxt.resetURL();
    }

    @Override
    public void pushClip(int n, int n2, int n3, int n4) {
        this.cxt.pushClip(this.g.getClip());
        this.g.clipRect(n, n2, n3, n4);
    }

    @Override
    public void pushClip(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        this.cxt.pushClip(this.g.getClip());
        GRectangle gRectangle = new GRectangle(new Rectangle(n, n2, n3, n4));
        gRectangle.setBorderRadius(n5, n6);
        gRectangle.setBorder(BorderStyle.SOLID, 0, java.awt.Color.RED, n7);
        Shape shape = gRectangle.getShape();
        this.g.clip(shape);
    }

    @Override
    public void popClip() {
        Shape shape = this.cxt.popClip();
        this.g.setClip(shape);
    }

    @Override
    public void drawText(IGlint.FontId fontId, IGlint.ColorId colorId, int n, int n2, int n3, String string) {
        if (string.length() == 0) {
            return;
        }
        try {
            float f;
            this.cxt.setFont(fontId);
            this.cxt.setColor(colorId.id);
            this.g.translate(n, n2);
            this.g.scale(20.0, 20.0);
            string = this.substitute(string);
            FontRenderContext fontRenderContext = this.g.getFontRenderContext();
            AttributedString attributedString = new AttributedString(string);
            attributedString.addAttribute(TextAttribute.FONT, this.g.getFont());
            attributedString.addAttribute(TextAttribute.FOREGROUND, this.g.getColor());
            if (this.cxt.isFontUnderlined()) {
                attributedString.addAttribute(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
            }
            if (this.cxt.isFontStrikethrough()) {
                attributedString.addAttribute(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
            }
            TextLayout textLayout = new TextLayout(attributedString.getIterator(), fontRenderContext);
            float f2 = 0.0f;
            float f3 = textLayout.getAdvance();
            if (n3 == 2) {
                f2 = -f3;
            } else if (n3 == 3) {
                f2 = -f3 / 2.0f;
            }
            this.g.drawString(string, f2, 0.0f);
            if (this.cxt.isFontUnderlined() || this.cxt.isFontStrikethrough()) {
                GeneralPath generalPath;
                float f4;
                LineMetrics lineMetrics = this.g.getFont().getLineMetrics(string, fontRenderContext);
                if (this.cxt.isFontUnderlined()) {
                    f = lineMetrics.getUnderlineOffset();
                    f4 = lineMetrics.getUnderlineThickness();
                    this.g.setStroke(new BasicStroke(f4));
                    generalPath = new GeneralPath();
                    generalPath.moveTo(f2, f);
                    generalPath.lineTo(f2 + f3, f);
                    this.g.draw(generalPath);
                }
                if (this.cxt.isFontStrikethrough()) {
                    f = lineMetrics.getStrikethroughOffset();
                    f4 = lineMetrics.getStrikethroughThickness();
                    this.g.setStroke(new BasicStroke(f4));
                    generalPath = new GeneralPath();
                    generalPath.moveTo(f2, f);
                    generalPath.lineTo(f2 + f3, f);
                    this.g.draw(generalPath);
                }
            }
            this.g.scale(0.05, 0.05);
            this.g.translate(-n, -n2);
            if (this.cxt.hasURL()) {
                float f5 = textLayout.getAscent();
                f = f5 + textLayout.getDescent();
                Rectangle2D.Float float_ = new Rectangle2D.Float((float)n + f2 * 20.0f, (float)n2 - f5 * 20.0f, f3 * 20.0f, f * 20.0f);
                this.addURLShape(this.cxt, float_);
            }
        }
        catch (Exception exception) {
            m_Log.error((Object)("Error in drawText(" + fontId.id + "," + colorId.id + "," + n + "," + n2 + "," + n3 + "," + string + ") : " + exception), (Throwable)exception);
        }
    }

    @Override
    public void drawJustifiedText(IGlint.FontId fontId, IGlint.ColorId colorId, int n, int n2, int n3, String string) {
        if (string.length() == 0) {
            return;
        }
        try {
            this.cxt.setFont(fontId);
            this.cxt.setColor(colorId.id);
            this.g.translate(n, n2);
            this.g.scale(20.0, 20.0);
            string = this.substitute(string);
            FontRenderContext fontRenderContext = this.g.getFontRenderContext();
            AttributedString attributedString = new AttributedString(string);
            attributedString.addAttribute(TextAttribute.FONT, this.g.getFont());
            attributedString.addAttribute(TextAttribute.FOREGROUND, this.g.getColor());
            if (this.cxt.isFontUnderlined()) {
                attributedString.addAttribute(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
            }
            if (this.cxt.isFontStrikethrough()) {
                attributedString.addAttribute(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
            }
            TextLayout textLayout = new TextLayout(attributedString.getIterator(), fontRenderContext).getJustifiedLayout((float)n3 / 20.0f);
            textLayout.draw(this.g, 0.0f, 0.0f);
            this.g.scale(0.05, 0.05);
            this.g.translate(-n, -n2);
            if (this.cxt.hasURL()) {
                float f = textLayout.getAscent();
                float f2 = f + textLayout.getDescent();
                Rectangle2D.Float float_ = new Rectangle2D.Float(n, (float)n2 - f * 20.0f, n3, f2 * 20.0f);
                this.addURLShape(this.cxt, float_);
            }
        }
        catch (Exception exception) {
            m_Log.error((Object)("Error in drawJustifiedText(" + fontId.id + "," + colorId.id + "," + n + "," + n2 + "," + n3 + "," + string + ") : " + exception), (Throwable)exception);
        }
    }

    @Override
    public void drawRotatedText(IGlint.FontId fontId, IGlint.ColorId colorId, int n, int n2, int n3, int n4, String string) {
        if (string.length() == 0) {
            return;
        }
        try {
            Cloneable cloneable;
            float f;
            this.cxt.setFont(fontId);
            this.cxt.setColor(colorId.id);
            double d = (double)(-n4) * Math.PI / 180.0;
            this.g.translate(n, n2);
            this.g.rotate(d, 0.0, 0.0);
            this.g.scale(20.0, 20.0);
            string = this.substitute(string);
            FontRenderContext fontRenderContext = this.g.getFontRenderContext();
            AttributedString attributedString = new AttributedString(string);
            attributedString.addAttribute(TextAttribute.FONT, this.g.getFont());
            attributedString.addAttribute(TextAttribute.FOREGROUND, this.g.getColor());
            if (this.cxt.isFontUnderlined()) {
                attributedString.addAttribute(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
            }
            if (this.cxt.isFontStrikethrough()) {
                attributedString.addAttribute(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
            }
            TextLayout textLayout = new TextLayout(attributedString.getIterator(), fontRenderContext);
            float f2 = 0.0f;
            float f3 = textLayout.getAdvance();
            if (n3 == 2) {
                f2 = -f3;
            } else if (n3 == 3) {
                f2 = -f3 / 2.0f;
            }
            this.g.drawString(string, f2, 0.0f);
            if (this.cxt.isFontUnderlined() || this.cxt.isFontStrikethrough()) {
                float f4;
                LineMetrics lineMetrics = this.g.getFont().getLineMetrics(string, fontRenderContext);
                if (this.cxt.isFontUnderlined()) {
                    f = lineMetrics.getUnderlineOffset();
                    f4 = lineMetrics.getUnderlineThickness();
                    this.g.setStroke(new BasicStroke(f4));
                    cloneable = new GeneralPath();
                    ((Path2D.Float)cloneable).moveTo(f2, f);
                    ((Path2D.Float)cloneable).lineTo(f2 + f3, f);
                    this.g.draw((Shape)((Object)cloneable));
                }
                if (this.cxt.isFontStrikethrough()) {
                    f = lineMetrics.getStrikethroughOffset();
                    f4 = lineMetrics.getStrikethroughThickness();
                    this.g.setStroke(new BasicStroke(f4));
                    cloneable = new GeneralPath();
                    ((Path2D.Float)cloneable).moveTo(f2, f);
                    ((Path2D.Float)cloneable).lineTo(f2 + f3, f);
                    this.g.draw((Shape)((Object)cloneable));
                }
            }
            this.g.scale(0.05, 0.05);
            this.g.rotate(-d, 0.0, 0.0);
            this.g.translate(-n, -n2);
            if (this.cxt.hasURL()) {
                float f5 = textLayout.getAscent();
                f = f5 + textLayout.getDescent();
                Shape shape = new Rectangle2D.Float((float)n + f2 * 20.0f, (float)n2 - f5 * 20.0f, f3 * 20.0f, f * 20.0f);
                cloneable = AffineTransform.getRotateInstance(d, n, n2);
                shape = ((AffineTransform)cloneable).createTransformedShape(shape);
                this.addURLShape(this.cxt, shape);
            }
        }
        catch (Exception exception) {
            m_Log.error((Object)("Error in drawRotatedText(" + fontId.id + "," + colorId.id + "," + n + "," + n2 + "," + n3 + "," + n4 + "," + string + ") : " + exception), (Throwable)exception);
        }
    }

    @Override
    public void drawRotatedJustifiedText(IGlint.FontId fontId, IGlint.ColorId colorId, int n, int n2, int n3, int n4, String string) {
        if (string.length() == 0) {
            return;
        }
        try {
            this.cxt.setFont(fontId);
            this.cxt.setColor(colorId.id);
            double d = (double)(-n4) * Math.PI / 180.0;
            this.g.translate(n, n2);
            this.g.rotate(d, 0.0, 0.0);
            this.g.scale(20.0, 20.0);
            string = this.substitute(string);
            FontRenderContext fontRenderContext = this.g.getFontRenderContext();
            AttributedString attributedString = new AttributedString(string);
            attributedString.addAttribute(TextAttribute.FONT, this.g.getFont());
            attributedString.addAttribute(TextAttribute.FOREGROUND, this.g.getColor());
            if (this.cxt.isFontUnderlined()) {
                attributedString.addAttribute(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
            }
            if (this.cxt.isFontStrikethrough()) {
                attributedString.addAttribute(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
            }
            TextLayout textLayout = new TextLayout(attributedString.getIterator(), fontRenderContext).getJustifiedLayout((float)n3 / 20.0f);
            textLayout.draw(this.g, 0.0f, 0.0f);
            this.g.scale(0.05, 0.05);
            this.g.rotate(-d, 0.0, 0.0);
            this.g.translate(-n, -n2);
            if (this.cxt.hasURL()) {
                float f = textLayout.getAscent();
                float f2 = f + textLayout.getDescent();
                Shape shape = new Rectangle2D.Float(n, (float)n2 - f * 20.0f, n3, f2 * 20.0f);
                AffineTransform affineTransform = AffineTransform.getRotateInstance(d, n, n2);
                shape = affineTransform.createTransformedShape(shape);
                this.addURLShape(this.cxt, shape);
            }
        }
        catch (Exception exception) {
            m_Log.error((Object)("Error in drawRotatedText(" + fontId.id + "," + colorId.id + "," + n + "," + n2 + "," + n3 + "," + n4 + "," + string + ") : " + exception), (Throwable)exception);
        }
    }

    @Override
    public void drawRTF(int n, int n2, int n3, int n4, String string) {
        try {
            byte[] byArray = string.getBytes("UTF-8");
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            RtfReader rtfReader = new RtfReader(byteArrayInputStream);
            RtfGroup rtfGroup = rtfReader.getTreeRoot();
            Rectangle rectangle = new Rectangle(n / 20, n2 / 20, n3 / 20, n4 / 20);
            this.g.scale(20.0, 20.0);
            RtfGraphicsWalker rtfGraphicsWalker = new RtfGraphicsWalker(rectangle, this.g);
            rtfGroup.walk(rtfGraphicsWalker);
            this.g.scale(0.05, 0.05);
        }
        catch (Exception exception) {
            m_Log.error((Object)("Error in drawRTF(): " + exception), (Throwable)exception);
        }
    }

    @Override
    public void flush() {
        this.m_Transform.scale(100.0 / this.m_ZoomPercent, 100.0 / this.m_ZoomPercent);
        this.g.scale(100.0 / this.m_ZoomPercent, 100.0 / this.m_ZoomPercent);
        this.g.scale(20.0, 20.0);
    }

    private String substitute(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if ((c & 0xF000) == 57344) {
                IGlint.StringId stringId = new IGlint.StringId(c - 57344);
                String string2 = this.getString(stringId);
                if (string2 != null) {
                    stringBuilder.append(string2);
                    continue;
                }
                stringBuilder.append(c);
                continue;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    private void render(IGlint.PenId penId, IGlint.ColorId colorId, Shape shape) {
        if (colorId.id != 0) {
            this.cxt.setColor(colorId.id);
            this.cxt.g.fill(shape);
        }
        if (penId.id != 0) {
            this.cxt.setPen(penId);
            this.cxt.g.draw(shape);
        }
        this.addURLShape(this.cxt, shape);
    }

    private void addURLShape(Glint2DContext glint2DContext, Shape shape) {
        Shape shape2 = this.m_Transform.createTransformedShape(shape);
        glint2DContext.addURLShape(shape2);
    }

    public static Stroke getStroke(int n, int n2) {
        if (n2 == 1) {
            return new BasicStroke(n, 0, 0);
        }
        if (n2 == 2) {
            return new BasicStroke(n, 0, 0, 20.0f, new float[]{n * 5, n * 2}, 0.0f);
        }
        if (n2 == 3) {
            return new BasicStroke(n, 0, 0, 20.0f, new float[]{n, n}, 0.0f);
        }
        if (n2 == 4) {
            return new BasicStroke(n, 0, 0, 20.0f, new float[]{n, n, n * 5, n}, 0.0f);
        }
        if (n2 == 5) {
            return new BasicStroke(n, 0, 0, 20.0f, new float[]{n, n, n, n, n * 5, n}, 0.0f);
        }
        if (n2 == 6) {
            return new WaveStroke(20.0f, n * 5, (float)n / 2.0f);
        }
        if (n2 == 7) {
            return new DoubleStroke(n);
        }
        return PLAIN_STROKE;
    }
}

