/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.glint.print;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.arch.ElxLoggerJ$;
import com.elixirtech.glint.print.GlintPrintable;
import com.elixirtech.glint.print.GlintPrintables$;
import com.elixirtech.glint.print.PrintableRange;
import java.awt.Graphics;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.io.Serializable;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.LinearSeqOps;
import scala.collection.immutable.List;
import scala.runtime.BoxesRunTime;

public class GlintPrintables
implements Printable,
Pageable {
    private final List glintPrintables;
    private final ElxLoggerJ logger;
    private final int totalPages;
    private final List listOfPrintableRanges;
    private Option currentPrintable;

    public static List<PrintableRange> buildRanges(List<GlintPrintable> list) {
        return GlintPrintables$.MODULE$.buildRanges(list);
    }

    public GlintPrintables(List<GlintPrintable> glintPrintables) {
        this.glintPrintables = glintPrintables;
        this.logger = ElxLoggerJ$.MODULE$.getLogger(GlintPrintables.class);
        this.totalPages = BoxesRunTime.unboxToInt((Object)glintPrintables.foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2 & Serializable)(a, b) -> GlintPrintables.$init$$$anonfun$1(BoxesRunTime.unboxToInt((Object)a), (GlintPrintable)b)));
        this.listOfPrintableRanges = GlintPrintables$.MODULE$.buildRanges(glintPrintables);
        this.currentPrintable = None$.MODULE$;
    }

    public List<GlintPrintable> glintPrintables() {
        return this.glintPrintables;
    }

    public ElxLoggerJ logger() {
        return this.logger;
    }

    public int totalPages() {
        return this.totalPages;
    }

    public List<PrintableRange> listOfPrintableRanges() {
        return this.listOfPrintableRanges;
    }

    public Option<Tuple2<Object, PrintableRange>> currentPrintable() {
        return this.currentPrintable;
    }

    public void currentPrintable_$eq(Option<Tuple2<Object, PrintableRange>> x$1) {
        this.currentPrintable = x$1;
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) {
        Option<PrintableRange> option = this.findRange(pageIndex);
        if (!(option instanceof Some)) {
            if (None$.MODULE$.equals(option)) {
                throw new PrinterException();
            }
            throw new MatchError(option);
        }
        PrintableRange pr = (PrintableRange)((Some)option).value();
        pr.print(graphics, pageFormat, pageIndex);
        return pageIndex;
    }

    @Override
    public int getNumberOfPages() {
        return this.totalPages();
    }

    @Override
    public PageFormat getPageFormat(int pageIndex) {
        Option<PrintableRange> option = this.findRange(pageIndex);
        if (option instanceof Some) {
            PrintableRange pr = (PrintableRange)((Some)option).value();
            return pr.getPageFormat(pageIndex);
        }
        if (None$.MODULE$.equals(option)) {
            this.logger().error((Object)("Unable to get " + pageIndex + ", total page " + this.getNumberOfPages() + " "));
            throw new IndexOutOfBoundsException();
        }
        throw new MatchError(option);
    }

    public Option<PrintableRange> findRange(int pageIndex) {
        Object object;
        Option<Tuple2<Object, PrintableRange>> option = this.currentPrintable();
        if (option instanceof Some) {
            Tuple2 cp = (Tuple2)((Some)option).value();
            Tuple2 tuple2 = cp;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int page = BoxesRunTime.unboxToInt((Object)tuple2._1());
            PrintableRange pr = (PrintableRange)tuple2._2();
            Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)page), (Object)pr);
            int page2 = BoxesRunTime.unboxToInt((Object)tuple22._1());
            PrintableRange pr2 = (PrintableRange)tuple22._2();
            object = page2 == pageIndex ? Some$.MODULE$.apply((Object)pr2) : this.scanRange$1(pageIndex);
        } else if (None$.MODULE$.equals(option)) {
            object = this.scanRange$1(pageIndex);
        } else {
            throw new MatchError(option);
        }
        Option curP = object;
        this.currentPrintable_$eq((Option<Tuple2<Object, PrintableRange>>)curP.map((Function1 & Serializable)rp -> Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)pageIndex), rp)));
        return curP;
    }

    @Override
    public Printable getPrintable(int pageIndex) {
        Option<PrintableRange> option = this.findRange(pageIndex);
        if (option instanceof Some) {
            PrintableRange pr = (PrintableRange)((Some)option).value();
            return pr;
        }
        if (None$.MODULE$.equals(option)) {
            throw new IndexOutOfBoundsException();
        }
        throw new MatchError(option);
    }

    private static final /* synthetic */ int $init$$$anonfun$1(int a, GlintPrintable b) {
        return a + b.getNumberOfPages();
    }

    private final Option scanRange$1(int pageIndex$1) {
        List test = this.listOfPrintableRanges().map((Function1 & Serializable)r -> {
            if (r.range().contains(pageIndex$1)) {
                return Some$.MODULE$.apply(r);
            }
            return None$.MODULE$;
        });
        return ((LinearSeqOps)test.flatten(Predef$.MODULE$.$conforms())).headOption();
    }
}

