/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.glint.print;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.glint.IEye;
import java.awt.Dimension;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import javax.print.DocFlavor;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;

public final class PrinterUtil {
    private PrinterUtil() {
    }

    public static String[] getPrinters() {
        PrintService[] printServiceArray = PrinterUtil.getPrintServices();
        String[] stringArray = new String[printServiceArray.length];
        for (int i = 0; i < printServiceArray.length; ++i) {
            stringArray[i] = printServiceArray[i].getName();
        }
        return stringArray;
    }

    public static PrintService[] getPrintServices() {
        DocFlavor.SERVICE_FORMATTED sERVICE_FORMATTED = DocFlavor.SERVICE_FORMATTED.PRINTABLE;
        return PrintServiceLookup.lookupPrintServices(sERVICE_FORMATTED, new HashPrintRequestAttributeSet());
    }

    public static PrintService getSelectedPrintService(String string) {
        PrintService[] printServiceArray = PrinterUtil.getPrintServices();
        for (int i = 0; i < printServiceArray.length; ++i) {
            String string2 = printServiceArray[i].getName();
            if (!string2.equals(string)) continue;
            return printServiceArray[i];
        }
        return null;
    }

    public static PrintService getDefaultPrintService() {
        return PrintServiceLookup.lookupDefaultPrintService();
    }

    public static MediaSizeName findMedia(String string, float f, float f2, int n) {
        if ("A2".equals(string)) {
            return MediaSizeName.ISO_A2;
        }
        if ("A3".equals(string)) {
            return MediaSizeName.ISO_A3;
        }
        if ("A4".equals(string)) {
            return MediaSizeName.ISO_A4;
        }
        if ("A5".equals(string)) {
            return MediaSizeName.ISO_A5;
        }
        if ("B4".equals(string)) {
            return MediaSizeName.ISO_B4;
        }
        if ("B5".equals(string)) {
            return MediaSizeName.ISO_B5;
        }
        if ("Legal".equals(string)) {
            return MediaSizeName.NA_LEGAL;
        }
        if ("Letter".equals(string)) {
            return MediaSizeName.NA_LETTER;
        }
        try {
            MediaSizeName mediaSizeName = MediaSize.findMedia(f, f2, n);
            if (mediaSizeName != null) {
                return mediaSizeName;
            }
        }
        catch (Exception exception) {
            ElxLoggerJ.getLogger(PrinterUtil.class).warn((Object)("MediaSizeName error: " + exception), (Throwable)exception);
        }
        return null;
    }

    public static PageFormat getPageFormat(IEye.PageSetup pageSetup) {
        Paper paper = new Paper();
        PageFormat pageFormat = new PageFormat();
        if (pageSetup.orientation == 2) {
            paper.setSize((float)pageSetup.height / 20.0f, (float)pageSetup.width / 20.0f);
            paper.setImageableArea(0.0, 0.0, (float)pageSetup.height / 20.0f, (float)pageSetup.width / 20.0f);
            pageFormat.setOrientation(0);
        } else {
            paper.setSize((float)pageSetup.width / 20.0f, (float)pageSetup.height / 20.0f);
            paper.setImageableArea(0.0, 0.0, (float)pageSetup.width / 20.0f, (float)pageSetup.height / 20.0f);
            pageFormat.setOrientation(1);
        }
        pageFormat.setPaper(paper);
        return pageFormat;
    }

    public static PageFormat getScaledPageFormat(IEye.PageSetup pageSetup, Dimension dimension) {
        assert (dimension != null);
        Paper paper = new Paper();
        PageFormat pageFormat = new PageFormat();
        double d = dimension.width;
        double d2 = dimension.height;
        if (pageSetup.orientation == 2) {
            double d3 = d / (double)pageSetup.height;
            double d4 = d2 / (double)pageSetup.width;
            double d5 = Math.min(d3, d4);
            int n = (int)((double)pageSetup.height * d5 / 20.0);
            int n2 = (int)((double)pageSetup.width * d5 / 20.0);
            paper.setSize(n, n2);
            paper.setImageableArea(0.0, 0.0, n, n2);
            pageFormat.setOrientation(0);
        } else {
            double d6 = d / (double)pageSetup.width;
            double d7 = d2 / (double)pageSetup.height;
            double d8 = Math.min(d6, d7);
            int n = (int)((double)pageSetup.width * d8 / 20.0);
            int n3 = (int)((double)pageSetup.height * d8 / 20.0);
            paper.setSize(n, n3);
            paper.setImageableArea(0.0, 0.0, n, n3);
            pageFormat.setOrientation(1);
        }
        pageFormat.setPaper(paper);
        return pageFormat;
    }
}

