/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.glint.splitter;

import com.elixirtech.glint.EyeReader;
import com.elixirtech.glint.EyeWriter;
import java.awt.Dimension;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class SplitFirstPage {
    private byte[] m_First;
    private byte[] m_Rest;

    public SplitFirstPage(InputStream inputStream) throws IOException {
        EyeReader eyeReader = new EyeReader(inputStream);
        int n = eyeReader.getPageCount();
        if (n > 0) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            EyeWriter eyeWriter = new EyeWriter("head", byteArrayOutputStream, true);
            eyeWriter.setSize(new Dimension(eyeReader.getWidth(), eyeReader.getHeight()));
            eyeWriter.setResources(eyeReader.getResources(0));
            eyeWriter.addGlint(eyeReader.getPage(1));
            eyeWriter.close();
            this.m_First = byteArrayOutputStream.toByteArray();
            if (n > 1) {
                ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
                EyeWriter eyeWriter2 = new EyeWriter("tail", byteArrayOutputStream2, true);
                eyeWriter2.setSize(new Dimension(eyeReader.getWidth(), eyeReader.getHeight()));
                eyeWriter2.setResources(eyeReader.getResources(0));
                for (int i = 2; i <= n; ++i) {
                    eyeWriter2.addGlint(eyeReader.getPage(i));
                }
                eyeWriter2.close();
                this.m_Rest = byteArrayOutputStream2.toByteArray();
            }
        }
    }

    public InputStream getFirst() {
        return new ByteArrayInputStream(this.m_First);
    }

    public InputStream getRest() {
        return new ByteArrayInputStream(this.m_Rest);
    }
}

