/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.graphics;

import com.elixirtech.graphics.BorderStyle;
import com.elixirtech.graphics.ILineDrawable;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class GLine {
    public static final BasicStroke ARROW_STROKE = new BasicStroke();
    public static final String SYMMETRIC_ARROW = "Symmetric-Arrow";
    public static final String ARROW = "Arrow";
    public static final String DIAMOND = "Diamond";
    public static final String OPEN_ARROW = "Open-Arrow";
    public static final String SQUARE = "Square";
    public static final String LINE = "Line";
    public static final String ROUND = "Round";
    public static final String NONE = "None";
    static final String[] ARROW_STYLES = new String[]{"Symmetric-Arrow", "Arrow", "Diamond", "Open-Arrow", "Square", "Line", "Round"};
    private int m_Arrow1Width;
    private int m_Arrow2Width;
    private Color m_Arrow1Color = Color.BLACK;
    private Color m_Arrow2Color = Color.BLACK;
    private String m_ArrowStyle1;
    private String m_ArrowStyle2;
    private BorderStyle m_LineStyle;
    private int m_LineWidth;
    private Color m_LineColor = Color.BLACK;
    private Line2D m_Line2D = new Line2D.Double();

    public void draw(ILineDrawable iLineDrawable) {
        iLineDrawable.setColor(this.m_LineColor);
        if (this.m_LineStyle.ID != 0) {
            Stroke stroke = BorderStyle.getStroke(this.m_LineWidth, this.m_LineStyle.ID);
            iLineDrawable.setStroke(stroke);
            int n = GLine.insetArrow(this.m_ArrowStyle1, this.m_Arrow1Width);
            int n2 = GLine.insetArrow(this.m_ArrowStyle2, this.m_Arrow2Width);
            if (n > 0 || n2 > 0) {
                double d = this.m_Line2D.getX1();
                double d2 = this.m_Line2D.getY1();
                double d3 = this.m_Line2D.getX2();
                double d4 = this.m_Line2D.getY2();
                double d5 = Math.atan2(d2 - d4, d - d3);
                if (n > 0) {
                    d -= Math.cos(d5) * (double)n;
                    d2 -= Math.sin(d5) * (double)n;
                }
                if (n2 > 0) {
                    d3 += Math.cos(d5) * (double)n2;
                    d4 += Math.sin(d5) * (double)n2;
                }
                iLineDrawable.draw(new Line2D.Double(d, d2, d3, d4));
            } else {
                iLineDrawable.draw(this.m_Line2D);
            }
        }
        this.drawArrows(iLineDrawable);
    }

    public static int insetArrow(String string, int n) {
        if (ARROW.equals(string)) {
            return n * 3 / 2;
        }
        if (DIAMOND.equals(string)) {
            return n / 2;
        }
        if (SYMMETRIC_ARROW.equals(string)) {
            return n / 2;
        }
        if (ROUND.equals(string)) {
            return n / 2;
        }
        if (OPEN_ARROW.equals(string)) {
            return n / 2;
        }
        return 0;
    }

    private void drawArrows(ILineDrawable iLineDrawable) {
        iLineDrawable.setStroke(ARROW_STROKE);
        if (this.m_ArrowStyle1 != null && !NONE.equals(this.m_ArrowStyle1)) {
            this.drawArrow(iLineDrawable, this.m_ArrowStyle1, 1, this.m_Arrow1Width, this.m_Arrow1Color, true);
        }
        if (this.m_ArrowStyle2 != null && !NONE.equals(this.m_ArrowStyle2)) {
            this.drawArrow(iLineDrawable, this.m_ArrowStyle2, 2, this.m_Arrow2Width, this.m_Arrow2Color, false);
        }
    }

    public void drawArrow(ILineDrawable iLineDrawable, String string, int n, int n2, Color color, boolean bl) {
        Shape shape = null;
        double d = Math.atan2(this.m_Line2D.getY1() - this.m_Line2D.getY2(), this.m_Line2D.getX1() - this.m_Line2D.getX2());
        float f = (float)n2 / 2.0f;
        boolean bl2 = true;
        if (SYMMETRIC_ARROW.equals(string)) {
            var12_11 = new GeneralPath();
            var12_11.moveTo(-20.0f, 0.0f);
            var12_11.lineTo(n2, -f);
            var12_11.lineTo(n2, f);
            var12_11.closePath();
            shape = var12_11;
        } else if (ARROW.equals(string)) {
            var12_11 = new GeneralPath();
            var12_11.moveTo(-20.0f, 0.0f);
            var12_11.lineTo(n2 * 2, -f);
            var12_11.lineTo(n2 * 2, f);
            var12_11.closePath();
            shape = var12_11;
        } else if (DIAMOND.equals(string)) {
            var12_11 = new GeneralPath();
            var12_11.moveTo(-20.0f, 0.0f);
            var12_11.lineTo(f, -f);
            var12_11.lineTo(n2, 0.0f);
            var12_11.lineTo(f, f);
            var12_11.closePath();
            shape = var12_11;
        } else if (OPEN_ARROW.equals(string)) {
            bl2 = false;
            var12_11 = new GeneralPath();
            Stroke stroke = BorderStyle.getStroke(this.m_LineWidth, 1);
            iLineDrawable.setStroke(stroke);
            var12_11.moveTo(n2 * 2, -f);
            var12_11.lineTo(0.0f, 0.0f);
            var12_11.lineTo(n2 * 2, f);
            shape = var12_11;
        } else if (SQUARE.equals(string)) {
            shape = new Rectangle2D.Double(-20.0, -f, n2, n2);
        } else if (LINE.equals(string)) {
            shape = new Rectangle2D.Double(-20.0, -f, (double)n2 / 6.0, n2);
        } else if (ROUND.equals(string)) {
            shape = new Ellipse2D.Double(-20.0, -f, n2, n2);
        }
        if (shape == null) {
            return;
        }
        double d2 = 0.0;
        double d3 = 0.0;
        if (n == 1) {
            d2 = this.m_Line2D.getX1();
            d3 = this.m_Line2D.getY1();
        } else {
            d2 = this.m_Line2D.getX2();
            d3 = this.m_Line2D.getY2();
        }
        if (bl) {
            d += Math.PI;
        }
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.rotate(d, d2, d3);
        affineTransform.translate(d2, d3);
        Shape shape2 = affineTransform.createTransformedShape(shape);
        iLineDrawable.setColor(color);
        if (bl2) {
            iLineDrawable.fill(shape2);
        } else {
            iLineDrawable.draw(shape2);
        }
    }

    public void setLineStyle(BorderStyle borderStyle) {
        this.m_LineStyle = borderStyle;
    }

    public void setLineWidth(int n) {
        this.m_LineWidth = n;
    }

    public void setLineColor(Color color) {
        this.m_LineColor = color;
    }

    public void setArrow1Color(Color color) {
        this.m_Arrow2Color = color;
    }

    public void setArrow2Color(Color color) {
        this.m_Arrow1Color = color;
    }

    public void setLine(double d, double d2, double d3, double d4) {
        this.m_Line2D.setLine(d, d2, d3, d4);
    }

    public void setLine(Point2D point2D, Point2D point2D2) {
        this.m_Line2D.setLine(point2D, point2D2);
    }

    public Rectangle2D getBounds2D() {
        return this.m_Line2D.getBounds2D();
    }

    public Rectangle getBounds() {
        return this.m_Line2D.getBounds();
    }

    public Line2D getLine2D() {
        return this.m_Line2D;
    }

    public void setArrowStyle1(String string) {
        this.m_ArrowStyle1 = string;
    }

    public void setArrowStyle2(String string) {
        this.m_ArrowStyle2 = string;
    }

    public void setArrowWidth1(int n) {
        this.m_Arrow1Width = n;
    }

    public void setArrowWidth2(int n) {
        this.m_Arrow2Width = n;
    }

    public void setArrowColor1(Color color) {
        this.m_Arrow1Color = color;
    }

    public void setArrowColor2(Color color) {
        this.m_Arrow2Color = color;
    }
}

