/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.graphics;

import com.elixirtech.graphics.BorderStyle;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;

public class GRectangle {
    public static final int LEFT = 1;
    public static final int TOP = 2;
    public static final int RIGHT = 4;
    public static final int BOTTOM = 8;
    public static final int ALL = 15;
    private Rectangle m_Rectangle;
    private Color m_BackgroundColor;
    private BorderStyle m_BorderStyle;
    private int m_BorderWidth;
    private int m_BorderRadiusX;
    private int m_BorderRadiusY;
    private boolean m_Curve;
    private Color m_BorderColor;
    private int m_BorderSides;
    private int m_PaddingLeft;
    private int m_PaddingTop;
    private int m_PaddingRight;
    private int m_PaddingBottom;
    private boolean m_CurvedClip;
    private boolean m_PaddedClip;

    public GRectangle(Rectangle rectangle) {
        this.m_Rectangle = rectangle;
    }

    public void setBackground(Color color) {
        this.m_BackgroundColor = color;
    }

    public Color getBackground() {
        return this.m_BackgroundColor;
    }

    public void setBorder(BorderStyle borderStyle, int n, Color color, int n2) {
        this.m_BorderStyle = borderStyle;
        this.m_BorderWidth = Math.max(0, n);
        this.m_BorderColor = color;
        this.m_BorderSides = n2;
        if (this.m_BorderStyle == null || this.m_BorderStyle == BorderStyle.NONE) {
            this.m_BorderWidth = 0;
            this.m_BorderSides = 0;
        }
    }

    public void setBorderRadius(int n, int n2) {
        this.m_BorderRadiusX = Math.max(0, n);
        this.m_BorderRadiusY = Math.max(0, n2);
        this.m_Curve = this.m_BorderRadiusX > 0 && this.m_BorderRadiusY > 0;
    }

    public void setPadding(int n, int n2, int n3, int n4) {
        this.m_PaddingLeft = n;
        this.m_PaddingTop = n2;
        this.m_PaddingRight = n3;
        this.m_PaddingBottom = n4;
    }

    public void setCurvedClip(boolean bl) {
        this.m_CurvedClip = bl;
    }

    public void setPaddedClip(boolean bl) {
        this.m_PaddedClip = bl;
    }

    public Color getBorderColor() {
        return this.m_BorderColor;
    }

    public boolean willDraw() {
        return this.hasBackground() || this.hasBorder();
    }

    public void draw(Graphics2D graphics2D) {
        this.drawBackground(graphics2D);
        this.drawBorder(graphics2D);
    }

    public void drawBackground(Graphics2D graphics2D) {
        if (this.hasBackground()) {
            graphics2D.setColor(this.m_BackgroundColor);
            if (this.m_Curve) {
                Shape shape = this.getFillPath();
                graphics2D.fill(shape);
            } else {
                graphics2D.fill(this.m_Rectangle);
            }
        }
    }

    public void drawBorder(Graphics2D graphics2D) {
        if (this.hasBorder()) {
            boolean bl;
            graphics2D.setColor(this.m_BorderColor);
            boolean bl2 = bl = this.m_BorderStyle.ID == 4;
            if (bl && this.m_BorderRadiusX == 0 && this.m_BorderRadiusY == 0) {
                this.drawDoubleBorder(graphics2D);
                return;
            }
            Stroke stroke = BorderStyle.getStroke(this.m_BorderWidth, this.m_BorderStyle.ID);
            if (this.m_BorderSides == 15) {
                if (stroke != null) {
                    graphics2D.setStroke(stroke);
                    int n = this.m_BorderWidth / 2;
                    int n2 = this.m_Rectangle.x + n;
                    int n3 = this.m_Rectangle.y + n;
                    int n4 = this.m_Rectangle.width - this.m_BorderWidth;
                    int n5 = this.m_Rectangle.height - this.m_BorderWidth;
                    if (this.m_Curve) {
                        graphics2D.draw(this.getBorderPath());
                    } else {
                        graphics2D.drawRect(n2, n3, n4, n5);
                    }
                } else {
                    this.drawSpecialBorder(graphics2D);
                }
            } else if (stroke != null) {
                Shape shape = null;
                if (bl) {
                    shape = graphics2D.getClip();
                    graphics2D.clip(this.m_Rectangle);
                }
                graphics2D.setStroke(stroke);
                GeneralPath generalPath = this.getBorderPath();
                graphics2D.draw(generalPath);
                if (bl) {
                    graphics2D.setClip(shape);
                }
            } else {
                this.drawSpecialBorder(graphics2D);
            }
        }
    }

    public boolean hasBackground() {
        return this.m_BackgroundColor != null && this.m_BackgroundColor.getAlpha() > 0;
    }

    public boolean hasBorder() {
        return this.m_BorderColor != null && this.m_BorderColor.getAlpha() > 0 && this.m_BorderStyle != null && this.m_BorderSides != 0 && this.m_BorderWidth > 0;
    }

    public Shape getShape() {
        return this.getFillPath();
    }

    public Shape getChildClipShape() {
        int n;
        int n2;
        if (!this.m_Curve || !this.m_CurvedClip) {
            return this.getChildClipRect();
        }
        Rectangle rectangle = this.getChildClipRect();
        int n3 = rectangle.x;
        int n4 = rectangle.y;
        int n5 = rectangle.x + rectangle.width;
        int n6 = rectangle.y + rectangle.height;
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(rectangle.x + rectangle.width / 2, rectangle.y);
        if ((this.m_BorderSides & 6) == 6) {
            n2 = Math.max(0, this.m_BorderRadiusX - this.m_PaddingRight);
            n = Math.max(0, this.m_BorderRadiusY - this.m_PaddingTop);
            if (n == 0) {
                n2 = 0;
            }
            generalPath.lineTo(n5 - n2, n4);
            if (n > 0) {
                generalPath.quadTo(n5, n4, n5, n4 + n);
            }
        } else {
            generalPath.lineTo(n5, n4);
        }
        if ((this.m_BorderSides & 0xC) == 12) {
            n2 = Math.max(0, this.m_BorderRadiusX - this.m_PaddingRight);
            n = Math.max(0, this.m_BorderRadiusY - this.m_PaddingBottom);
            if (n2 == 0) {
                n = 0;
            }
            generalPath.lineTo(n5, n6 - n);
            if (n2 > 0) {
                generalPath.quadTo(n5, n6, n5 - n2, n6);
            }
        } else {
            generalPath.lineTo(n5, n6);
        }
        if ((this.m_BorderSides & 9) == 9) {
            n2 = Math.max(0, this.m_BorderRadiusX - this.m_PaddingLeft);
            n = Math.max(0, this.m_BorderRadiusY - this.m_PaddingBottom);
            if (n == 0) {
                n2 = 0;
            }
            generalPath.lineTo(n3 + n2, n6);
            if (n > 0) {
                generalPath.quadTo(n3, n6, n3, n6 - n);
            }
        } else {
            generalPath.lineTo(n3, n6);
        }
        if ((this.m_BorderSides & 3) == 3) {
            n2 = Math.max(0, this.m_BorderRadiusX - this.m_PaddingLeft);
            n = Math.max(0, this.m_BorderRadiusY - this.m_PaddingBottom);
            if (n2 == 0) {
                n = 0;
            }
            generalPath.lineTo(n3, n4 + n);
            if (n2 > 0) {
                generalPath.quadTo(n3, n4, n3 + n2, n4);
            }
        } else {
            generalPath.lineTo(n3, n4);
        }
        generalPath.closePath();
        return generalPath;
    }

    public Rectangle getChildRect() {
        int n = this.m_Rectangle.x + this.m_PaddingLeft;
        int n2 = this.m_Rectangle.y + this.m_PaddingTop;
        int n3 = this.m_Rectangle.x + this.m_Rectangle.width - this.m_PaddingRight;
        int n4 = this.m_Rectangle.y + this.m_Rectangle.height - this.m_PaddingBottom;
        if ((this.m_BorderSides & 1) != 0) {
            n += this.m_BorderWidth;
        }
        if ((this.m_BorderSides & 2) != 0) {
            n2 += this.m_BorderWidth;
        }
        if ((this.m_BorderSides & 4) != 0) {
            n3 -= this.m_BorderWidth;
        }
        if ((this.m_BorderSides & 8) != 0) {
            n4 -= this.m_BorderWidth;
        }
        return new Rectangle(n, n2, n3 - n, n4 - n2);
    }

    public Rectangle getChildClipRect() {
        int n = this.m_Rectangle.x;
        int n2 = this.m_Rectangle.y;
        int n3 = this.m_Rectangle.x + this.m_Rectangle.width;
        int n4 = this.m_Rectangle.y + this.m_Rectangle.height;
        if (this.m_PaddedClip || this.m_CurvedClip) {
            n += this.m_PaddingLeft;
            n2 += this.m_PaddingTop;
            n3 -= this.m_PaddingRight;
            n4 -= this.m_PaddingBottom;
        }
        if ((this.m_BorderSides & 1) != 0) {
            n += this.m_BorderWidth;
        }
        if ((this.m_BorderSides & 2) != 0) {
            n2 += this.m_BorderWidth;
        }
        if ((this.m_BorderSides & 4) != 0) {
            n3 -= this.m_BorderWidth;
        }
        if ((this.m_BorderSides & 8) != 0) {
            n4 -= this.m_BorderWidth;
        }
        return new Rectangle(n, n2, n3 - n, n4 - n2);
    }

    private void drawSpecialBorder(Graphics2D graphics2D) {
        if (this.m_BorderStyle == BorderStyle.INSET || this.m_BorderStyle == BorderStyle.OUTSET) {
            boolean bl = this.m_BorderStyle == BorderStyle.INSET;
            graphics2D.setColor(bl ? this.m_BorderColor.darker() : this.m_BorderColor.brighter());
            GeneralPath generalPath = this.getTopLeft(this.m_Rectangle, this.m_Rectangle, this.m_BorderWidth, this.m_BorderSides);
            if (generalPath != null) {
                graphics2D.fill(generalPath);
            }
            graphics2D.setColor(bl ? this.m_BorderColor.brighter() : this.m_BorderColor.darker());
            GeneralPath generalPath2 = this.getBottomRight(this.m_Rectangle, this.m_Rectangle, this.m_BorderWidth, this.m_BorderSides);
            if (generalPath2 != null) {
                graphics2D.fill(generalPath2);
            }
        } else if (this.m_BorderStyle == BorderStyle.GROOVE || this.m_BorderStyle == BorderStyle.RIDGE) {
            GeneralPath generalPath;
            boolean bl = this.m_BorderStyle == BorderStyle.GROOVE;
            int n = this.m_BorderWidth / 2;
            int n2 = this.m_Rectangle.x + this.m_Rectangle.width;
            int n3 = this.m_Rectangle.y + this.m_Rectangle.height;
            graphics2D.setColor(this.m_BorderColor);
            graphics2D.setStroke(new BasicStroke(this.m_BorderWidth, 0, 0));
            if ((this.m_BorderSides & 2) != 0) {
                graphics2D.drawLine(this.m_Rectangle.x, this.m_Rectangle.y + n, n2, this.m_Rectangle.y + n);
            }
            if ((this.m_BorderSides & 4) != 0) {
                graphics2D.drawLine(n2 - n, this.m_Rectangle.y, n2 - n, n3);
            }
            if ((this.m_BorderSides & 8) != 0) {
                graphics2D.drawLine(n2, n3 - n, this.m_Rectangle.x, n3 - n);
            }
            if ((this.m_BorderSides & 1) != 0) {
                graphics2D.drawLine(this.m_Rectangle.x + n, n3, this.m_Rectangle.x + n, this.m_Rectangle.y);
            }
            int n4 = this.m_BorderWidth / 3;
            int n5 = this.m_Rectangle.x + 2 * n4;
            int n6 = this.m_Rectangle.y + 2 * n4;
            int n7 = this.m_Rectangle.width - 4 * n4;
            int n8 = this.m_Rectangle.height - 4 * n4;
            Rectangle rectangle = new Rectangle(n5, n6, n7, n8);
            graphics2D.setColor(bl ? this.m_BorderColor.brighter() : this.m_BorderColor.darker());
            GeneralPath generalPath3 = this.getTopLeft(rectangle, this.m_Rectangle, n4, this.m_BorderSides);
            if (generalPath3 != null) {
                graphics2D.fill(generalPath3);
            }
            if ((generalPath = this.getBottomRight(this.m_Rectangle, this.m_Rectangle, n4, this.m_BorderSides)) != null) {
                graphics2D.fill(generalPath);
            }
            graphics2D.setColor(bl ? this.m_BorderColor.darker() : this.m_BorderColor.brighter());
            generalPath3 = this.getTopLeft(this.m_Rectangle, this.m_Rectangle, n4, this.m_BorderSides);
            if (generalPath3 != null) {
                graphics2D.fill(generalPath3);
            }
            if ((generalPath = this.getBottomRight(rectangle, this.m_Rectangle, n4, this.m_BorderSides)) != null) {
                graphics2D.fill(generalPath);
            }
        }
    }

    private void drawDoubleBorder(Graphics2D graphics2D) {
        int n;
        int n2;
        int n3 = this.m_BorderWidth / 3;
        int n4 = this.m_BorderWidth * 2 / 3;
        graphics2D.setColor(this.m_BorderColor);
        Insets insets = new Insets(0, 0, 0, 0);
        if ((this.m_BorderSides & 2) != 0) {
            insets.top = n4;
        }
        if ((this.m_BorderSides & 8) != 0) {
            insets.bottom = n4;
        }
        if ((this.m_BorderSides & 1) != 0) {
            insets.left = n4;
        }
        if ((this.m_BorderSides & 4) != 0) {
            insets.right = n4;
        }
        if ((this.m_BorderSides & 2) != 0) {
            graphics2D.fillRect(this.m_Rectangle.x, this.m_Rectangle.y, this.m_Rectangle.width, n3);
            n2 = insets.left + insets.right;
            if (insets.right > 0) {
                ++n2;
            }
            graphics2D.fillRect(this.m_Rectangle.x + insets.left, this.m_Rectangle.y + n4, this.m_Rectangle.width - n2, n3);
        }
        if ((this.m_BorderSides & 8) != 0) {
            n2 = this.m_Rectangle.y + this.m_Rectangle.height;
            graphics2D.fillRect(this.m_Rectangle.x, n2 - n3, this.m_Rectangle.width, n3);
            n = insets.left + insets.right;
            if (insets.right > 0) {
                ++n;
            }
            graphics2D.fillRect(this.m_Rectangle.x + insets.left, n2 - this.m_BorderWidth, this.m_Rectangle.width - n, n3);
        }
        if ((this.m_BorderSides & 1) != 0) {
            graphics2D.fillRect(this.m_Rectangle.x, this.m_Rectangle.y, n3, this.m_Rectangle.height);
            n2 = insets.top + insets.bottom;
            if (insets.bottom > 0) {
                ++n2;
            }
            graphics2D.fillRect(this.m_Rectangle.x + n4, this.m_Rectangle.y + insets.top, n3, this.m_Rectangle.height - n2);
        }
        if ((this.m_BorderSides & 4) != 0) {
            n2 = this.m_Rectangle.x + this.m_Rectangle.width;
            graphics2D.fillRect(n2 - n3, this.m_Rectangle.y, n3, this.m_Rectangle.height);
            n = insets.top + insets.bottom;
            if (insets.bottom > 0) {
                ++n;
            }
            graphics2D.fillRect(n2 - this.m_BorderWidth, this.m_Rectangle.y + insets.top, n3, this.m_Rectangle.height - n);
        }
    }

    public Shape getFillPath() {
        if (this.m_Curve) {
            int n = this.m_BorderWidth / 2;
            int n2 = this.m_Rectangle.width / 2;
            int n3 = this.m_Rectangle.height / 2;
            int n4 = Math.min(this.m_BorderRadiusX + n, n2);
            int n5 = Math.min(this.m_BorderRadiusY + n, n3);
            int n6 = this.m_Rectangle.x + this.m_Rectangle.width;
            int n7 = this.m_Rectangle.y + this.m_Rectangle.height;
            GeneralPath generalPath = new GeneralPath();
            generalPath.moveTo(this.m_Rectangle.x + this.m_Rectangle.width / 2, this.m_Rectangle.y);
            if ((this.m_BorderSides & 6) == 6) {
                generalPath.lineTo(n6 - n4, this.m_Rectangle.y);
                generalPath.quadTo(n6, this.m_Rectangle.y, n6, this.m_Rectangle.y + n5);
            } else {
                generalPath.lineTo(n6, this.m_Rectangle.y);
            }
            if ((this.m_BorderSides & 0xC) == 12) {
                generalPath.lineTo(n6, n7 - n5);
                generalPath.quadTo(n6, n7, n6 - n4, n7);
            } else {
                generalPath.lineTo(n6, n7);
            }
            if ((this.m_BorderSides & 9) == 9) {
                generalPath.lineTo(this.m_Rectangle.x + n4, n7);
                generalPath.quadTo(this.m_Rectangle.x, n7, this.m_Rectangle.x, n7 - n5);
            } else {
                generalPath.lineTo(this.m_Rectangle.x, n7);
            }
            if ((this.m_BorderSides & 3) == 3) {
                generalPath.lineTo(this.m_Rectangle.x, this.m_Rectangle.y + n5);
                generalPath.quadTo(this.m_Rectangle.x, this.m_Rectangle.y, this.m_Rectangle.x + n4, this.m_Rectangle.y);
            } else {
                generalPath.lineTo(this.m_Rectangle.x, this.m_Rectangle.y);
            }
            generalPath.closePath();
            return generalPath;
        }
        return this.m_Rectangle;
    }

    public GeneralPath getBorderPath() {
        int n = this.m_BorderWidth / 2;
        int n2 = this.m_Rectangle.x + n;
        int n3 = this.m_Rectangle.y + n;
        int n4 = this.m_Rectangle.x + this.m_Rectangle.width - n;
        int n5 = this.m_Rectangle.y + this.m_Rectangle.height - n;
        int n6 = Math.min(this.m_BorderRadiusX, (n4 - n2) / 2);
        int n7 = Math.min(this.m_BorderRadiusY, (n5 - n3) / 2);
        if (n6 > 0) {
            n6 += n / 2;
        }
        if (n7 > 0) {
            n7 += n / 2;
        }
        switch (this.m_BorderSides) {
            case 15: {
                GeneralPath generalPath = new GeneralPath();
                if (this.m_Curve) {
                    generalPath.moveTo(n2 + n6, n3);
                    generalPath.lineTo(n4 - n6, n3);
                    generalPath.quadTo(n4, n3, n4, n3 + n7);
                    generalPath.lineTo(n4, n5 - n7);
                    generalPath.quadTo(n4, n5, n4 - n6, n5);
                    generalPath.lineTo(n2 + n6, n5);
                    generalPath.quadTo(n2, n5, n2, n5 - n7);
                    generalPath.lineTo(n2, n3 + n7);
                    generalPath.quadTo(n2, n3, n2 + n6, n3);
                    generalPath.closePath();
                } else {
                    generalPath.moveTo(n2, n3);
                    generalPath.lineTo(n4, n3);
                    generalPath.lineTo(n4, n5);
                    generalPath.lineTo(n2, n5);
                    generalPath.closePath();
                }
                return generalPath;
            }
            case 7: {
                GeneralPath generalPath = new GeneralPath();
                generalPath.moveTo(n2, n5 += n);
                if (this.m_Curve) {
                    generalPath.lineTo(n2, n3 + n7);
                    generalPath.quadTo(n2, n3, n2 + n6, n3);
                    generalPath.lineTo(n4 - n6, n3);
                    generalPath.quadTo(n4, n3, n4, n3 + n7);
                    generalPath.lineTo(n4, n5);
                } else {
                    generalPath.lineTo(n2, n3);
                    generalPath.lineTo(n4, n3);
                    generalPath.lineTo(n4, n5);
                }
                return generalPath;
            }
            case 11: {
                GeneralPath generalPath = new GeneralPath();
                generalPath.moveTo(n4 += n, n5);
                if (this.m_Curve) {
                    generalPath.lineTo(n2 + n6, n5);
                    generalPath.quadTo(n2, n5, n2, n5 - n7);
                    generalPath.lineTo(n2, n3 + n7);
                    generalPath.quadTo(n2, n3, n2 + n6, n3);
                    generalPath.lineTo(n4, n3);
                } else {
                    generalPath.lineTo(n2, n5);
                    generalPath.lineTo(n2, n3);
                    generalPath.lineTo(n4, n3);
                }
                return generalPath;
            }
            case 13: {
                GeneralPath generalPath = new GeneralPath();
                generalPath.moveTo(n4, n3 -= n);
                if (this.m_Curve) {
                    generalPath.lineTo(n4, n5 - n7);
                    generalPath.quadTo(n4, n5, n4 - n6, n5);
                    generalPath.lineTo(n2 + n6, n5);
                    generalPath.quadTo(n2, n5, n2, n5 - n7);
                    generalPath.lineTo(n2, n3);
                } else {
                    generalPath.lineTo(n4, n5);
                    generalPath.lineTo(n2, n5);
                    generalPath.lineTo(n2, n3);
                }
                return generalPath;
            }
            case 14: {
                GeneralPath generalPath = new GeneralPath();
                generalPath.moveTo(n2 -= n, n3);
                if (this.m_Curve) {
                    generalPath.lineTo(n4 - n6, n3);
                    generalPath.quadTo(n4, n3, n4, n3 + n7);
                    generalPath.lineTo(n4, n5 - n7);
                    generalPath.quadTo(n4, n5, n4 - n6, n5);
                    generalPath.lineTo(n2, n5);
                } else {
                    generalPath.lineTo(n4, n3);
                    generalPath.lineTo(n4, n5);
                    generalPath.lineTo(n2, n5);
                }
                return generalPath;
            }
            case 3: {
                GeneralPath generalPath = new GeneralPath();
                n4 += n;
                generalPath.moveTo(n2, n5 += n);
                if (this.m_Curve) {
                    generalPath.lineTo(n2, n3 + n7);
                    generalPath.quadTo(n2, n3, n2 + n6, n3);
                    generalPath.lineTo(n4, n3);
                } else {
                    generalPath.lineTo(n2, n3);
                    generalPath.lineTo(n4, n3);
                }
                return generalPath;
            }
            case 6: {
                GeneralPath generalPath = new GeneralPath();
                n5 += n;
                generalPath.moveTo(n2 -= n, n3);
                if (this.m_Curve) {
                    generalPath.lineTo(n4 - n6, n3);
                    generalPath.quadTo(n4, n3, n4, n3 + n7);
                    generalPath.lineTo(n4, n5);
                } else {
                    generalPath.lineTo(n4, n3);
                    generalPath.lineTo(n4, n5);
                }
                return generalPath;
            }
            case 12: {
                GeneralPath generalPath = new GeneralPath();
                n2 -= n;
                generalPath.moveTo(n4, n3 -= n);
                if (this.m_Curve) {
                    generalPath.lineTo(n4, n5 - n7);
                    generalPath.quadTo(n4, n5, n4 - n6, n5);
                    generalPath.lineTo(n2, n5);
                } else {
                    generalPath.lineTo(n4, n5);
                    generalPath.lineTo(n2, n5);
                }
                return generalPath;
            }
            case 9: {
                GeneralPath generalPath = new GeneralPath();
                n3 -= n;
                generalPath.moveTo(n4 += n, n5);
                if (this.m_Curve) {
                    generalPath.lineTo(n2 + n6, n5);
                    generalPath.quadTo(n2, n5, n2, n5 - n7);
                    generalPath.lineTo(n2, n3);
                } else {
                    generalPath.lineTo(n2, n5);
                    generalPath.lineTo(n2, n3);
                }
                return generalPath;
            }
        }
        GeneralPath generalPath = new GeneralPath();
        if ((this.m_BorderSides & 1) != 0) {
            generalPath.moveTo(n2, n5 + n);
            generalPath.lineTo(n2, n3 - n);
        }
        if ((this.m_BorderSides & 4) != 0) {
            generalPath.moveTo(n4, n5 + n);
            generalPath.lineTo(n4, n3 - n);
        }
        if ((this.m_BorderSides & 2) != 0) {
            generalPath.moveTo(n2 - n, n3);
            generalPath.lineTo(n4 + n, n3);
        }
        if ((this.m_BorderSides & 8) != 0) {
            generalPath.moveTo(n2 - n, n5);
            generalPath.lineTo(n4 + n, n5);
        }
        return generalPath;
    }

    private GeneralPath getTopLeft(Rectangle rectangle, Rectangle rectangle2, int n, int n2) {
        if ((n2 & 3) == 0) {
            return null;
        }
        GeneralPath generalPath = new GeneralPath();
        if (n2 == 15) {
            generalPath.moveTo(rectangle.x, rectangle.y);
            generalPath.lineTo(rectangle.x + rectangle.width, rectangle.y);
            generalPath.lineTo(rectangle.x + rectangle.width - n, rectangle.y + n);
            generalPath.lineTo(rectangle.x + n, rectangle.y + n);
            generalPath.lineTo(rectangle.x + n, rectangle.y + rectangle.height - n);
            generalPath.lineTo(rectangle.x, rectangle.y + rectangle.height);
            generalPath.closePath();
        } else {
            if ((n2 & 2) != 0) {
                generalPath.moveTo(rectangle.x, rectangle.y);
                if ((n2 & 4) == 0) {
                    generalPath.lineTo(rectangle2.x + rectangle2.width, rectangle.y);
                    generalPath.lineTo(rectangle2.x + rectangle2.width, rectangle.y + n);
                } else {
                    generalPath.lineTo(rectangle.x + rectangle.width, rectangle.y);
                    generalPath.lineTo(rectangle.x + rectangle.width - n, rectangle.y + n);
                }
                if ((n2 & 1) == 0) {
                    generalPath.lineTo(rectangle2.x, rectangle.y + n);
                    generalPath.lineTo(rectangle2.x, rectangle.y);
                } else {
                    generalPath.lineTo(rectangle.x + n, rectangle.y + n);
                }
                generalPath.closePath();
            }
            if ((n2 & 1) != 0) {
                generalPath.moveTo(rectangle.x, rectangle.y);
                if ((n2 & 2) == 0) {
                    generalPath.lineTo(rectangle.x, rectangle2.y);
                    generalPath.lineTo(rectangle.x + n, rectangle2.y);
                } else {
                    generalPath.lineTo(rectangle.x + n, rectangle.y + n);
                }
                if ((n2 & 8) == 0) {
                    generalPath.lineTo(rectangle.x + n, rectangle2.y + rectangle2.height);
                    generalPath.lineTo(rectangle.x, rectangle2.y + rectangle2.height);
                } else {
                    generalPath.lineTo(rectangle.x + n, rectangle.y + rectangle.height - n);
                    generalPath.lineTo(rectangle.x, rectangle.y + rectangle.height);
                }
                generalPath.closePath();
            }
        }
        return generalPath;
    }

    private GeneralPath getBottomRight(Rectangle rectangle, Rectangle rectangle2, int n, int n2) {
        if ((n2 & 0xC) == 0) {
            return null;
        }
        int n3 = rectangle.x + rectangle.width;
        int n4 = rectangle.y + rectangle.height;
        GeneralPath generalPath = new GeneralPath();
        if (n2 == 15) {
            generalPath.moveTo(n3, n4);
            generalPath.lineTo(rectangle.x, n4);
            generalPath.lineTo(rectangle.x + n, n4 - n);
            generalPath.lineTo(n3 - n, n4 - n);
            generalPath.lineTo(n3 - n, rectangle.y + n);
            generalPath.lineTo(n3, rectangle.y);
            generalPath.closePath();
        } else {
            if ((n2 & 8) != 0) {
                generalPath.moveTo(n3, n4);
                if ((n2 & 1) == 0) {
                    generalPath.lineTo(rectangle2.x, n4);
                    generalPath.lineTo(rectangle2.x, n4 - n);
                } else {
                    generalPath.lineTo(rectangle.x, n4);
                    generalPath.lineTo(rectangle.x + n, n4 - n);
                }
                if ((n2 & 4) == 0) {
                    generalPath.lineTo(rectangle2.x + rectangle2.width, n4 - n);
                    generalPath.lineTo(rectangle2.x + rectangle2.width, n4);
                } else {
                    generalPath.lineTo(n3 - n, n4 - n);
                }
                generalPath.closePath();
            }
            if ((n2 & 4) != 0) {
                generalPath.moveTo(n3, n4);
                if ((n2 & 8) == 0) {
                    generalPath.lineTo(n3, rectangle2.y + rectangle2.height);
                    generalPath.lineTo(n3 - n, rectangle2.y + rectangle2.height);
                } else {
                    generalPath.lineTo(n3 - n, n4 - n);
                }
                if ((n2 & 2) == 0) {
                    generalPath.lineTo(n3 - n, rectangle2.y);
                    generalPath.lineTo(n3, rectangle2.y);
                } else {
                    generalPath.lineTo(n3 - n, rectangle.y + n);
                    generalPath.lineTo(n3, rectangle.y);
                }
                generalPath.closePath();
            }
        }
        return generalPath;
    }
}

