/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.graphics.font;

import com.elixirtech.glint.ConstBytes;
import com.elixirtech.graphics.Orientation;
import com.elixirtech.graphics.font.Font;
import com.elixirtech.graphics.font.IFontMeasurer;
import com.elixirtech.graphics.font.RotatedGlyphFontMeasurer;
import com.elixirtech.graphics.font.TextLine;
import com.elixirtech.util.CharUtil;
import java.awt.Rectangle;

public class FontBox {
    TextLine m_Line;
    String m_String;
    Font m_Font;
    Rectangle m_Rectangle;
    ConstBytes m_GlyphOrientation;

    public FontBox(String string, Font font, Rectangle rectangle) {
        this.m_String = string;
        this.m_Font = font;
        this.m_Rectangle = rectangle;
    }

    public FontBox(String string, Font font, Rectangle rectangle, TextLine textLine) {
        this.m_String = string;
        this.m_Font = font;
        this.m_Rectangle = rectangle;
        this.m_Line = textLine;
        this.buildOrientation(textLine.getBaselineOrientation(), textLine.getGlyphOrientation());
    }

    public void setLine(TextLine textLine) {
        this.m_Line = textLine;
        this.buildOrientation(textLine.getBaselineOrientation(), textLine.getGlyphOrientation());
    }

    public TextLine getLine() {
        return this.m_Line;
    }

    public String getString() {
        return this.m_String;
    }

    public Font getFont() {
        return this.m_Font;
    }

    public Rectangle getRectangle() {
        return this.m_Rectangle;
    }

    public ConstBytes getGlyphOrientation() {
        return this.m_GlyphOrientation;
    }

    public FontBox[] split(int n, IFontMeasurer iFontMeasurer, boolean bl) {
        int n2;
        assert (n < this.m_Rectangle.width);
        RotatedGlyphFontMeasurer rotatedGlyphFontMeasurer = new RotatedGlyphFontMeasurer(iFontMeasurer);
        FontBox[] fontBoxArray = new FontBox[2];
        int n3 = this.m_String.length();
        int n4 = -1;
        for (n2 = 1; n2 < n3 && rotatedGlyphFontMeasurer.getWidth(this.m_String, this.m_GlyphOrientation, 0, n2) <= n; ++n2) {
            char c = this.m_String.charAt(n2 - 1);
            if (!Character.isSpaceChar(c)) continue;
            n4 = n2 - 1;
        }
        n2 = bl || n4 >= 0 ? n4 + 1 : --n2;
        if (n2 == 0) {
            fontBoxArray[0] = null;
            fontBoxArray[1] = this;
        } else if (n2 == n3) {
            fontBoxArray[0] = this;
            fontBoxArray[1] = null;
        } else {
            String string = this.m_String.substring(0, n2);
            Rectangle rectangle = new Rectangle();
            rectangle.width = rotatedGlyphFontMeasurer.getWidth(this.m_String, this.m_GlyphOrientation, 0, n2);
            rectangle.height = rotatedGlyphFontMeasurer.getHeight(this.m_String, this.m_GlyphOrientation, 0, n2);
            fontBoxArray[0] = new FontBox(string, this.m_Font, rectangle);
            string = this.m_String.substring(n2);
            rectangle = new Rectangle();
            n3 = string.length();
            rectangle.width = rotatedGlyphFontMeasurer.getWidth(this.m_String, this.m_GlyphOrientation, n2, n3);
            rectangle.height = rotatedGlyphFontMeasurer.getHeight(this.m_String, this.m_GlyphOrientation, n2, n3);
            fontBoxArray[1] = new FontBox(string, this.m_Font, rectangle);
        }
        return fontBoxArray;
    }

    public boolean canMerge(FontBox fontBox) {
        return this.m_Font == fontBox.m_Font && this.m_Line == fontBox.m_Line;
    }

    public FontBox merge(FontBox fontBox, IFontMeasurer iFontMeasurer) {
        assert (this.canMerge(fontBox));
        String string = this.m_String + fontBox.m_String;
        Rectangle rectangle = new Rectangle();
        rectangle.width = (int)iFontMeasurer.getWidth(string);
        rectangle.height = (int)iFontMeasurer.getHeight();
        return new FontBox(string, this.m_Font, rectangle, this.m_Line);
    }

    public void buildOrientation(Orientation orientation, Orientation orientation2) {
        if (this.m_GlyphOrientation == null) {
            int n = this.m_String.length();
            byte[] byArray = new byte[n];
            for (int i = 0; i < n; ++i) {
                char c = this.m_String.charAt(i);
                Orientation orientation3 = FontBox.getGlyphOrientation(orientation, orientation2, c);
                byArray[i] = orientation3.getId();
            }
            this.m_GlyphOrientation = new ConstBytes(byArray);
        }
    }

    private static Orientation getGlyphOrientation(Orientation orientation, Orientation orientation2, char c) {
        if (orientation == Orientation.ANGLE_0 && orientation2 == Orientation.ANGLE_0) {
            return orientation2;
        }
        if (CharUtil.isHebrew(c) || CharUtil.isArabic(c) || CharUtil.isSyriac(c)) {
            return Orientation.ANGLE_0;
        }
        if (CharUtil.isCJK(c)) {
            return Orientation.inverse(orientation);
        }
        return orientation2;
    }
}

