/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.graphics.font;

import com.elixirtech.glint.ConstBytes;
import com.elixirtech.graphics.font.IFontMeasurer;

public class RotatedGlyphFontMeasurer {
    private IFontMeasurer m_FontMeasurer;

    public RotatedGlyphFontMeasurer(IFontMeasurer iFontMeasurer) {
        this.m_FontMeasurer = iFontMeasurer;
    }

    public int getWidth(String string, ConstBytes constBytes, int n, int n2) {
        int n3 = n + n2;
        if (this.allFlat(constBytes, n, n2)) {
            String string2 = string.substring(n, n3);
            return (int)this.m_FontMeasurer.getWidth(string2);
        }
        float f = this.m_FontMeasurer.getAscent() + this.m_FontMeasurer.getDescent();
        float f2 = 0.0f;
        for (int i = n; i < n3; ++i) {
            if ((constBytes.get(i) & 1) != 0) {
                f2 += f;
                continue;
            }
            f2 += this.m_FontMeasurer.getCharWidth(string.charAt(i));
        }
        return (int)f2;
    }

    public int getHeight(String string, ConstBytes constBytes, int n, int n2) {
        int n3 = n + n2;
        float f = this.m_FontMeasurer.getHeight();
        if (this.allFlat(constBytes, n, n2)) {
            return (int)f;
        }
        float f2 = 0.0f;
        float f3 = this.m_FontMeasurer.getLeading();
        for (int i = n; i < n3; ++i) {
            f2 = (constBytes.get(i) & 1) != 0 ? Math.max(f2, this.m_FontMeasurer.getCharWidth(string.charAt(i)) + 2.0f * f3) : Math.max(f2, f);
        }
        return (int)f2;
    }

    protected boolean allFlat(ConstBytes constBytes, int n, int n2) {
        for (int i = n; i < n + n2; ++i) {
            if ((constBytes.get(i) & 1) == 0) continue;
            return false;
        }
        return true;
    }
}

